/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.task.SchedulableInstance;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import com.github.kagkarlsson.scheduler.task.TaskInstanceId;
import java.time.Instant;

public class ScheduledTaskInstance
implements TaskInstanceId {
    private final TaskInstance<?> taskInstance;
    private final Instant executionTime;

    public ScheduledTaskInstance(TaskInstance<?> taskInstance, Instant executionTime) {
        this.taskInstance = taskInstance;
        this.executionTime = executionTime;
    }

    public static ScheduledTaskInstance fixExecutionTime(SchedulableInstance<?> schedulableInstance, Clock clock) {
        return new ScheduledTaskInstance(schedulableInstance.getTaskInstance(), schedulableInstance.getNextExecutionTime(clock.now()));
    }

    public TaskInstance<?> getTaskInstance() {
        return this.taskInstance;
    }

    public Instant getExecutionTime() {
        return this.executionTime;
    }

    @Override
    public String getTaskName() {
        return this.taskInstance.getTaskName();
    }

    @Override
    public String getId() {
        return this.taskInstance.getId();
    }
}

