/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SchedulerState {
    public boolean isShuttingDown();

    public boolean isStarted();

    public boolean isPaused();

    public static class SettableSchedulerState
    implements SchedulerState {
        private static final Logger LOG = LoggerFactory.getLogger(SettableSchedulerState.class);
        private boolean isShuttingDown;
        private boolean isStarted;
        private final AtomicBoolean isPaused = new AtomicBoolean(false);

        @Override
        public boolean isShuttingDown() {
            return this.isShuttingDown;
        }

        @Override
        public boolean isStarted() {
            return this.isStarted;
        }

        @Override
        public boolean isPaused() {
            return this.isPaused.get();
        }

        public void setIsShuttingDown() {
            this.isShuttingDown = true;
        }

        public void setStarted() {
            this.isStarted = true;
        }

        public void setPaused(boolean isPaused) {
            boolean isChanged = this.isPaused.compareAndSet(!isPaused, isPaused);
            if (isChanged) {
                LOG.info(isPaused ? "Scheduler is paused." : "Scheduler is resumed.");
            }
        }
    }
}

