/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.ScheduledExecution;
import com.github.kagkarlsson.scheduler.ScheduledExecutionsFilter;
import com.github.kagkarlsson.scheduler.SchedulerName;
import com.github.kagkarlsson.scheduler.StreamUtils;
import com.github.kagkarlsson.scheduler.SystemClock;
import com.github.kagkarlsson.scheduler.TaskRepository;
import com.github.kagkarlsson.scheduler.TaskResolver;
import com.github.kagkarlsson.scheduler.event.SchedulerListeners;
import com.github.kagkarlsson.scheduler.exceptions.TaskInstanceCurrentlyExecutingException;
import com.github.kagkarlsson.scheduler.exceptions.TaskInstanceNotFoundException;
import com.github.kagkarlsson.scheduler.jdbc.AutodetectJdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.JdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.JdbcTaskRepository;
import com.github.kagkarlsson.scheduler.serializer.Serializer;
import com.github.kagkarlsson.scheduler.task.Execution;
import com.github.kagkarlsson.scheduler.task.SchedulableInstance;
import com.github.kagkarlsson.scheduler.task.ScheduledTaskInstance;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import com.github.kagkarlsson.scheduler.task.TaskInstanceId;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SchedulerClient {
    public static final int DEFAULT_BATCH_SIZE = 100;

    public <T> boolean schedule(TaskInstance<T> var1, Instant var2, ScheduleOptions var3);

    public <T> boolean schedule(SchedulableInstance<T> var1, ScheduleOptions var2);

    @Deprecated
    public <T> void schedule(TaskInstance<T> var1, Instant var2);

    @Deprecated
    public <T> void schedule(SchedulableInstance<T> var1);

    public <T> boolean scheduleIfNotExists(TaskInstance<T> var1, Instant var2);

    public <T> boolean scheduleIfNotExists(SchedulableInstance<T> var1);

    public void scheduleBatch(List<TaskInstance<?>> var1, Instant var2);

    public void scheduleBatch(List<SchedulableInstance<?>> var1);

    default public void scheduleBatch(Stream<TaskInstance<?>> taskInstances, Instant executionTime) {
        StreamUtils.chunkStream(taskInstances, 100).forEach(chunk -> this.scheduleBatch((List<TaskInstance<?>>)chunk, executionTime));
    }

    default public void scheduleBatch(Stream<SchedulableInstance<?>> schedulableInstances) {
        StreamUtils.chunkStream(schedulableInstances, 100).forEach(this::scheduleBatch);
    }

    public boolean reschedule(TaskInstanceId var1, Instant var2);

    public <T> boolean reschedule(TaskInstanceId var1, Instant var2, T var3);

    public <T> boolean reschedule(SchedulableInstance<T> var1);

    public void cancel(TaskInstanceId var1);

    public void fetchScheduledExecutions(Consumer<ScheduledExecution<Object>> var1);

    public void fetchScheduledExecutions(ScheduledExecutionsFilter var1, Consumer<ScheduledExecution<Object>> var2);

    default public List<ScheduledExecution<Object>> getScheduledExecutions() {
        ArrayList<ScheduledExecution<Object>> executions = new ArrayList<ScheduledExecution<Object>>();
        this.fetchScheduledExecutions(executions::add);
        return executions;
    }

    default public List<ScheduledExecution<Object>> getScheduledExecutions(ScheduledExecutionsFilter filter) {
        ArrayList<ScheduledExecution<Object>> executions = new ArrayList<ScheduledExecution<Object>>();
        this.fetchScheduledExecutions(filter, executions::add);
        return executions;
    }

    public <T> void fetchScheduledExecutionsForTask(String var1, Class<T> var2, Consumer<ScheduledExecution<T>> var3);

    public <T> void fetchScheduledExecutionsForTask(String var1, Class<T> var2, ScheduledExecutionsFilter var3, Consumer<ScheduledExecution<T>> var4);

    default public <T> List<ScheduledExecution<Object>> getScheduledExecutionsForTask(String taskName) {
        ArrayList<ScheduledExecution<Object>> executions = new ArrayList<ScheduledExecution<Object>>();
        this.fetchScheduledExecutionsForTask(taskName, Object.class, executions::add);
        return executions;
    }

    default public <T> List<ScheduledExecution<T>> getScheduledExecutionsForTask(String taskName, Class<T> dataClass) {
        ArrayList<ScheduledExecution<T>> executions = new ArrayList<ScheduledExecution<T>>();
        this.fetchScheduledExecutionsForTask(taskName, dataClass, executions::add);
        return executions;
    }

    default public <T> List<ScheduledExecution<T>> getScheduledExecutionsForTask(String taskName, Class<T> dataClass, ScheduledExecutionsFilter filter) {
        ArrayList<ScheduledExecution<T>> executions = new ArrayList<ScheduledExecution<T>>();
        this.fetchScheduledExecutionsForTask(taskName, dataClass, filter, executions::add);
        return executions;
    }

    public Optional<ScheduledExecution<Object>> getScheduledExecution(TaskInstanceId var1);

    public static class SchedulerClientName
    implements SchedulerName {
        @Override
        public String getName() {
            return "SchedulerClient";
        }
    }

    public static class StandardSchedulerClient
    implements SchedulerClient {
        private static final Logger LOG = LoggerFactory.getLogger(StandardSchedulerClient.class);
        protected final TaskRepository taskRepository;
        private final Clock clock;
        private final SchedulerListeners schedulerListeners;

        StandardSchedulerClient(TaskRepository taskRepository, Clock clock) {
            this(taskRepository, SchedulerListeners.NOOP, clock);
        }

        StandardSchedulerClient(TaskRepository taskRepository, SchedulerListeners schedulerListeners, Clock clock) {
            this.taskRepository = taskRepository;
            this.schedulerListeners = schedulerListeners;
            this.clock = clock;
        }

        @Override
        public <T> void schedule(TaskInstance<T> taskInstance, Instant executionTime) {
            this.scheduleIfNotExists(taskInstance, executionTime);
        }

        @Override
        public <T> boolean scheduleIfNotExists(TaskInstance<T> taskInstance, Instant executionTime) {
            boolean success = this.taskRepository.createIfNotExists(SchedulableInstance.of(taskInstance, executionTime));
            if (success) {
                this.schedulerListeners.onExecutionScheduled(taskInstance, executionTime);
            }
            return success;
        }

        @Override
        public <T> boolean scheduleIfNotExists(SchedulableInstance<T> schedulableInstance) {
            return this.scheduleIfNotExists(schedulableInstance.getTaskInstance(), schedulableInstance.getNextExecutionTime(this.clock.now()));
        }

        @Override
        public void scheduleBatch(List<TaskInstance<?>> taskInstances, Instant executionTime) {
            List<ScheduledTaskInstance> batchToSchedule = taskInstances.stream().map(taskInstance -> new ScheduledTaskInstance((TaskInstance<?>)taskInstance, executionTime)).collect(Collectors.toList());
            this.taskRepository.createBatch(batchToSchedule);
            this.notifyListenersOfScheduledBatch(batchToSchedule);
        }

        @Override
        public void scheduleBatch(List<SchedulableInstance<?>> schedulableInstances) {
            List<ScheduledTaskInstance> batchToSchedule = schedulableInstances.stream().map(schedulable -> ScheduledTaskInstance.fixExecutionTime(schedulable, this.clock)).collect(Collectors.toList());
            this.taskRepository.createBatch(batchToSchedule);
            this.notifyListenersOfScheduledBatch(batchToSchedule);
        }

        private void notifyListenersOfScheduledBatch(List<ScheduledTaskInstance> batchToSchedule) {
            batchToSchedule.forEach(instance -> this.schedulerListeners.onExecutionScheduled((TaskInstanceId)instance, instance.getExecutionTime()));
        }

        @Override
        public <T> void schedule(SchedulableInstance<T> schedulableInstance) {
            this.schedule(schedulableInstance.getTaskInstance(), schedulableInstance.getNextExecutionTime(this.clock.now()));
        }

        @Override
        public <T> boolean schedule(TaskInstance<T> taskInstance, Instant executionTime, ScheduleOptions scheduleOptions) {
            boolean successfulSchedule = this.scheduleIfNotExists(taskInstance, executionTime);
            if (successfulSchedule) {
                return true;
            }
            ScheduleOptions.WhenExists whenExists = scheduleOptions.getWhenExists();
            if (whenExists == ScheduleOptions.WhenExists.DO_NOTHING) {
                LOG.debug("Task instance already exists. Keeping existing. task-instance={}", taskInstance);
                return false;
            }
            if (whenExists == ScheduleOptions.WhenExists.RESCHEDULE) {
                Optional<ScheduledExecution<Object>> existing = this.getScheduledExecution(taskInstance);
                if (existing.isEmpty()) {
                    LOG.warn("Task-instance should already exist, but failed to find it. It must have been processed and deleted. task-instance={}", taskInstance);
                    return false;
                }
                LOG.debug("Task instance already exists. Rescheduling. task-instance={}", taskInstance);
                return this.reschedule(taskInstance, executionTime, taskInstance.getData());
            }
            throw new IllegalArgumentException("Unknown WhenExists value: " + whenExists);
        }

        @Override
        public <T> boolean schedule(SchedulableInstance<T> schedulableInstance, ScheduleOptions whenExists) {
            return this.schedule(schedulableInstance.getTaskInstance(), schedulableInstance.getNextExecutionTime(this.clock.now()), whenExists);
        }

        @Override
        public boolean reschedule(TaskInstanceId taskInstanceId, Instant newExecutionTime) {
            return this.reschedule(taskInstanceId, newExecutionTime, null);
        }

        @Override
        public <T> boolean reschedule(SchedulableInstance<T> schedulableInstance) {
            return this.reschedule(schedulableInstance, schedulableInstance.getNextExecutionTime(this.clock.now()), schedulableInstance.getTaskInstance().getData());
        }

        @Override
        public <T> boolean reschedule(TaskInstanceId taskInstanceId, Instant newExecutionTime, T newData) {
            String instanceId;
            String taskName = taskInstanceId.getTaskName();
            Execution execution = this.taskRepository.getExecution(taskName, instanceId = taskInstanceId.getId()).orElseThrow(() -> new TaskInstanceNotFoundException(taskName, instanceId));
            if (execution.isPicked()) {
                throw new TaskInstanceCurrentlyExecutingException(taskName, instanceId);
            }
            boolean success = newData == null ? this.taskRepository.reschedule(execution, newExecutionTime, null, null, 0) : this.taskRepository.reschedule(execution, newExecutionTime, newData, null, null, 0);
            if (success) {
                this.schedulerListeners.onExecutionScheduled(taskInstanceId, newExecutionTime);
            } else {
                LOG.warn("Failed to reschedule task instance: {}", (Object)taskInstanceId);
            }
            return success;
        }

        @Override
        public void cancel(TaskInstanceId taskInstanceId) {
            String instanceId;
            String taskName = taskInstanceId.getTaskName();
            Optional<Execution> execution = this.taskRepository.getExecution(taskName, instanceId = taskInstanceId.getId());
            if (execution.isPresent()) {
                if (execution.get().isPicked()) {
                    throw new TaskInstanceCurrentlyExecutingException(taskName, instanceId);
                }
            } else {
                throw new TaskInstanceNotFoundException(taskName, instanceId);
            }
            this.taskRepository.remove(execution.get());
        }

        @Override
        public void fetchScheduledExecutions(Consumer<ScheduledExecution<Object>> consumer) {
            this.fetchScheduledExecutions(ScheduledExecutionsFilter.all().withPicked(false), consumer);
        }

        @Override
        public void fetchScheduledExecutions(ScheduledExecutionsFilter filter, Consumer<ScheduledExecution<Object>> consumer) {
            this.taskRepository.getScheduledExecutions(filter, execution -> consumer.accept(new ScheduledExecution<Object>(Object.class, (Execution)execution)));
        }

        @Override
        public <T> void fetchScheduledExecutionsForTask(String taskName, Class<T> dataClass, Consumer<ScheduledExecution<T>> consumer) {
            this.fetchScheduledExecutionsForTask(taskName, dataClass, ScheduledExecutionsFilter.all().withPicked(false), consumer);
        }

        @Override
        public <T> void fetchScheduledExecutionsForTask(String taskName, Class<T> dataClass, ScheduledExecutionsFilter filter, Consumer<ScheduledExecution<T>> consumer) {
            this.taskRepository.getScheduledExecutions(filter, taskName, execution -> consumer.accept(new ScheduledExecution(dataClass, (Execution)execution)));
        }

        @Override
        public Optional<ScheduledExecution<Object>> getScheduledExecution(TaskInstanceId taskInstanceId) {
            Optional<Execution> e = this.taskRepository.getExecution(taskInstanceId.getTaskName(), taskInstanceId.getId());
            return e.map(oe -> new ScheduledExecution<Object>(Object.class, (Execution)oe));
        }
    }

    public static class Builder {
        private final DataSource dataSource;
        private List<Task<?>> knownTasks;
        private Serializer serializer = Serializer.DEFAULT_JAVA_SERIALIZER;
        private String tableName = "scheduled_tasks";
        private JdbcCustomization jdbcCustomization;
        private boolean priority = false;

        private Builder(DataSource dataSource, List<Task<?>> knownTasks) {
            this.dataSource = dataSource;
            this.knownTasks = knownTasks;
        }

        public static Builder create(DataSource dataSource, Task<?> ... knownTasks) {
            return new Builder(dataSource, Arrays.asList(knownTasks));
        }

        public static Builder create(DataSource dataSource, List<Task<?>> knownTasks) {
            return new Builder(dataSource, knownTasks);
        }

        public Builder serializer(Serializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder enablePriority() {
            this.priority = true;
            return this;
        }

        public Builder jdbcCustomization(JdbcCustomization jdbcCustomization) {
            this.jdbcCustomization = jdbcCustomization;
            return this;
        }

        public SchedulerClient build() {
            SystemClock clock = new SystemClock();
            TaskResolver taskResolver = new TaskResolver(SchedulerListeners.NOOP, clock, this.knownTasks);
            JdbcCustomization jdbcCustomization = Optional.ofNullable(this.jdbcCustomization).orElseGet(() -> new AutodetectJdbcCustomization(this.dataSource));
            JdbcTaskRepository taskRepository = new JdbcTaskRepository(this.dataSource, false, jdbcCustomization, this.tableName, taskResolver, new SchedulerClientName(), this.serializer, this.priority, clock);
            return new StandardSchedulerClient(taskRepository, clock);
        }
    }

    public static class ScheduleOptions {
        public static final ScheduleOptions WHEN_EXISTS_DO_NOTHING = ScheduleOptions.defaultOptions().whenExistsDoNothing();
        public static final ScheduleOptions WHEN_EXISTS_RESCHEDULE = ScheduleOptions.defaultOptions().whenExistsReschedule();
        private WhenExists whenExists;

        public static ScheduleOptions defaultOptions() {
            return new ScheduleOptions();
        }

        public ScheduleOptions whenExistsReschedule() {
            this.whenExists = WhenExists.RESCHEDULE;
            return this;
        }

        public ScheduleOptions whenExistsDoNothing() {
            this.whenExists = WhenExists.DO_NOTHING;
            return this;
        }

        public WhenExists getWhenExists() {
            return this.whenExists;
        }

        public static enum WhenExists {
            RESCHEDULE,
            DO_NOTHING;

        }
    }
}

