/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.CurrentlyExecuting;
import com.github.kagkarlsson.scheduler.ExceptionUtils;
import com.github.kagkarlsson.scheduler.Executor;
import com.github.kagkarlsson.scheduler.HeartbeatConfig;
import com.github.kagkarlsson.scheduler.SchedulerClient;
import com.github.kagkarlsson.scheduler.SchedulerState;
import com.github.kagkarlsson.scheduler.TaskRepository;
import com.github.kagkarlsson.scheduler.TaskResolver;
import com.github.kagkarlsson.scheduler.event.ExecutionChain;
import com.github.kagkarlsson.scheduler.event.ExecutionInterceptor;
import com.github.kagkarlsson.scheduler.event.SchedulerListener;
import com.github.kagkarlsson.scheduler.event.SchedulerListeners;
import com.github.kagkarlsson.scheduler.logging.ConfigurableLogger;
import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.Execution;
import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.ExecutionContext;
import com.github.kagkarlsson.scheduler.task.ExecutionHandler;
import com.github.kagkarlsson.scheduler.task.ExecutionOperations;
import com.github.kagkarlsson.scheduler.task.Task;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExecutePicked
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutePicked.class);
    private final Executor executor;
    private final TaskRepository taskRepository;
    private final SchedulerClient schedulerClient;
    private final SchedulerListeners schedulerListeners;
    private final List<ExecutionInterceptor> executionInterceptors;
    private final TaskResolver taskResolver;
    private final SchedulerState schedulerState;
    private final ConfigurableLogger failureLogger;
    private final Clock clock;
    private HeartbeatConfig heartbeatConfig;
    private final Execution pickedExecution;

    public ExecutePicked(Executor executor, TaskRepository taskRepository, SchedulerClient schedulerClient, SchedulerListeners schedulerListeners, List<ExecutionInterceptor> executionInterceptors, TaskResolver taskResolver, SchedulerState schedulerState, ConfigurableLogger failureLogger, Clock clock, HeartbeatConfig heartbeatConfig, Execution pickedExecution) {
        this.executor = executor;
        this.taskRepository = taskRepository;
        this.schedulerClient = schedulerClient;
        this.schedulerListeners = schedulerListeners;
        this.executionInterceptors = executionInterceptors;
        this.taskResolver = taskResolver;
        this.schedulerState = schedulerState;
        this.failureLogger = failureLogger;
        this.clock = clock;
        this.heartbeatConfig = heartbeatConfig;
        this.pickedExecution = pickedExecution;
    }

    @Override
    public void run() {
        CurrentlyExecuting currentlyExecuting = new CurrentlyExecuting(this.pickedExecution, this.clock, this.heartbeatConfig);
        UUID executionId = this.executor.addCurrentlyProcessing(currentlyExecuting);
        try {
            this.schedulerListeners.onCandidateEvent(SchedulerListener.CandidateEventType.EXECUTED);
            this.schedulerListeners.onExecutionStart(currentlyExecuting);
            this.executePickedExecution(this.pickedExecution, currentlyExecuting);
        }
        finally {
            this.executor.removeCurrentlyProcessing(executionId);
        }
    }

    private void executePickedExecution(Execution execution, CurrentlyExecuting currentlyExecuting) {
        Optional<Task> task = this.taskResolver.resolve(execution.taskInstance.getTaskName());
        if (task.isEmpty()) {
            LOG.error("Failed to find implementation for task with name '{}'. Should have been excluded in JdbcRepository.", (Object)execution.taskInstance.getTaskName());
            this.schedulerListeners.onSchedulerEvent(SchedulerListener.SchedulerEventType.UNEXPECTED_ERROR);
            return;
        }
        Instant executionStarted = this.clock.now();
        try {
            LOG.debug("Executing: " + execution);
            ExecutionHandler handler = task.get();
            ExecutionContext executionContext = new ExecutionContext(this.schedulerState, execution, this.schedulerClient, currentlyExecuting);
            ExecutionChain chain = new ExecutionChain(new ArrayList<ExecutionInterceptor>(this.executionInterceptors), handler);
            CompletionHandler<?> completion = chain.proceed(execution.taskInstance, executionContext);
            LOG.debug("Execution done: " + execution);
            this.complete(completion, execution, executionStarted);
        }
        catch (RuntimeException unhandledException) {
            this.failure(task.get(), execution, unhandledException, executionStarted, "Unhandled exception");
        }
        catch (Throwable unhandledError) {
            this.failure(task.get(), execution, unhandledError, executionStarted, "Error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete(CompletionHandler completion, Execution execution, Instant executionStarted) {
        ExecutionComplete completeEvent = ExecutionComplete.success(execution, executionStarted, this.clock.now());
        try {
            completion.complete(completeEvent, new ExecutionOperations(this.taskRepository, this.schedulerListeners, execution));
        }
        catch (Throwable e) {
            this.schedulerListeners.onSchedulerEvent(SchedulerListener.SchedulerEventType.COMPLETIONHANDLER_ERROR);
            this.schedulerListeners.onSchedulerEvent(SchedulerListener.SchedulerEventType.UNEXPECTED_ERROR);
            LOG.error("Failed while completing execution {}, because {}. Execution will likely remain scheduled and locked/picked. The execution should be detected as dead after a while, and handled according to the tasks DeadExecutionHandler.", new Object[]{execution, ExceptionUtils.describe(e), e});
        }
        finally {
            this.schedulerListeners.onExecutionComplete(completeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failure(Task task, Execution execution, Throwable cause, Instant executionStarted, String errorMessagePrefix) {
        String logMessage = "{} {} during execution of task with name '{}'. Treating as failure.";
        this.failureLogger.log(logMessage, cause, errorMessagePrefix, ExceptionUtils.describe(cause), task.getName());
        ExecutionComplete completeEvent = ExecutionComplete.failure(execution, executionStarted, this.clock.now(), cause);
        try {
            task.getFailureHandler().onFailure(completeEvent, new ExecutionOperations(this.taskRepository, this.schedulerListeners, execution));
        }
        catch (Throwable e) {
            this.schedulerListeners.onSchedulerEvent(SchedulerListener.SchedulerEventType.FAILUREHANDLER_ERROR);
            this.schedulerListeners.onSchedulerEvent(SchedulerListener.SchedulerEventType.UNEXPECTED_ERROR);
            LOG.error("Failed while completing execution {}, because {}. Execution will likely remain scheduled and locked/picked. The execution should be detected as dead after a while, and handled according to the tasks DeadExecutionHandler.", new Object[]{execution, ExceptionUtils.describe(cause), e});
        }
        finally {
            this.schedulerListeners.onExecutionComplete(completeEvent);
        }
    }
}

