/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.testhelper;

import com.github.kagkarlsson.scheduler.PollingStrategyConfig;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.SchedulerName;
import com.github.kagkarlsson.scheduler.TaskRepository;
import com.github.kagkarlsson.scheduler.TaskResolver;
import com.github.kagkarlsson.scheduler.Waiter;
import com.github.kagkarlsson.scheduler.event.ExecutionInterceptor;
import com.github.kagkarlsson.scheduler.event.SchedulerListener;
import com.github.kagkarlsson.scheduler.logging.LogLevel;
import com.github.kagkarlsson.scheduler.task.OnStartup;
import com.github.kagkarlsson.scheduler.testhelper.SettableClock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManualScheduler
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(ManualScheduler.class);
    private final SettableClock clock;

    ManualScheduler(SettableClock clock, TaskRepository schedulerTaskRepository, TaskRepository clientTaskRepository, TaskResolver taskResolver, int maxThreads, ExecutorService executorService, SchedulerName schedulerName, Waiter waiter, Duration heartbeatInterval, boolean executeImmediately, List<SchedulerListener> schedulerListeners, PollingStrategyConfig pollingStrategyConfig, Duration deleteUnresolvedAfter, LogLevel logLevel, boolean logStackTrace, List<OnStartup> onStartup, ExecutorService dueExecutor, ScheduledExecutorService houseKeeperExecutor, boolean priorityEnabled) {
        super(clock, schedulerTaskRepository, clientTaskRepository, taskResolver, maxThreads, executorService, schedulerName, waiter, heartbeatInterval, 6, schedulerListeners, new ArrayList<ExecutionInterceptor>(), pollingStrategyConfig, deleteUnresolvedAfter, Duration.ZERO, logLevel, logStackTrace, onStartup, dueExecutor, houseKeeperExecutor);
        this.clock = clock;
    }

    public SettableClock getClock() {
        return this.clock;
    }

    public void tick(Duration moveClockForward) {
        this.clock.set(this.clock.now.plus(moveClockForward));
    }

    public void setTime(Instant newtime) {
        this.clock.set(newtime);
    }

    public void runAnyDueExecutions() {
        this.executeDueStrategy.run();
    }

    public void runDeadExecutionDetection() {
        super.detectDeadExecutions();
    }

    @Override
    public void start() {
        LOG.info("Starting manual scheduler. Executing on-startup tasks.");
        this.executeOnStartup();
    }
}

