/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.stats;

import com.github.kagkarlsson.scheduler.CurrentlyExecuting;
import com.github.kagkarlsson.scheduler.event.SchedulerListener;
import com.github.kagkarlsson.scheduler.stats.StatsRegistry;
import com.github.kagkarlsson.scheduler.task.Execution;
import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.TaskInstanceId;
import java.time.Instant;

public class StatsRegistryAdapter
implements SchedulerListener {
    private final StatsRegistry statsRegistry;

    public StatsRegistryAdapter(StatsRegistry statsRegistry) {
        this.statsRegistry = statsRegistry;
    }

    @Override
    public void onExecutionScheduled(TaskInstanceId taskInstanceId, Instant executionTime) {
    }

    @Override
    public void onExecutionStart(CurrentlyExecuting currentlyExecuting) {
    }

    @Override
    public void onExecutionComplete(ExecutionComplete executionComplete) {
        if (this.statsRegistry == null) {
            return;
        }
        if (executionComplete.getResult() == ExecutionComplete.Result.OK) {
            this.statsRegistry.register(StatsRegistry.ExecutionStatsEvent.COMPLETED);
        } else {
            this.statsRegistry.register(StatsRegistry.ExecutionStatsEvent.FAILED);
        }
        this.statsRegistry.registerSingleCompletedExecution(executionComplete);
    }

    @Override
    public void onExecutionDead(Execution execution) {
    }

    @Override
    public void onExecutionFailedHeartbeat(CurrentlyExecuting currentlyExecuting) {
    }

    @Override
    public void onSchedulerEvent(SchedulerListener.SchedulerEventType type) {
        if (this.statsRegistry == null) {
            return;
        }
        this.statsRegistry.register(type.toStatsRegistryEvent());
    }

    @Override
    public void onCandidateEvent(SchedulerListener.CandidateEventType type) {
        if (this.statsRegistry == null) {
            return;
        }
        this.statsRegistry.register(type.toStatsRegistryEvent());
    }
}

