/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.serializer;

import com.github.kagkarlsson.scheduler.serializer.Serializer;
import com.github.kagkarlsson.scheduler.serializer.gson.DurationAdapter;
import com.github.kagkarlsson.scheduler.serializer.gson.InstantAdapter;
import com.github.kagkarlsson.scheduler.serializer.gson.LocalTimeAdapter;
import com.github.kagkarlsson.scheduler.serializer.gson.RuntimeTypeAdapterFactory;
import com.github.kagkarlsson.scheduler.serializer.gson.ZoneIdAdapter;
import com.github.kagkarlsson.scheduler.task.schedule.CronSchedule;
import com.github.kagkarlsson.scheduler.task.schedule.Daily;
import com.github.kagkarlsson.scheduler.task.schedule.FixedDelay;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.function.Consumer;

public class GsonSerializer
implements Serializer {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private final Gson gson;

    public static GsonBuilder getDefaultGson() {
        RuntimeTypeAdapterFactory<Daily> runtimeTypeAdapterFactory = RuntimeTypeAdapterFactory.of(Schedule.class, "type").registerSubtype(CronSchedule.class, "cron").registerSubtype(FixedDelay.class, "fixedDelay").registerSubtype(Daily.class, "daily");
        return new GsonBuilder().serializeNulls().registerTypeAdapter(Instant.class, (Object)new InstantAdapter()).registerTypeAdapter(Duration.class, (Object)new DurationAdapter()).registerTypeAdapter(LocalTime.class, (Object)new LocalTimeAdapter()).registerTypeHierarchyAdapter(ZoneId.class, (Object)new ZoneIdAdapter()).registerTypeAdapterFactory(runtimeTypeAdapterFactory);
    }

    public GsonSerializer() {
        this(GsonSerializer.getDefaultGson().create());
    }

    public GsonSerializer(Gson gson) {
        this.gson = gson;
    }

    public GsonSerializer(Consumer<GsonBuilder> gsonCustomizer) {
        GsonBuilder defaultGson = GsonSerializer.getDefaultGson();
        gsonCustomizer.accept(defaultGson);
        this.gson = defaultGson.create();
    }

    @Override
    public byte[] serialize(Object object) {
        return this.gson.toJson(object).getBytes(CHARSET);
    }

    @Override
    public <T> T deserialize(Class<T> clazz, byte[] serializedData) {
        return (T)this.gson.fromJson(new String(serializedData, CHARSET), clazz);
    }
}

