/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.ScheduledExecutionsFilter;
import com.github.kagkarlsson.scheduler.task.Execution;
import com.github.kagkarlsson.scheduler.task.SchedulableInstance;
import com.github.kagkarlsson.scheduler.task.TaskInstanceId;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public interface TaskRepository {
    public boolean createIfNotExists(SchedulableInstance var1);

    public List<Execution> getDue(Instant var1, int var2);

    public Instant replace(Execution var1, SchedulableInstance var2);

    public void getScheduledExecutions(ScheduledExecutionsFilter var1, Consumer<Execution> var2);

    public void getScheduledExecutions(ScheduledExecutionsFilter var1, String var2, Consumer<Execution> var3);

    public List<Execution> lockAndFetchGeneric(Instant var1, int var2);

    public List<Execution> lockAndGetDue(Instant var1, int var2);

    public void remove(Execution var1);

    public boolean reschedule(Execution var1, Instant var2, Instant var3, Instant var4, int var5);

    public boolean reschedule(Execution var1, Instant var2, Object var3, Instant var4, Instant var5, int var6);

    public Optional<Execution> pick(Execution var1, Instant var2);

    public List<Execution> getDeadExecutions(Instant var1);

    public boolean updateHeartbeatWithRetry(Execution var1, Instant var2, int var3);

    public boolean updateHeartbeat(Execution var1, Instant var2);

    public List<Execution> getExecutionsFailingLongerThan(Duration var1);

    public Optional<Execution> getExecution(String var1, String var2);

    default public Optional<Execution> getExecution(TaskInstanceId taskInstance) {
        return this.getExecution(taskInstance.getTaskName(), taskInstance.getId());
    }

    public int removeExecutions(String var1);

    public void verifySupportsLockAndFetch();
}

