/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.HeartbeatConfig;
import java.time.Duration;
import java.time.Instant;

public class HeartbeatState {
    private Clock clock;
    private final Instant startTime;
    private final HeartbeatConfig heartbeatConfig;
    private int heartbeatSuccessesSinceLastFailure = 0;
    private int heartbeatFailuresSinceLastSuccess = 0;
    private Instant heartbeatLastSuccess;
    private Instant heartbeatLastFailure;

    public HeartbeatState(Clock clock, Instant startTime, HeartbeatConfig heartbeatConfig) {
        this.clock = clock;
        this.startTime = startTime;
        this.heartbeatConfig = heartbeatConfig;
        this.heartbeatLastSuccess = startTime;
    }

    public boolean hasStaleHeartbeat() {
        Duration sinceLastSuccess = Duration.between(this.heartbeatLastSuccess, this.clock.now());
        long heartbeatMillis = this.heartbeatConfig.heartbeatInterval.toMillis();
        long millisUntilConsideredStale = heartbeatMillis + (long)Math.min(10000, (int)((double)heartbeatMillis * 0.25));
        return this.heartbeatFailuresSinceLastSuccess > 0 || sinceLastSuccess.toMillis() > millisUntilConsideredStale;
    }

    public double getFractionDead() {
        Duration sinceLastSuccess = Duration.between(this.heartbeatLastSuccess, this.clock.now());
        return (double)sinceLastSuccess.toMillis() / (double)this.heartbeatConfig.maxAgeBeforeConsideredDead.toMillis();
    }

    public int getFailedHeartbeats() {
        return this.heartbeatFailuresSinceLastSuccess;
    }

    public void heartbeat(boolean successful, Instant lastHeartbeatAttempt) {
        if (successful) {
            this.heartbeatLastSuccess = lastHeartbeatAttempt;
            ++this.heartbeatSuccessesSinceLastFailure;
            this.heartbeatFailuresSinceLastSuccess = 0;
        } else {
            this.heartbeatLastFailure = lastHeartbeatAttempt;
            this.heartbeatSuccessesSinceLastFailure = 0;
            ++this.heartbeatFailuresSinceLastSuccess;
        }
    }

    public String describe() {
        return "HeartbeatState{successesSinceLastFailure=" + this.heartbeatSuccessesSinceLastFailure + ", failuresSinceLastSuccess=" + this.heartbeatFailuresSinceLastSuccess + ", lastSuccess=" + this.heartbeatLastSuccess + ", lastFailure=" + this.heartbeatLastFailure + ", missedHeartbeatsLimit=" + this.heartbeatConfig.missedHeartbeatsLimit + "}";
    }
}

