/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.HasTaskName;

public interface TaskDescriptor<T>
extends HasTaskName {
    @Override
    public String getTaskName();

    public Class<T> getDataClass();

    public static <T> TaskDescriptor<T> of(String name, Class<T> dataClass) {
        return new SimpleTaskDescriptor<T>(name, dataClass);
    }

    public static class SimpleTaskDescriptor<T>
    implements TaskDescriptor<T> {
        private final String name;
        private final Class<T> dataClass;

        public SimpleTaskDescriptor(String name, Class<T> dataClass) {
            this.name = name;
            this.dataClass = dataClass;
        }

        @Override
        public String getTaskName() {
            return this.name;
        }

        @Override
        public Class<T> getDataClass() {
            return this.dataClass;
        }
    }
}

