/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.jdbc;

import com.github.kagkarlsson.scheduler.StringUtils;
import com.github.kagkarlsson.scheduler.jdbc.DefaultJdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.JdbcTaskRepository;
import com.github.kagkarlsson.scheduler.jdbc.JdbcTaskRepositoryContext;
import com.github.kagkarlsson.scheduler.jdbc.Queries;
import com.github.kagkarlsson.scheduler.task.Execution;
import java.time.Instant;
import java.util.List;

public class PostgreSqlJdbcCustomization
extends DefaultJdbcCustomization {
    private final boolean useGenericLockAndFetch;

    public PostgreSqlJdbcCustomization() {
        this(false);
    }

    public PostgreSqlJdbcCustomization(boolean useGenericLockAndFetch) {
        this.useGenericLockAndFetch = useGenericLockAndFetch;
    }

    @Override
    public String getName() {
        return "PostgreSQL";
    }

    @Override
    public String getQueryLimitPart(int limit) {
        return Queries.postgresSqlLimitPart(limit);
    }

    @Override
    public boolean supportsSingleStatementLockAndFetch() {
        return !this.useGenericLockAndFetch;
    }

    @Override
    public boolean supportsGenericLockAndFetch() {
        return this.useGenericLockAndFetch;
    }

    @Override
    public String createGenericSelectForUpdateQuery(String tableName, int limit, String requiredAndCondition) {
        return Queries.selectForUpdate(tableName, this.getQueryLimitPart(limit), requiredAndCondition, " FOR UPDATE SKIP LOCKED ", null);
    }

    @Override
    public List<Execution> lockAndFetchSingleStatement(JdbcTaskRepositoryContext ctx, Instant now, int limit) {
        JdbcTaskRepository.UnresolvedFilter unresolvedFilter = new JdbcTaskRepository.UnresolvedFilter(ctx.taskResolver.getUnresolved());
        String selectForUpdateQuery = " UPDATE " + ctx.tableName + " st1 SET picked = ?, picked_by = ?, last_heartbeat = ?, version = version + 1  WHERE (st1.task_name, st1.task_instance) IN (SELECT st2.task_name, st2.task_instance FROM " + ctx.tableName + " st2  WHERE picked = ? and execution_time <= ? " + unresolvedFilter.andCondition() + " ORDER BY execution_time ASC FOR UPDATE SKIP LOCKED " + this.getQueryLimitPart(limit) + ") RETURNING st1.*";
        return ctx.jdbcRunner.query(selectForUpdateQuery, ps -> {
            int index = 1;
            ps.setBoolean(index++, true);
            ps.setString(index++, StringUtils.truncate(ctx.schedulerName.getName(), 50));
            this.setInstant(ps, index++, now);
            ps.setBoolean(index++, false);
            this.setInstant(ps, index++, now);
            index = unresolvedFilter.setParameters(ps, index);
        }, ctx.resultSetMapper.get());
    }
}

