/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.jdbc;

import com.github.kagkarlsson.jdbc.JdbcRunner;
import com.github.kagkarlsson.jdbc.ResultSetMapper;
import com.github.kagkarlsson.jdbc.SQLRuntimeException;
import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.ScheduledExecutionsFilter;
import com.github.kagkarlsson.scheduler.SchedulerName;
import com.github.kagkarlsson.scheduler.StringUtils;
import com.github.kagkarlsson.scheduler.TaskRepository;
import com.github.kagkarlsson.scheduler.TaskResolver;
import com.github.kagkarlsson.scheduler.exceptions.ExecutionException;
import com.github.kagkarlsson.scheduler.exceptions.TaskInstanceException;
import com.github.kagkarlsson.scheduler.jdbc.AndCondition;
import com.github.kagkarlsson.scheduler.jdbc.AutodetectJdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.JdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.JdbcTaskRepositoryContext;
import com.github.kagkarlsson.scheduler.jdbc.QueryBuilder;
import com.github.kagkarlsson.scheduler.serializer.Serializer;
import com.github.kagkarlsson.scheduler.task.Execution;
import com.github.kagkarlsson.scheduler.task.SchedulableInstance;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTaskRepository
implements TaskRepository {
    public static final String DEFAULT_TABLE_NAME = "scheduled_tasks";
    private static final Logger LOG = LoggerFactory.getLogger(JdbcTaskRepository.class);
    private final TaskResolver taskResolver;
    private final SchedulerName schedulerSchedulerName;
    private final JdbcRunner jdbcRunner;
    private final Serializer serializer;
    private final String tableName;
    private final JdbcCustomization jdbcCustomization;
    private final Clock clock;

    public JdbcTaskRepository(DataSource dataSource, boolean commitWhenAutocommitDisabled, String tableName, TaskResolver taskResolver, SchedulerName schedulerSchedulerName, Clock clock) {
        this(dataSource, commitWhenAutocommitDisabled, new AutodetectJdbcCustomization(dataSource), tableName, taskResolver, schedulerSchedulerName, Serializer.DEFAULT_JAVA_SERIALIZER, clock);
    }

    public JdbcTaskRepository(DataSource dataSource, boolean commitWhenAutocommitDisabled, JdbcCustomization jdbcCustomization, String tableName, TaskResolver taskResolver, SchedulerName schedulerSchedulerName, Clock clock) {
        this(dataSource, commitWhenAutocommitDisabled, jdbcCustomization, tableName, taskResolver, schedulerSchedulerName, Serializer.DEFAULT_JAVA_SERIALIZER, clock);
    }

    public JdbcTaskRepository(DataSource dataSource, boolean commitWhenAutocommitDisabled, JdbcCustomization jdbcCustomization, String tableName, TaskResolver taskResolver, SchedulerName schedulerSchedulerName, Serializer serializer, Clock clock) {
        this(jdbcCustomization, tableName, taskResolver, schedulerSchedulerName, serializer, new JdbcRunner(dataSource, commitWhenAutocommitDisabled), clock);
    }

    protected JdbcTaskRepository(JdbcCustomization jdbcCustomization, String tableName, TaskResolver taskResolver, SchedulerName schedulerSchedulerName, Serializer serializer, JdbcRunner jdbcRunner, Clock clock) {
        this.tableName = tableName;
        this.taskResolver = taskResolver;
        this.schedulerSchedulerName = schedulerSchedulerName;
        this.jdbcRunner = jdbcRunner;
        this.serializer = serializer;
        this.jdbcCustomization = jdbcCustomization;
        this.clock = clock;
    }

    @Override
    public boolean createIfNotExists(SchedulableInstance instance) {
        TaskInstance taskInstance = instance.getTaskInstance();
        try {
            Optional<Execution> existingExecution = this.getExecution(taskInstance);
            if (existingExecution.isPresent()) {
                LOG.debug("Execution not created, it already exists. Due: {}", (Object)existingExecution.get().executionTime);
                return false;
            }
            this.jdbcRunner.execute("insert into " + this.tableName + "(task_name, task_instance, task_data, execution_time, picked, version) values(?, ?, ?, ?, ?, ?)", p -> {
                p.setString(1, taskInstance.getTaskName());
                p.setString(2, taskInstance.getId());
                this.jdbcCustomization.setTaskData(p, 3, this.serializer.serialize(taskInstance.getData()));
                this.jdbcCustomization.setInstant(p, 4, instance.getNextExecutionTime(this.clock.now()));
                p.setBoolean(5, false);
                p.setLong(6, 1L);
            });
            return true;
        }
        catch (SQLRuntimeException e) {
            LOG.debug("Exception when inserting execution. Assuming it to be a constraint violation.", (Throwable)e);
            Optional<Execution> existingExecution = this.getExecution(taskInstance);
            if (!existingExecution.isPresent()) {
                throw new TaskInstanceException("Failed to add new execution.", instance.getTaskName(), instance.getId(), e);
            }
            LOG.debug("Execution not created, another thread created it.");
            return false;
        }
    }

    @Override
    public Instant replace(Execution toBeReplaced, SchedulableInstance newInstance) {
        Instant newExecutionTime = newInstance.getNextExecutionTime(this.clock.now());
        Execution newExecution = new Execution(newExecutionTime, newInstance.getTaskInstance());
        Object newData = newInstance.getTaskInstance().getData();
        int updated = this.jdbcRunner.execute("update " + this.tableName + " set task_name = ?, task_instance = ?, picked = ?, picked_by = ?, last_heartbeat = ?, last_success = ?, last_failure = ?, consecutive_failures = ?, execution_time = ?, task_data = ?, version = 1 where task_name = ? and task_instance = ? and version = ?", ps -> {
            int index = 1;
            ps.setString(index++, newExecution.taskInstance.getTaskName());
            ps.setString(index++, newExecution.taskInstance.getId());
            ps.setBoolean(index++, false);
            ps.setString(index++, null);
            this.jdbcCustomization.setInstant(ps, index++, null);
            this.jdbcCustomization.setInstant(ps, index++, null);
            this.jdbcCustomization.setInstant(ps, index++, null);
            ps.setInt(index++, 0);
            this.jdbcCustomization.setInstant(ps, index++, newExecutionTime);
            ps.setObject(index++, this.serializer.serialize(newData));
            ps.setString(index++, toBeReplaced.taskInstance.getTaskName());
            ps.setString(index++, toBeReplaced.taskInstance.getId());
            ps.setLong(index++, toBeReplaced.version);
        });
        if (updated == 0) {
            throw new IllegalStateException("Failed to replace execution, found none matching " + toBeReplaced);
        }
        if (updated > 1) {
            LOG.error("Expected one execution to be updated, but updated " + updated + ". Indicates a bug. Replaced " + toBeReplaced.taskInstance + " with " + newExecution.taskInstance);
        }
        return newExecutionTime;
    }

    @Override
    public void getScheduledExecutions(ScheduledExecutionsFilter filter, Consumer<Execution> consumer) {
        UnresolvedFilter unresolvedFilter = new UnresolvedFilter(this.taskResolver.getUnresolved());
        QueryBuilder q = this.queryForFilter(filter);
        if (unresolvedFilter.isActive()) {
            q.andCondition(unresolvedFilter);
        }
        this.jdbcRunner.query(q.getQuery(), q.getPreparedStatementSetter(), (ResultSetMapper)new ExecutionResultSetConsumer(consumer));
    }

    @Override
    public void getScheduledExecutions(ScheduledExecutionsFilter filter, String taskName, Consumer<Execution> consumer) {
        QueryBuilder q = this.queryForFilter(filter);
        q.andCondition(new TaskCondition(taskName));
        this.jdbcRunner.query(q.getQuery(), q.getPreparedStatementSetter(), (ResultSetMapper)new ExecutionResultSetConsumer(consumer));
    }

    @Override
    public List<Execution> getDue(Instant now, int limit) {
        UnresolvedFilter unresolvedFilter = new UnresolvedFilter(this.taskResolver.getUnresolved());
        String explicitLimit = this.jdbcCustomization.supportsExplicitQueryLimitPart() ? this.jdbcCustomization.getQueryLimitPart(limit) : "";
        return (List)this.jdbcRunner.query("select * from " + this.tableName + " where picked = ? and execution_time <= ? " + unresolvedFilter.andCondition() + " order by execution_time asc" + explicitLimit, p -> {
            int index = 1;
            p.setBoolean(index++, false);
            this.jdbcCustomization.setInstant(p, index++, now);
            unresolvedFilter.setParameters(p, index);
            if (!this.jdbcCustomization.supportsExplicitQueryLimitPart()) {
                p.setMaxRows(limit);
            }
        }, (ResultSetMapper)new ExecutionResultSetMapper());
    }

    @Override
    public List<Execution> lockAndGetDue(Instant now, int limit) {
        return this.jdbcCustomization.lockAndFetch(this.getTaskRespositoryContext(), now, limit);
    }

    @Override
    public void remove(Execution execution) {
        int removed = this.jdbcRunner.execute("delete from " + this.tableName + " where task_name = ? and task_instance = ? and version = ?", ps -> {
            ps.setString(1, execution.taskInstance.getTaskName());
            ps.setString(2, execution.taskInstance.getId());
            ps.setLong(3, execution.version);
        });
        if (removed != 1) {
            throw new ExecutionException("Expected one execution to be removed, but removed " + removed + ". Indicates a bug.", execution);
        }
    }

    @Override
    public boolean reschedule(Execution execution, Instant nextExecutionTime, Instant lastSuccess, Instant lastFailure, int consecutiveFailures) {
        return this.rescheduleInternal(execution, nextExecutionTime, null, lastSuccess, lastFailure, consecutiveFailures);
    }

    @Override
    public boolean reschedule(Execution execution, Instant nextExecutionTime, Object newData, Instant lastSuccess, Instant lastFailure, int consecutiveFailures) {
        return this.rescheduleInternal(execution, nextExecutionTime, new NewData(newData), lastSuccess, lastFailure, consecutiveFailures);
    }

    private boolean rescheduleInternal(Execution execution, Instant nextExecutionTime, NewData newData, Instant lastSuccess, Instant lastFailure, int consecutiveFailures) {
        int updated = this.jdbcRunner.execute("update " + this.tableName + " set picked = ?, picked_by = ?, last_heartbeat = ?, last_success = ?, last_failure = ?, consecutive_failures = ?, execution_time = ?, " + (newData != null ? "task_data = ?, " : "") + "version = version + 1 where task_name = ? and task_instance = ? and version = ?", ps -> {
            int index = 1;
            ps.setBoolean(index++, false);
            ps.setString(index++, null);
            this.jdbcCustomization.setInstant(ps, index++, null);
            this.jdbcCustomization.setInstant(ps, index++, Optional.ofNullable(lastSuccess).orElse(null));
            this.jdbcCustomization.setInstant(ps, index++, Optional.ofNullable(lastFailure).orElse(null));
            ps.setInt(index++, consecutiveFailures);
            this.jdbcCustomization.setInstant(ps, index++, nextExecutionTime);
            if (newData != null) {
                ps.setObject(index++, this.serializer.serialize(newData.data));
            }
            ps.setString(index++, execution.taskInstance.getTaskName());
            ps.setString(index++, execution.taskInstance.getId());
            ps.setLong(index++, execution.version);
        });
        if (updated != 1) {
            throw new ExecutionException("Expected one execution to be updated, but updated " + updated + ". Indicates a bug.", execution);
        }
        return updated > 0;
    }

    @Override
    public Optional<Execution> pick(Execution e, Instant timePicked) {
        int updated = this.jdbcRunner.execute("update " + this.tableName + " set picked = ?, picked_by = ?, last_heartbeat = ?, version = version + 1 where picked = ? and task_name = ? and task_instance = ? and version = ?", ps -> {
            ps.setBoolean(1, true);
            ps.setString(2, StringUtils.truncate(this.schedulerSchedulerName.getName(), 50));
            this.jdbcCustomization.setInstant(ps, 3, timePicked);
            ps.setBoolean(4, false);
            ps.setString(5, e.taskInstance.getTaskName());
            ps.setString(6, e.taskInstance.getId());
            ps.setLong(7, e.version);
        });
        if (updated == 0) {
            LOG.trace("Failed to pick execution. It must have been picked by another scheduler.", (Object)e);
            return Optional.empty();
        }
        if (updated == 1) {
            Optional<Execution> pickedExecution = this.getExecution(e.taskInstance);
            if (!pickedExecution.isPresent()) {
                throw new IllegalStateException("Unable to find picked execution. Must have been deleted by another thread. Indicates a bug.");
            }
            if (!pickedExecution.get().isPicked()) {
                throw new IllegalStateException("Picked execution does not have expected state in database: " + pickedExecution.get());
            }
            return pickedExecution;
        }
        throw new IllegalStateException("Updated multiple rows when picking single execution. Should never happen since name and id is primary key. Execution: " + e);
    }

    @Override
    public List<Execution> getDeadExecutions(Instant olderThan) {
        UnresolvedFilter unresolvedFilter = new UnresolvedFilter(this.taskResolver.getUnresolved());
        return (List)this.jdbcRunner.query("select * from " + this.tableName + " where picked = ? and last_heartbeat <= ? " + unresolvedFilter.andCondition() + " order by last_heartbeat asc", p -> {
            int index = 1;
            p.setBoolean(index++, true);
            this.jdbcCustomization.setInstant(p, index++, olderThan);
            unresolvedFilter.setParameters(p, index);
        }, (ResultSetMapper)new ExecutionResultSetMapper());
    }

    @Override
    public void updateHeartbeat(Execution e, Instant newHeartbeat) {
        int updated = this.jdbcRunner.execute("update " + this.tableName + " set last_heartbeat = ? where task_name = ? and task_instance = ? and version = ?", ps -> {
            this.jdbcCustomization.setInstant(ps, 1, newHeartbeat);
            ps.setString(2, e.taskInstance.getTaskName());
            ps.setString(3, e.taskInstance.getId());
            ps.setLong(4, e.version);
        });
        if (updated == 0) {
            LOG.trace("Did not update heartbeat. Execution must have been removed or rescheduled.", (Object)e);
        } else {
            if (updated > 1) {
                throw new IllegalStateException("Updated multiple rows updating heartbeat for execution. Should never happen since name and id is primary key. Execution: " + e);
            }
            LOG.debug("Updated heartbeat for execution: " + e);
        }
    }

    @Override
    public List<Execution> getExecutionsFailingLongerThan(Duration interval) {
        UnresolvedFilter unresolvedFilter = new UnresolvedFilter(this.taskResolver.getUnresolved());
        return (List)this.jdbcRunner.query("select * from " + this.tableName + " where     ((last_success is null and last_failure is not null)    or (last_failure is not null and last_success < ?)) " + unresolvedFilter.andCondition(), p -> {
            int index = 1;
            this.jdbcCustomization.setInstant(p, index++, Instant.now().minus(interval));
            unresolvedFilter.setParameters(p, index);
        }, (ResultSetMapper)new ExecutionResultSetMapper());
    }

    public Optional<Execution> getExecution(TaskInstance taskInstance) {
        return this.getExecution(taskInstance.getTaskName(), taskInstance.getId());
    }

    @Override
    public Optional<Execution> getExecution(String taskName, String taskInstanceId) {
        List executions = (List)this.jdbcRunner.query("select * from " + this.tableName + " where task_name = ? and task_instance = ?", p -> {
            p.setString(1, taskName);
            p.setString(2, taskInstanceId);
        }, (ResultSetMapper)new ExecutionResultSetMapper());
        if (executions.size() > 1) {
            throw new TaskInstanceException("Found more than one matching execution for task name/id combination.", taskName, taskInstanceId);
        }
        return executions.size() == 1 ? Optional.ofNullable((Execution)executions.get(0)) : Optional.empty();
    }

    @Override
    public int removeExecutions(String taskName) {
        return this.jdbcRunner.execute("delete from " + this.tableName + " where task_name = ?", p -> p.setString(1, taskName));
    }

    @Override
    public void checkSupportsLockAndFetch() {
        if (!this.jdbcCustomization.supportsLockAndFetch()) {
            throw new IllegalArgumentException("Database using jdbc-customization '" + this.jdbcCustomization.getName() + "' does not support lock-and-fetch polling (i.e. Select-for-update)");
        }
    }

    private JdbcTaskRepositoryContext getTaskRespositoryContext() {
        return new JdbcTaskRepositoryContext(this.taskResolver, this.tableName, this.schedulerSchedulerName, this.jdbcRunner, () -> new ExecutionResultSetMapper());
    }

    private QueryBuilder queryForFilter(ScheduledExecutionsFilter filter) {
        QueryBuilder q = QueryBuilder.selectFromTable(this.tableName);
        filter.getPickedValue().ifPresent(value -> q.andCondition(new PickedCondition((boolean)value)));
        q.orderBy("execution_time asc");
        return q;
    }

    private static <T> Supplier<T> memoize(final Supplier<T> original) {
        return new Supplier<T>(){
            Supplier<T> delegate = this::firstTime;
            boolean initialized;

            @Override
            public T get() {
                return this.delegate.get();
            }

            private synchronized T firstTime() {
                if (!this.initialized) {
                    Object value = original.get();
                    this.delegate = () -> value;
                    this.initialized = true;
                }
                return this.delegate.get();
            }
        };
    }

    static class UnresolvedFilter
    implements AndCondition {
        private final List<TaskResolver.UnresolvedTask> unresolved;

        public UnresolvedFilter(List<TaskResolver.UnresolvedTask> unresolved) {
            this.unresolved = unresolved;
        }

        public boolean isActive() {
            return !this.unresolved.isEmpty();
        }

        public String andCondition() {
            return this.unresolved.isEmpty() ? "" : "and " + this.getQueryPart();
        }

        @Override
        public String getQueryPart() {
            return "task_name not in (" + this.unresolved.stream().map(ignored -> "?").collect(Collectors.joining(",")) + ")";
        }

        @Override
        public int setParameters(PreparedStatement p, int index) throws SQLException {
            List unresolvedTasknames = this.unresolved.stream().map(TaskResolver.UnresolvedTask::getTaskName).collect(Collectors.toList());
            for (String taskName : unresolvedTasknames) {
                p.setString(index++, taskName);
            }
            return index;
        }
    }

    private class ExecutionResultSetConsumer
    implements ResultSetMapper<Void> {
        private final Consumer<Execution> consumer;

        private ExecutionResultSetConsumer(Consumer<Execution> consumer) {
            this.consumer = consumer;
        }

        public Void map(ResultSet rs) throws SQLException {
            while (rs.next()) {
                String taskName = rs.getString("task_name");
                Optional<Task> task = JdbcTaskRepository.this.taskResolver.resolve(taskName);
                if (!task.isPresent()) {
                    LOG.warn("Failed to find implementation for task with name '{}'. Execution will be excluded from due. Either delete the execution from the database, or add an implementation for it. The scheduler may be configured to automatically delete unresolved tasks after a certain period of time.", (Object)taskName);
                    continue;
                }
                String instanceId = rs.getString("task_instance");
                byte[] data = JdbcTaskRepository.this.jdbcCustomization.getTaskData(rs, "task_data");
                Instant executionTime = JdbcTaskRepository.this.jdbcCustomization.getInstant(rs, "execution_time");
                boolean picked = rs.getBoolean("picked");
                String pickedBy = rs.getString("picked_by");
                Instant lastSuccess = JdbcTaskRepository.this.jdbcCustomization.getInstant(rs, "last_success");
                Instant lastFailure = JdbcTaskRepository.this.jdbcCustomization.getInstant(rs, "last_failure");
                int consecutiveFailures = rs.getInt("consecutive_failures");
                Instant lastHeartbeat = JdbcTaskRepository.this.jdbcCustomization.getInstant(rs, "last_heartbeat");
                long version = rs.getLong("version");
                Supplier dataSupplier = JdbcTaskRepository.memoize(() -> JdbcTaskRepository.this.serializer.deserialize(((Task)task.get()).getDataClass(), data));
                this.consumer.accept(new Execution(executionTime, new TaskInstance(taskName, instanceId, dataSupplier), picked, pickedBy, lastSuccess, lastFailure, consecutiveFailures, lastHeartbeat, version));
            }
            return null;
        }
    }

    private static class TaskCondition
    implements AndCondition {
        private final String value;

        public TaskCondition(String value) {
            this.value = value;
        }

        @Override
        public String getQueryPart() {
            return "task_name = ?";
        }

        @Override
        public int setParameters(PreparedStatement p, int index) throws SQLException {
            p.setString(index++, this.value);
            return index;
        }
    }

    private class ExecutionResultSetMapper
    implements ResultSetMapper<List<Execution>> {
        private final ArrayList<Execution> executions = new ArrayList();
        private final ExecutionResultSetConsumer delegate;

        private ExecutionResultSetMapper() {
            this.delegate = new ExecutionResultSetConsumer(this.executions::add);
        }

        public List<Execution> map(ResultSet resultSet) throws SQLException {
            this.delegate.map(resultSet);
            return this.executions;
        }
    }

    private static class NewData {
        private final Object data;

        NewData(Object data) {
            this.data = data;
        }
    }

    private static class PickedCondition
    implements AndCondition {
        private final boolean value;

        public PickedCondition(boolean value) {
            this.value = value;
        }

        @Override
        public String getQueryPart() {
            return "picked = ?";
        }

        @Override
        public int setParameters(PreparedStatement p, int index) throws SQLException {
            p.setBoolean(index++, this.value);
            return index;
        }
    }
}

