/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.ClientEvent;
import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.ScheduledExecution;
import com.github.kagkarlsson.scheduler.ScheduledExecutionsFilter;
import com.github.kagkarlsson.scheduler.SchedulerClientEventListener;
import com.github.kagkarlsson.scheduler.SchedulerName;
import com.github.kagkarlsson.scheduler.SystemClock;
import com.github.kagkarlsson.scheduler.TaskRepository;
import com.github.kagkarlsson.scheduler.TaskResolver;
import com.github.kagkarlsson.scheduler.exceptions.TaskInstanceCurrentlyExecutingException;
import com.github.kagkarlsson.scheduler.exceptions.TaskInstanceNotFoundException;
import com.github.kagkarlsson.scheduler.jdbc.DefaultJdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.JdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.JdbcTaskRepository;
import com.github.kagkarlsson.scheduler.serializer.Serializer;
import com.github.kagkarlsson.scheduler.stats.StatsRegistry;
import com.github.kagkarlsson.scheduler.task.Execution;
import com.github.kagkarlsson.scheduler.task.SchedulableInstance;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import com.github.kagkarlsson.scheduler.task.TaskInstanceId;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SchedulerClient {
    public <T> void schedule(TaskInstance<T> var1, Instant var2);

    public <T> void schedule(SchedulableInstance<T> var1);

    public void reschedule(TaskInstanceId var1, Instant var2);

    public <T> void reschedule(TaskInstanceId var1, Instant var2, T var3);

    public <T> void reschedule(SchedulableInstance<T> var1);

    public void cancel(TaskInstanceId var1);

    public void fetchScheduledExecutions(Consumer<ScheduledExecution<Object>> var1);

    public void fetchScheduledExecutions(ScheduledExecutionsFilter var1, Consumer<ScheduledExecution<Object>> var2);

    default public List<ScheduledExecution<Object>> getScheduledExecutions() {
        ArrayList<ScheduledExecution<Object>> executions = new ArrayList<ScheduledExecution<Object>>();
        this.fetchScheduledExecutions(executions::add);
        return executions;
    }

    default public List<ScheduledExecution<Object>> getScheduledExecutions(ScheduledExecutionsFilter filter) {
        ArrayList<ScheduledExecution<Object>> executions = new ArrayList<ScheduledExecution<Object>>();
        this.fetchScheduledExecutions(filter, executions::add);
        return executions;
    }

    public <T> void fetchScheduledExecutionsForTask(String var1, Class<T> var2, Consumer<ScheduledExecution<T>> var3);

    public <T> void fetchScheduledExecutionsForTask(String var1, Class<T> var2, ScheduledExecutionsFilter var3, Consumer<ScheduledExecution<T>> var4);

    default public <T> List<ScheduledExecution<T>> getScheduledExecutionsForTask(String taskName, Class<T> dataClass) {
        ArrayList<ScheduledExecution<T>> executions = new ArrayList<ScheduledExecution<T>>();
        this.fetchScheduledExecutionsForTask(taskName, dataClass, executions::add);
        return executions;
    }

    default public <T> List<ScheduledExecution<T>> getScheduledExecutionsForTask(String taskName, Class<T> dataClass, ScheduledExecutionsFilter filter) {
        ArrayList<ScheduledExecution<T>> executions = new ArrayList<ScheduledExecution<T>>();
        this.fetchScheduledExecutionsForTask(taskName, dataClass, filter, executions::add);
        return executions;
    }

    public Optional<ScheduledExecution<Object>> getScheduledExecution(TaskInstanceId var1);

    public static class SchedulerClientName
    implements SchedulerName {
        @Override
        public String getName() {
            return "SchedulerClient";
        }
    }

    public static class StandardSchedulerClient
    implements SchedulerClient {
        private static final Logger LOG = LoggerFactory.getLogger(StandardSchedulerClient.class);
        protected final TaskRepository taskRepository;
        private final Clock clock;
        private SchedulerClientEventListener schedulerClientEventListener;

        StandardSchedulerClient(TaskRepository taskRepository, Clock clock) {
            this(taskRepository, SchedulerClientEventListener.NOOP, clock);
        }

        StandardSchedulerClient(TaskRepository taskRepository, SchedulerClientEventListener schedulerClientEventListener, Clock clock) {
            this.taskRepository = taskRepository;
            this.schedulerClientEventListener = schedulerClientEventListener;
            this.clock = clock;
        }

        @Override
        public <T> void schedule(TaskInstance<T> taskInstance, Instant executionTime) {
            boolean success = this.taskRepository.createIfNotExists(SchedulableInstance.of(taskInstance, executionTime));
            if (success) {
                this.notifyListeners(ClientEvent.EventType.SCHEDULE, taskInstance, executionTime);
            }
        }

        @Override
        public <T> void schedule(SchedulableInstance<T> schedulableInstance) {
            this.schedule(schedulableInstance.getTaskInstance(), schedulableInstance.getNextExecutionTime(this.clock.now()));
        }

        @Override
        public void reschedule(TaskInstanceId taskInstanceId, Instant newExecutionTime) {
            this.reschedule(taskInstanceId, newExecutionTime, null);
        }

        @Override
        public <T> void reschedule(SchedulableInstance<T> schedulableInstance) {
            this.reschedule(schedulableInstance, schedulableInstance.getNextExecutionTime(this.clock.now()), schedulableInstance.getTaskInstance().getData());
        }

        @Override
        public <T> void reschedule(TaskInstanceId taskInstanceId, Instant newExecutionTime, T newData) {
            String instanceId;
            String taskName = taskInstanceId.getTaskName();
            Optional<Execution> execution = this.taskRepository.getExecution(taskName, instanceId = taskInstanceId.getId());
            if (execution.isPresent()) {
                if (execution.get().isPicked()) {
                    throw new TaskInstanceCurrentlyExecutingException(taskName, instanceId);
                }
                boolean success = newData == null ? this.taskRepository.reschedule(execution.get(), newExecutionTime, null, null, 0) : this.taskRepository.reschedule(execution.get(), newExecutionTime, newData, null, null, 0);
                if (success) {
                    this.notifyListeners(ClientEvent.EventType.RESCHEDULE, taskInstanceId, newExecutionTime);
                }
            } else {
                throw new TaskInstanceNotFoundException(taskName, instanceId);
            }
        }

        @Override
        public void cancel(TaskInstanceId taskInstanceId) {
            String instanceId;
            String taskName = taskInstanceId.getTaskName();
            Optional<Execution> execution = this.taskRepository.getExecution(taskName, instanceId = taskInstanceId.getId());
            if (execution.isPresent()) {
                if (execution.get().isPicked()) {
                    throw new TaskInstanceCurrentlyExecutingException(taskName, instanceId);
                }
            } else {
                throw new TaskInstanceNotFoundException(taskName, instanceId);
            }
            this.taskRepository.remove(execution.get());
            this.notifyListeners(ClientEvent.EventType.CANCEL, taskInstanceId, execution.get().executionTime);
        }

        @Override
        public void fetchScheduledExecutions(Consumer<ScheduledExecution<Object>> consumer) {
            this.fetchScheduledExecutions(ScheduledExecutionsFilter.all().withPicked(false), consumer);
        }

        @Override
        public void fetchScheduledExecutions(ScheduledExecutionsFilter filter, Consumer<ScheduledExecution<Object>> consumer) {
            this.taskRepository.getScheduledExecutions(filter, execution -> consumer.accept(new ScheduledExecution<Object>(Object.class, (Execution)execution)));
        }

        @Override
        public <T> void fetchScheduledExecutionsForTask(String taskName, Class<T> dataClass, Consumer<ScheduledExecution<T>> consumer) {
            this.fetchScheduledExecutionsForTask(taskName, dataClass, ScheduledExecutionsFilter.all().withPicked(false), consumer);
        }

        @Override
        public <T> void fetchScheduledExecutionsForTask(String taskName, Class<T> dataClass, ScheduledExecutionsFilter filter, Consumer<ScheduledExecution<T>> consumer) {
            this.taskRepository.getScheduledExecutions(filter, taskName, execution -> consumer.accept(new ScheduledExecution(dataClass, (Execution)execution)));
        }

        @Override
        public Optional<ScheduledExecution<Object>> getScheduledExecution(TaskInstanceId taskInstanceId) {
            Optional<Execution> e = this.taskRepository.getExecution(taskInstanceId.getTaskName(), taskInstanceId.getId());
            return e.map(oe -> new ScheduledExecution<Object>(Object.class, (Execution)oe));
        }

        private void notifyListeners(ClientEvent.EventType eventType, TaskInstanceId taskInstanceId, Instant executionTime) {
            try {
                this.schedulerClientEventListener.newEvent(new ClientEvent(new ClientEvent.ClientEventContext(eventType, taskInstanceId, executionTime)));
            }
            catch (Exception e) {
                LOG.error("Error when notifying SchedulerClientEventListener.", (Throwable)e);
            }
        }
    }

    public static class Builder {
        private final DataSource dataSource;
        private List<Task<?>> knownTasks;
        private Serializer serializer = Serializer.DEFAULT_JAVA_SERIALIZER;
        private String tableName = "scheduled_tasks";
        private JdbcCustomization jdbcCustomization;

        private Builder(DataSource dataSource, List<Task<?>> knownTasks) {
            this.dataSource = dataSource;
            this.knownTasks = knownTasks;
        }

        public static Builder create(DataSource dataSource, Task<?> ... knownTasks) {
            return new Builder(dataSource, Arrays.asList(knownTasks));
        }

        public static Builder create(DataSource dataSource, List<Task<?>> knownTasks) {
            return new Builder(dataSource, knownTasks);
        }

        public Builder serializer(Serializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder jdbcCustomization(JdbcCustomization jdbcCustomization) {
            this.jdbcCustomization = jdbcCustomization;
            return this;
        }

        public SchedulerClient build() {
            TaskResolver taskResolver = new TaskResolver(StatsRegistry.NOOP, this.knownTasks);
            SystemClock clock = new SystemClock();
            JdbcTaskRepository taskRepository = new JdbcTaskRepository(this.dataSource, false, Optional.ofNullable(this.jdbcCustomization).orElse(new DefaultJdbcCustomization()), this.tableName, taskResolver, new SchedulerClientName(), this.serializer, clock);
            return new StandardSchedulerClient(taskRepository, clock);
        }
    }
}

