/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.serializer;

import com.github.kagkarlsson.scheduler.serializer.Serializer;
import com.github.kagkarlsson.scheduler.serializer.gson.InstantAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.function.Consumer;

public class GsonSerializer
implements Serializer {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private final Gson gson;

    public static GsonBuilder getDefaultGson() {
        return new GsonBuilder().serializeNulls().registerTypeAdapter(Instant.class, (Object)new InstantAdapter());
    }

    public GsonSerializer() {
        this(GsonSerializer.getDefaultGson().create());
    }

    public GsonSerializer(Gson gson) {
        this.gson = gson;
    }

    public GsonSerializer(Consumer<GsonBuilder> gsonCustomizer) {
        GsonBuilder defaultGson = GsonSerializer.getDefaultGson();
        gsonCustomizer.accept(defaultGson);
        this.gson = defaultGson.create();
    }

    @Override
    public byte[] serialize(Object object) {
        return this.gson.toJson(object).getBytes(CHARSET);
    }

    @Override
    public <T> T deserialize(Class<T> clazz, byte[] serializedData) {
        return (T)this.gson.fromJson(new String(serializedData, CHARSET), clazz);
    }
}

