/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.serializer;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.kagkarlsson.scheduler.exceptions.SerializationException;
import com.github.kagkarlsson.scheduler.serializer.Serializer;
import com.github.kagkarlsson.scheduler.serializer.jackson.InstantDeserializer;
import com.github.kagkarlsson.scheduler.serializer.jackson.InstantSerializer;
import java.io.IOException;
import java.time.Instant;
import java.util.function.Consumer;

public class JacksonSerializer
implements Serializer {
    private final ObjectMapper objectMapper;

    public static ObjectMapper getDefaultObjectMapper() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(Instant.class, (JsonSerializer)new InstantSerializer());
        module.addDeserializer(Instant.class, (JsonDeserializer)new InstantDeserializer());
        return new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).registerModule((Module)module);
    }

    public JacksonSerializer() {
        this(JacksonSerializer.getDefaultObjectMapper());
    }

    public JacksonSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public JacksonSerializer(Consumer<ObjectMapper> objectMapperCustomizer) {
        ObjectMapper defaultObjectMapper = JacksonSerializer.getDefaultObjectMapper();
        objectMapperCustomizer.accept(defaultObjectMapper);
        this.objectMapper = defaultObjectMapper;
    }

    @Override
    public byte[] serialize(Object object) {
        try {
            return this.objectMapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("Failed to serialize object.", e);
        }
    }

    @Override
    public <T> T deserialize(Class<T> clazz, byte[] serializedData) {
        try {
            return (T)this.objectMapper.readValue(serializedData, clazz);
        }
        catch (IOException e) {
            throw new SerializationException("Failed to deserialize object.", e);
        }
    }
}

