/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.ExecutionOperations;
import com.github.kagkarlsson.scheduler.task.Schedule;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CompletionHandler {
    public void complete(ExecutionComplete var1, ExecutionOperations var2);

    public static class OnCompleteReschedule
    implements CompletionHandler {
        private static final Logger LOG = LoggerFactory.getLogger(OnCompleteReschedule.class);
        private final Schedule schedule;

        OnCompleteReschedule(Schedule schedule) {
            this.schedule = schedule;
        }

        @Override
        public void complete(ExecutionComplete executionComplete, ExecutionOperations executionOperations) {
            LocalDateTime nextExecution = this.schedule.getNextExecutionTime(executionComplete.getTimeDone());
            LOG.debug("Rescheduling task {} to {}", (Object)executionComplete.getExecution().taskInstance, (Object)nextExecution);
            executionOperations.reschedule(executionComplete, nextExecution);
        }
    }

    public static class OnCompleteRemove
    implements CompletionHandler {
        @Override
        public void complete(ExecutionComplete executionComplete, ExecutionOperations executionOperations) {
            executionOperations.stop();
        }
    }
}

