/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.Execution;
import com.github.kagkarlsson.scheduler.ExecutionOperations;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DeadExecutionHandler {
    public void deadExecution(Execution var1, ExecutionOperations var2);

    public static class CancelDeadExecution
    implements DeadExecutionHandler {
        private static final Logger LOG = LoggerFactory.getLogger(RescheduleDeadExecution.class);

        @Override
        public void deadExecution(Execution execution, ExecutionOperations executionOperations) {
            LOG.error("Cancelling dead execution: " + execution);
            executionOperations.stop();
        }
    }

    public static class RescheduleDeadExecution
    implements DeadExecutionHandler {
        private static final Logger LOG = LoggerFactory.getLogger(RescheduleDeadExecution.class);

        @Override
        public void deadExecution(Execution execution, ExecutionOperations executionOperations) {
            LocalDateTime now = LocalDateTime.now();
            LOG.warn("Rescheduling dead execution: " + execution + " to " + now);
            executionOperations.reschedule(now);
        }
    }
}

