/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.boot.config;

import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.PollingStrategyConfig;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.SchedulerBuilder;
import com.github.kagkarlsson.scheduler.SchedulerName;
import com.github.kagkarlsson.scheduler.boot.config.DbSchedulerCustomizer;
import com.github.kagkarlsson.scheduler.boot.config.DbSchedulerProperties;
import com.github.kagkarlsson.scheduler.event.ExecutionInterceptor;
import com.github.kagkarlsson.scheduler.event.SchedulerListener;
import com.github.kagkarlsson.scheduler.exceptions.SerializationException;
import com.github.kagkarlsson.scheduler.serializer.Serializer;
import com.github.kagkarlsson.scheduler.stats.StatsRegistry;
import com.github.kagkarlsson.scheduler.task.OnStartup;
import com.github.kagkarlsson.scheduler.task.Task;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ConfigurableObjectInputStream;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

public final class DbSchedulerConfigurationSupport {
    private static final Logger log = LoggerFactory.getLogger(DbSchedulerConfigurationSupport.class);
    private static final Predicate<Task<?>> SHOULD_BE_STARTED = task -> task instanceof OnStartup;
    public static final Serializer SPRING_JAVA_SERIALIZER = new Serializer(){

        /*
         * Enabled aggressive exception aggregation
         */
        public byte[] serialize(Object data) {
            if (data == null) {
                return null;
            }
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                byte[] byArray;
                try (ObjectOutputStream out = new ObjectOutputStream(bos);){
                    out.writeObject(data);
                    byArray = bos.toByteArray();
                }
                return byArray;
            }
            catch (Exception e) {
                throw new SerializationException("Failed to serialize object", (Throwable)e);
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public <T> T deserialize(Class<T> clazz, byte[] serializedData) {
            if (serializedData == null) {
                return null;
            }
            try (ByteArrayInputStream bis = new ByteArrayInputStream(serializedData);){
                T t;
                try (ConfigurableObjectInputStream in = new ConfigurableObjectInputStream((InputStream)bis, Thread.currentThread().getContextClassLoader());){
                    t = clazz.cast(in.readObject());
                }
                return t;
            }
            catch (Exception e) {
                throw new SerializationException("Failed to deserialize object", (Throwable)e);
            }
        }
    };

    private DbSchedulerConfigurationSupport() {
    }

    public static Scheduler buildScheduler(DbSchedulerProperties config, DbSchedulerCustomizer customizer, StatsRegistry registry, Clock clock, DataSource existingDataSource, List<Task<?>> configuredTasks, List<SchedulerListener> schedulerListeners, List<ExecutionInterceptor> executionInterceptors) {
        Objects.requireNonNull(config, "Configuration must not be null");
        Objects.requireNonNull(customizer, "Customizer must not be null");
        Objects.requireNonNull(registry, "StatsRegistry must not be null");
        Objects.requireNonNull(clock, "Clock must not be null");
        Objects.requireNonNull(existingDataSource, "DataSource must not be null");
        Objects.requireNonNull(configuredTasks, "Configured tasks must not be null");
        Objects.requireNonNull(schedulerListeners, "Scheduler listeners must not be null");
        Objects.requireNonNull(executionInterceptors, "Execution interceptors must not be null");
        DataSource transactionalDataSource = DbSchedulerConfigurationSupport.configureDataSource(customizer.dataSource().orElse(existingDataSource));
        SchedulerBuilder builder = Scheduler.create((DataSource)transactionalDataSource, DbSchedulerConfigurationSupport.nonStartupTasks(configuredTasks));
        builder.clock(clock);
        builder.threads(config.getThreads());
        builder.pollingInterval(config.getPollingInterval());
        if (config.getPollingStrategy() == PollingStrategyConfig.Type.FETCH) {
            builder.pollUsingFetchAndLockOnExecute(config.getPollingStrategyLowerLimitFractionOfThreads(), config.getPollingStrategyUpperLimitFractionOfThreads());
        } else if (config.getPollingStrategy() == PollingStrategyConfig.Type.LOCK_AND_FETCH) {
            builder.pollUsingLockAndFetch(config.getPollingStrategyLowerLimitFractionOfThreads(), config.getPollingStrategyUpperLimitFractionOfThreads());
        } else {
            throw new IllegalArgumentException("Unknown polling-strategy: " + String.valueOf(config.getPollingStrategy()));
        }
        builder.heartbeatInterval(config.getHeartbeatInterval());
        builder.missedHeartbeatsLimit(config.getMissedHeartbeatsLimit());
        if (customizer.schedulerName().isPresent()) {
            builder.schedulerName(customizer.schedulerName().get());
        } else if (config.getSchedulerName() != null) {
            builder.schedulerName((SchedulerName)new SchedulerName.Fixed(config.getSchedulerName()));
        }
        builder.tableName(config.getTableName());
        builder.serializer(customizer.serializer().orElse(SPRING_JAVA_SERIALIZER));
        customizer.jdbcCustomization().ifPresent(arg_0 -> ((SchedulerBuilder)builder).jdbcCustomization(arg_0));
        if (config.isAlwaysPersistTimestampInUtc()) {
            builder.alwaysPersistTimestampInUTC();
        }
        if (config.isImmediateExecutionEnabled()) {
            builder.enableImmediateExecution();
        }
        if (config.isPriorityEnabled()) {
            builder.enablePriority();
        }
        customizer.executorService().ifPresent(arg_0 -> ((SchedulerBuilder)builder).executorService(arg_0));
        customizer.dueExecutor().ifPresent(arg_0 -> ((SchedulerBuilder)builder).dueExecutor(arg_0));
        customizer.housekeeperExecutor().ifPresent(arg_0 -> ((SchedulerBuilder)builder).housekeeperExecutor(arg_0));
        builder.deleteUnresolvedAfter(config.getDeleteUnresolvedAfter());
        builder.startTasks(DbSchedulerConfigurationSupport.startupTasks(configuredTasks));
        builder.statsRegistry(registry);
        builder.failureLogging(config.getFailureLoggerLevel(), config.isFailureLoggerLogStackTrace());
        builder.shutdownMaxWait(config.getShutdownMaxWait());
        schedulerListeners.forEach(arg_0 -> ((SchedulerBuilder)builder).addSchedulerListener(arg_0));
        executionInterceptors.forEach(arg_0 -> ((SchedulerBuilder)builder).addExecutionInterceptor(arg_0));
        return builder.build();
    }

    public static DataSource configureDataSource(DataSource existingDataSource) {
        if (existingDataSource instanceof TransactionAwareDataSourceProxy) {
            log.debug("Using an already transaction aware DataSource");
            return existingDataSource;
        }
        log.debug("The configured DataSource is not transaction aware: '{}'. Wrapping in TransactionAwareDataSourceProxy.", (Object)existingDataSource);
        return new TransactionAwareDataSourceProxy(existingDataSource);
    }

    private static <T extends Task<?> & OnStartup> List<T> startupTasks(List<Task<?>> tasks) {
        return tasks.stream().filter(SHOULD_BE_STARTED).map(task -> task).collect(Collectors.toList());
    }

    private static List<Task<?>> nonStartupTasks(List<Task<?>> tasks) {
        return tasks.stream().filter(SHOULD_BE_STARTED.negate()).collect(Collectors.toList());
    }
}

