/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.boot.autoconfigure;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.github.kagkarlsson.scheduler.boot.autoconfigure.jackson3.InstantDeserializer;
import com.github.kagkarlsson.scheduler.boot.autoconfigure.jackson3.InstantSerializer;
import com.github.kagkarlsson.scheduler.exceptions.SerializationException;
import com.github.kagkarlsson.scheduler.serializer.Serializer;
import com.github.kagkarlsson.scheduler.serializer.jackson.ScheduleMixin;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import java.time.Instant;
import java.util.function.Consumer;
import tools.jackson.core.JacksonException;
import tools.jackson.core.Version;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.module.SimpleModule;

public class Jackson3Serializer
implements Serializer {
    private final ObjectMapper objectMapper;

    public Jackson3Serializer() {
        this(Jackson3Serializer.getDefaultObjectMapper());
    }

    public Jackson3Serializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Jackson3Serializer(Consumer<ObjectMapper> objectMapperCustomizer) {
        ObjectMapper defaultObjectMapper = Jackson3Serializer.getDefaultObjectMapper();
        objectMapperCustomizer.accept(defaultObjectMapper);
        this.objectMapper = defaultObjectMapper;
    }

    public static ObjectMapper getDefaultObjectMapper() {
        SimpleModule module = new SimpleModule("CustomInstantModule", Version.unknownVersion());
        module.addSerializer(Instant.class, (ValueSerializer)new InstantSerializer());
        module.addDeserializer(Instant.class, (ValueDeserializer)new InstantDeserializer());
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new MapperFeature[]{MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS})).changeDefaultVisibility(v -> v.withFieldVisibility(JsonAutoDetect.Visibility.ANY))).addMixIn(Schedule.class, ScheduleMixin.class)).addModule((JacksonModule)module)).build();
    }

    public byte[] serialize(Object object) {
        try {
            return this.objectMapper.writeValueAsBytes(object);
        }
        catch (JacksonException e) {
            throw new SerializationException("Failed to serialize object.", (Throwable)e);
        }
    }

    public <T> T deserialize(Class<T> clazz, byte[] serializedData) {
        try {
            return (T)this.objectMapper.readValue(serializedData, clazz);
        }
        catch (JacksonException e) {
            throw new SerializationException("Failed to deserialize object.", (Throwable)e);
        }
    }
}

