/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Reader;
import org.jsfr.json.AbstractPrimitiveHolder;
import org.jsfr.json.JsonParserAdapter;
import org.jsfr.json.PrimitiveHolder;
import org.jsfr.json.StaticPrimitiveHolder;
import org.jsfr.json.SurfingContext;
import org.jsfr.json.provider.JsonProvider;

public class JacksonParser
implements JsonParserAdapter {
    public static final JacksonParser INSTANCE = new JacksonParser();
    private static final JsonFactory JSON_FACTORY = new JsonFactory();

    private JacksonParser() {
    }

    public void parse(Reader reader, SurfingContext context) {
        try {
            JsonParser jp = JSON_FACTORY.createParser(reader);
            this.doPare(jp, context);
        }
        catch (Exception e) {
            context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
        }
    }

    public void parse(String json, SurfingContext context) {
        try {
            JsonParser jp = JSON_FACTORY.createParser(json);
            this.doPare(jp, context);
        }
        catch (Exception e) {
            context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
        }
    }

    private void doPare(final JsonParser jp, SurfingContext context) throws IOException {
        final JsonProvider jsonProvider = context.getConfig().getJsonProvider();
        AbstractPrimitiveHolder stringHolder = new AbstractPrimitiveHolder(context.getConfig()){

            public Object doGetValue() throws Exception {
                return jsonProvider.primitive(jp.getText());
            }

            public void doSkipValue() throws Exception {
            }
        };
        AbstractPrimitiveHolder longHolder = new AbstractPrimitiveHolder(context.getConfig()){

            public Object doGetValue() throws Exception {
                return jsonProvider.primitive(jp.getLongValue());
            }

            public void doSkipValue() throws Exception {
            }
        };
        AbstractPrimitiveHolder doubleHolder = new AbstractPrimitiveHolder(context.getConfig()){

            public Object doGetValue() throws Exception {
                return jsonProvider.primitive(jp.getDoubleValue());
            }

            public void doSkipValue() throws Exception {
            }
        };
        StaticPrimitiveHolder staticPrimitiveHolder = new StaticPrimitiveHolder();
        context.startJSON();
        block15: while (!context.isStopped()) {
            JsonToken token = jp.nextToken();
            if (token == null) {
                context.endJSON();
                return;
            }
            switch (token) {
                case NOT_AVAILABLE: {
                    return;
                }
                case START_OBJECT: {
                    context.startObject();
                    continue block15;
                }
                case END_OBJECT: {
                    context.endObject();
                    continue block15;
                }
                case START_ARRAY: {
                    context.startArray();
                    continue block15;
                }
                case END_ARRAY: {
                    context.endArray();
                    continue block15;
                }
                case FIELD_NAME: {
                    context.startObjectEntry(jp.getCurrentName());
                    continue block15;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    throw new IllegalStateException("Unexpected token");
                }
                case VALUE_STRING: {
                    stringHolder.init();
                    context.primitive((PrimitiveHolder)stringHolder);
                    stringHolder.skipValue();
                    continue block15;
                }
                case VALUE_NUMBER_INT: {
                    longHolder.init();
                    context.primitive((PrimitiveHolder)longHolder);
                    longHolder.skipValue();
                    continue block15;
                }
                case VALUE_NUMBER_FLOAT: {
                    doubleHolder.init();
                    context.primitive((PrimitiveHolder)doubleHolder);
                    doubleHolder.skipValue();
                    continue block15;
                }
                case VALUE_TRUE: {
                    context.primitive((PrimitiveHolder)staticPrimitiveHolder.withValue(jsonProvider.primitive(true)));
                    continue block15;
                }
                case VALUE_FALSE: {
                    context.primitive((PrimitiveHolder)staticPrimitiveHolder.withValue(jsonProvider.primitive(false)));
                    continue block15;
                }
                case VALUE_NULL: {
                    context.primitive((PrimitiveHolder)staticPrimitiveHolder.withValue(jsonProvider.primitiveNull()));
                    continue block15;
                }
            }
            throw new IllegalStateException("Unexpected token");
        }
    }
}

