/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json.path;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jsfr.json.filter.JsonPathFilter;
import org.jsfr.json.path.ArrayFilter;
import org.jsfr.json.path.ArrayIndex;
import org.jsfr.json.path.ArrayIndexes;
import org.jsfr.json.path.ArraySlicing;
import org.jsfr.json.path.ChildNode;
import org.jsfr.json.path.ChildrenNode;
import org.jsfr.json.path.DeepScan;
import org.jsfr.json.path.FilterRoot;
import org.jsfr.json.path.PathOperator;
import org.jsfr.json.path.Root;
import org.jsfr.json.path.Wildcard;
import org.jsfr.json.resolver.DocumentResolver;

public class JsonPath
implements Iterable<PathOperator> {
    private static final int JSON_PATH_INITIAL_CAPACITY = 20;
    private boolean definite = true;
    protected PathOperator[] operators = new PathOperator[20];
    protected int size;

    @Override
    public Iterator<PathOperator> iterator() {
        return new JsonPathIterator();
    }

    protected JsonPath() {
        this(false);
    }

    protected JsonPath(boolean filterPath) {
        this.operators[0] = filterPath ? FilterRoot.instance() : Root.instance();
        this.size = 1;
    }

    public Object resolve(Object document, DocumentResolver resolver) {
        if (!this.isDefinite()) {
            throw new IllegalArgumentException("Indefinite JsonPath is not supported.");
        }
        Object current = document;
        for (PathOperator pathOperator : this) {
            if (current == null) {
                return null;
            }
            current = pathOperator.resolve(current, resolver);
        }
        return current;
    }

    public boolean match(JsonPath jsonPath) {
        int pointer1 = this.size - 1;
        int pointer2 = jsonPath.size - 1;
        if (!this.get(pointer1).match(jsonPath.get(pointer2))) {
            return false;
        }
        --pointer1;
        --pointer2;
        while (pointer1 >= 0) {
            PathOperator o2;
            PathOperator o1;
            if (pointer2 < 0) {
                return false;
            }
            if ((o1 = this.get(pointer1--)).match(o2 = jsonPath.get(pointer2--))) continue;
            return false;
        }
        return pointer2 < 0;
    }

    public boolean matchWithDeepScan(JsonPath jsonPath) {
        int pointer1 = this.size - 1;
        int pointer2 = jsonPath.size - 1;
        if (!this.get(pointer1).match(jsonPath.get(pointer2))) {
            return false;
        }
        --pointer1;
        --pointer2;
        while (pointer1 >= 0) {
            if (pointer2 < 0) {
                return false;
            }
            PathOperator o1 = this.get(pointer1--);
            PathOperator o2 = jsonPath.get(pointer2--);
            if (o1.getType() == PathOperator.Type.DEEP_SCAN) {
                int offset2;
                int blockHead = this.indexOfPreviousDeepScanOrRoot(this, pointer1);
                int blockSize = pointer1 - blockHead;
                for (offset2 = pointer2 - blockSize + 2; offset2 > 0 && !this.matchPathBlock(this, blockHead + 1, jsonPath, offset2, blockSize); --offset2) {
                }
                pointer1 = blockHead;
                pointer2 = offset2 - 1;
                continue;
            }
            if (o1.match(o2)) continue;
            return false;
        }
        return pointer2 < 0;
    }

    private boolean matchPathBlock(JsonPath path1, int offset1, JsonPath path2, int offset2, int blockSize) {
        for (int i = 0; i < blockSize; ++i) {
            if (path1.get(offset1 + i).match(path2.get(offset2 + i))) continue;
            return false;
        }
        return true;
    }

    private int indexOfPreviousDeepScanOrRoot(JsonPath path, int from) {
        int pointer;
        for (pointer = from - 1; pointer > 0; --pointer) {
            if (path.get(pointer).getType() != PathOperator.Type.DEEP_SCAN) continue;
            return pointer;
        }
        return pointer;
    }

    private int indexOfPreviousDeepScanOrFilter(JsonPath path, int from) {
        int pointer;
        for (pointer = from - 1; pointer > 0; --pointer) {
            if (path.get(pointer).getType() != PathOperator.Type.DEEP_SCAN && !(path.get(pointer) instanceof ArrayFilter)) continue;
            return pointer;
        }
        return pointer;
    }

    public boolean matchFilterPath(JsonPath jsonPath, int startDepth) {
        int pointer1 = this.size - 1;
        int pointer2 = jsonPath.size - 1;
        if (!this.get(pointer1).match(jsonPath.get(pointer2))) {
            return false;
        }
        --pointer1;
        --pointer2;
        while (pointer1 >= 0) {
            if (pointer2 < 0) {
                return false;
            }
            PathOperator o1 = this.get(pointer1--);
            PathOperator o2 = jsonPath.get(pointer2--);
            if (o1.getType() == PathOperator.Type.FILTER_ROOT && pointer2 + 2 == startDepth) {
                return true;
            }
            if (o1.match(o2)) continue;
            return false;
        }
        return pointer2 < 0;
    }

    public boolean matchFilterPathUntilDepth(JsonPath jsonPath, int startDepth) {
        int pointer1 = this.size - 1;
        int pointer2 = jsonPath.size - 1;
        while (pointer1 >= 0) {
            if (pointer2 < 0) {
                return false;
            }
            PathOperator o1 = this.get(pointer1--);
            PathOperator o2 = jsonPath.get(pointer2--);
            if (o1 instanceof ArrayFilter) {
                return pointer2 + 2 == startDepth;
            }
            if (o1.getType() == PathOperator.Type.DEEP_SCAN) {
                int offset2;
                int blockHead = this.indexOfPreviousDeepScanOrFilter(this, pointer1);
                int blockSize = pointer1 - blockHead;
                for (offset2 = pointer2 - blockSize + 2; offset2 > 0 && !this.matchPathBlock(this, blockHead + 1, jsonPath, offset2, blockSize); --offset2) {
                }
                pointer1 = blockHead;
                pointer2 = offset2 - 1;
                continue;
            }
            if (o1.match(o2)) continue;
            return false;
        }
        return pointer2 < 0;
    }

    public JsonPath derivePath(int depth) {
        JsonPath newPath = new JsonPath();
        newPath.size = depth;
        newPath.operators = this.operators;
        return newPath;
    }

    public PathOperator get(int i) {
        return this.operators[i];
    }

    public PathOperator peek() {
        return this.operators[this.size - 1];
    }

    protected void push(PathOperator operator) {
        this.ensureCapacity(this.size + 1);
        this.operators[this.size++] = operator;
    }

    private void ensureCapacity(int capacity) {
        if (this.operators.length < capacity) {
            PathOperator[] newOperators = new PathOperator[this.operators.length * 2];
            System.arraycopy(this.operators, 0, newOperators, 0, this.operators.length);
            this.operators = newOperators;
        }
    }

    protected void pop() {
        --this.size;
    }

    public int pathDepth() {
        return this.size;
    }

    public void clear() {
        this.operators = null;
    }

    public static int minimumPathDepth(JsonPath path) {
        if (path.definite) {
            return path.pathDepth();
        }
        int minimumDepth = 0;
        for (PathOperator operator : path) {
            if (operator.getType() == PathOperator.Type.DEEP_SCAN) continue;
            ++minimumDepth;
        }
        return minimumDepth;
    }

    public boolean isDefinite() {
        return this.definite;
    }

    public boolean checkDefinite() {
        for (PathOperator operator : this) {
            if (operator.getType() != PathOperator.Type.DEEP_SCAN) continue;
            this.definite = false;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (PathOperator operator : this) {
            sb.append(operator);
        }
        return sb.toString();
    }

    public static class Builder {
        private JsonPath jsonPath;

        public static Builder start() {
            Builder builder = new Builder();
            builder.jsonPath = new JsonPath();
            return builder;
        }

        public static Builder startFilterPath() {
            Builder builder = new Builder();
            builder.jsonPath = new JsonPath(true);
            return builder;
        }

        public Builder child(String key) {
            this.jsonPath.push(new ChildNode(key));
            return this;
        }

        public Builder children(String ... children) {
            this.jsonPath.push(new ChildrenNode(new HashSet<String>(Arrays.asList(children))));
            return this;
        }

        public Builder anyChild() {
            this.jsonPath.push(Wildcard.SINGLETON);
            return this;
        }

        public Builder index(int index) {
            this.jsonPath.push(new ArrayIndex(index));
            return this;
        }

        public Builder indexes(Integer ... indexes) {
            this.jsonPath.push(new ArrayIndexes(new HashSet<Integer>(Arrays.asList(indexes))));
            return this;
        }

        public Builder anyIndex() {
            this.jsonPath.push(Wildcard.SINGLETON);
            return this;
        }

        public Builder scan() {
            this.jsonPath.definite = false;
            if (this.jsonPath.peek().getType() != PathOperator.Type.DEEP_SCAN) {
                this.jsonPath.push(DeepScan.SINGLETON);
            }
            return this;
        }

        public Builder any() {
            this.jsonPath.push(Wildcard.SINGLETON);
            return this;
        }

        public Builder slicing(Integer lower, Integer upper) {
            this.jsonPath.push(new ArraySlicing(lower, upper));
            return this;
        }

        public Builder arrayFilter(JsonPathFilter jsonPathFilter) {
            this.jsonPath.push(new ArrayFilter(jsonPathFilter));
            return this;
        }

        public JsonPath build() {
            if (this.jsonPath.peek().getType() == PathOperator.Type.DEEP_SCAN) {
                throw new IllegalStateException("deep-scan shouldn't be the last operator.");
            }
            return this.jsonPath;
        }
    }

    private class JsonPathIterator
    implements Iterator<PathOperator> {
        private int current = 0;

        private JsonPathIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current < JsonPath.this.size;
        }

        @Override
        public PathOperator next() {
            if (this.current >= JsonPath.this.size) {
                throw new NoSuchElementException();
            }
            return JsonPath.this.operators[this.current++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("unsupported");
        }
    }
}

