/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jsfr.json.ContentDispatcher;
import org.jsfr.json.DispatchUtil;
import org.jsfr.json.FilterVerifierDispatcher;
import org.jsfr.json.JsonCollector;
import org.jsfr.json.JsonFilterVerifier;
import org.jsfr.json.JsonPathListener;
import org.jsfr.json.JsonPosition;
import org.jsfr.json.JsonSaxHandler;
import org.jsfr.json.ParsingContext;
import org.jsfr.json.PrimitiveHolder;
import org.jsfr.json.SurfingConfiguration;
import org.jsfr.json.path.ArrayIndex;
import org.jsfr.json.path.ChildNode;
import org.jsfr.json.path.PathOperator;

public class SurfingContext
implements ParsingContext,
JsonSaxHandler {
    private boolean stopped = false;
    private boolean paused = false;
    private JsonPosition currentPosition;
    private ContentDispatcher dispatcher = new ContentDispatcher();
    private FilterVerifierDispatcher filterVerifierDispatcher;
    private SurfingConfiguration config;
    private Map<String, Object> transientMap;

    SurfingContext(SurfingConfiguration config) {
        this.config = config;
        this.filterVerifierDispatcher = new FilterVerifierDispatcher();
    }

    private void doMatching(PrimitiveHolder primitiveHolder) {
        SurfingConfiguration.Binding[] bindings;
        if (!this.config.hasFilter() && this.config.isSkipOverlappedPath() && !this.dispatcher.isEmpty()) {
            return;
        }
        LinkedList<JsonPathListener> listeners = null;
        int currentDepth = this.currentPosition.pathDepth();
        for (SurfingConfiguration.IndefinitePathBinding binding : this.config.getIndefinitePathLookup()) {
            if (binding.minimumPathDepth > currentDepth) break;
            listeners = this.doMatching(binding, primitiveHolder, listeners, false);
        }
        if ((bindings = this.config.getDefinitePathBind(currentDepth)) != null) {
            for (SurfingConfiguration.Binding binding : bindings) {
                listeners = this.doMatching(binding, primitiveHolder, listeners, true);
            }
        }
        if (listeners != null) {
            JsonCollector collector = new JsonCollector(listeners.size() == 1 ? Collections.singleton(listeners.getFirst()) : listeners, this, this.config);
            this.dispatcher.addReceiver(collector);
        }
    }

    private void doMatchingWithFilter(SurfingConfiguration.Binding binding, boolean definiteBinding) {
        if (binding.filter != null) {
            boolean matched;
            boolean bl = matched = definiteBinding ? binding.jsonPath.match(this.currentPosition) : binding.jsonPath.matchWithDeepScan(this.currentPosition);
            if (matched) {
                this.filterVerifierDispatcher.addVerifier(binding, new JsonFilterVerifier(this.currentPosition, this.config, binding));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LinkedList<JsonPathListener> doMatching(SurfingConfiguration.Binding binding, PrimitiveHolder primitiveHolder, LinkedList<JsonPathListener> listeners, boolean definiteBinding) {
        if (binding.filter != null) {
            return listeners;
        }
        if (binding.dependency != null) {
            if (primitiveHolder == null) return this.addListenersWithFilter(binding, listeners);
            this.dispatchPrimitiveWithFilter(primitiveHolder.getValue(), binding);
            return listeners;
        } else {
            boolean matched;
            boolean bl = matched = definiteBinding ? binding.jsonPath.match(this.currentPosition) : binding.jsonPath.matchWithDeepScan(this.currentPosition);
            if (!matched) return listeners;
            if (primitiveHolder == null) return this.addListeners(binding, listeners);
            this.dispatchPrimitive(binding.getListeners(), primitiveHolder.getValue());
        }
        return listeners;
    }

    private LinkedList<JsonPathListener> addListenersWithFilter(SurfingConfiguration.Binding binding, LinkedList<JsonPathListener> listeners) {
        LinkedList<JsonPathListener> listenersToAdd = listeners == null ? new LinkedList<JsonPathListener>() : listeners;
        List<JsonPathListener> buffered = this.filterVerifierDispatcher.dispatch(this.currentPosition, binding);
        listenersToAdd.addAll(buffered);
        return listenersToAdd;
    }

    private LinkedList<JsonPathListener> addListeners(SurfingConfiguration.Binding binding, LinkedList<JsonPathListener> listeners) {
        LinkedList<JsonPathListener> listenersToAdd = listeners == null ? new LinkedList<JsonPathListener>() : listeners;
        Collections.addAll(listenersToAdd, binding.getListeners());
        return listenersToAdd;
    }

    private void dispatchPrimitiveWithFilter(Object primitive, SurfingConfiguration.Binding binding) {
        List<JsonPathListener> buffered = this.filterVerifierDispatcher.dispatch(this.currentPosition, binding);
        for (JsonPathListener listener : buffered) {
            listener.onValue(primitive, this);
        }
    }

    private void dispatchPrimitive(JsonPathListener[] listeners, Object primitive) {
        DispatchUtil.dispatchValueToListeners(primitive, listeners, (ParsingContext)this, this.config.getErrorHandlingStrategy());
    }

    @Override
    public boolean startJSON() {
        this.currentPosition = JsonPosition.start();
        this.doMatching(null);
        this.dispatcher.startJSON();
        this.filterVerifierDispatcher.startJSON();
        return true;
    }

    @Override
    public boolean endJSON() {
        this.dispatcher.endJSON();
        this.filterVerifierDispatcher.endJSON();
        this.currentPosition.clear();
        this.currentPosition = null;
        this.stop();
        return true;
    }

    @Override
    public boolean startObject() {
        if (this.shouldBreak()) {
            return false;
        }
        PathOperator currentNode = this.currentPosition.peek();
        switch (currentNode.getType()) {
            case OBJECT: {
                this.matchFilter();
                this.doMatching(null);
                break;
            }
            case ARRAY: {
                this.accumulateArrayIndex((ArrayIndex)currentNode);
                this.matchFilter();
                this.doMatching(null);
                break;
            }
            case ROOT: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.currentPosition.stepIntoObject();
        this.dispatcher.startObject();
        this.filterVerifierDispatcher.startObject();
        return true;
    }

    private void matchFilter() {
        if (this.config.hasFilter()) {
            SurfingConfiguration.Binding[] bindings;
            int currentDepth = this.currentPosition.pathDepth();
            for (SurfingConfiguration.IndefinitePathBinding binding : this.config.getIndefinitePathLookup()) {
                if (binding.minimumPathDepth > currentDepth) break;
                this.doMatchingWithFilter(binding, false);
            }
            if ((bindings = this.config.getDefinitePathBind(currentDepth)) != null) {
                for (SurfingConfiguration.Binding binding : bindings) {
                    this.doMatchingWithFilter(binding, true);
                }
            }
        }
    }

    @Override
    public boolean endObject() {
        if (this.shouldBreak()) {
            return false;
        }
        this.currentPosition.stepOutObject();
        this.dispatcher.endObject();
        this.filterVerifierDispatcher.endObject();
        return true;
    }

    @Override
    public boolean startObjectEntry(String key) {
        if (this.shouldBreak()) {
            return false;
        }
        this.currentPosition.updateObjectEntry(key);
        this.dispatcher.startObjectEntry(key);
        this.filterVerifierDispatcher.startObjectEntry(key);
        return true;
    }

    @Override
    public boolean startArray() {
        if (this.shouldBreak()) {
            return false;
        }
        PathOperator currentNode = this.currentPosition.peek();
        switch (currentNode.getType()) {
            case OBJECT: {
                this.matchFilter();
                this.doMatching(null);
                break;
            }
            case ARRAY: {
                this.accumulateArrayIndex((ArrayIndex)currentNode);
                this.matchFilter();
                this.doMatching(null);
                break;
            }
            case ROOT: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.currentPosition.stepIntoArray();
        this.dispatcher.startArray();
        this.filterVerifierDispatcher.startArray();
        return true;
    }

    private void accumulateArrayIndex(ArrayIndex arrayIndex) {
        arrayIndex.increaseArrayIndex();
    }

    @Override
    public boolean endArray() {
        if (this.shouldBreak()) {
            return false;
        }
        this.currentPosition.stepOutArray();
        this.dispatcher.endArray();
        this.filterVerifierDispatcher.endArray();
        return true;
    }

    @Override
    public boolean primitive(PrimitiveHolder primitiveHolder) {
        if (this.shouldBreak()) {
            return false;
        }
        PathOperator currentNode = this.currentPosition.peek();
        switch (currentNode.getType()) {
            case OBJECT: {
                this.doMatching(primitiveHolder);
                break;
            }
            case ARRAY: {
                this.accumulateArrayIndex((ArrayIndex)currentNode);
                this.doMatching(primitiveHolder);
                break;
            }
            case ROOT: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.dispatcher.primitive(primitiveHolder);
        this.filterVerifierDispatcher.primitive(primitiveHolder);
        return true;
    }

    @Override
    public String getJsonPath() {
        return this.currentPosition.toString();
    }

    @Override
    public String getCurrentFieldName() {
        PathOperator top = this.currentPosition.peek();
        if (top instanceof ChildNode) {
            return ((ChildNode)top).getKey();
        }
        return null;
    }

    @Override
    public int getCurrentArrayIndex() {
        PathOperator top = this.currentPosition.peek();
        if (top.getType() == PathOperator.Type.ARRAY) {
            return ((ArrayIndex)top).getArrayIndex();
        }
        return -1;
    }

    @Override
    public void save(String key, Object value) {
        if (this.transientMap == null) {
            this.transientMap = new HashMap<String, Object>();
        }
        this.transientMap.put(key, value);
    }

    @Override
    public <T> T load(String key, Class<T> tClass) {
        return this.transientMap != null ? (T)tClass.cast(this.transientMap.get(key)) : null;
    }

    @Override
    public <T> T cast(Object object, Class<T> tClass) {
        return this.config.getJsonProvider().cast(object, tClass);
    }

    public boolean shouldBreak() {
        return this.stopped || this.paused;
    }

    @Override
    public void stop() {
        this.stopped = true;
        this.paused = false;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void resume() {
        this.paused = false;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    public SurfingConfiguration getConfig() {
        return this.config;
    }
}

