/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json.path;

import org.jsfr.json.path.ArrayIndex;
import org.jsfr.json.path.PathOperator;

public class ArraySlicing
extends PathOperator {
    private Integer lowerBound;
    private Integer upperBound;

    protected ArraySlicing(Integer lowerBound, Integer upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    public boolean match(PathOperator pathOperator) {
        if (!super.match(pathOperator)) {
            return false;
        }
        if (pathOperator instanceof ArrayIndex) {
            int index = ((ArrayIndex)pathOperator).getArrayIndex();
            if (this.lowerBound == null && this.upperBound == null) {
                return true;
            }
            if (this.lowerBound == null) {
                return index < this.upperBound;
            }
            if (this.upperBound == null) {
                return index >= this.lowerBound;
            }
            return this.lowerBound <= index && index < this.upperBound;
        }
        throw new IllegalStateException("unexpected path operator: " + pathOperator);
    }

    @Override
    public PathOperator.Type getType() {
        return PathOperator.Type.ARRAY;
    }
}

