/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json.filter;

import java.math.BigDecimal;
import org.jsfr.json.PrimitiveHolder;
import org.jsfr.json.filter.AbstractJsonPathFilter;
import org.jsfr.json.path.JsonPath;
import org.jsfr.json.provider.JsonProvider;

public class GreaterThanNumPredicate
extends AbstractJsonPathFilter {
    private BigDecimal value;

    public GreaterThanNumPredicate(JsonPath relativePath, BigDecimal value) {
        super(relativePath);
        this.value = value;
    }

    @Override
    public boolean apply(JsonPath jsonPosition, PrimitiveHolder primitiveHolder, JsonProvider jsonProvider) {
        if (this.getRelativePath().matchFilterPath(jsonPosition)) {
            Object candidate = primitiveHolder.getValue();
            return candidate != null && new BigDecimal(candidate.toString()).compareTo(this.value) > 0;
        }
        return false;
    }
}

