/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import java.io.Reader;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jsfr.json.CollectAllListener;
import org.jsfr.json.CollectOneListener;
import org.jsfr.json.DefaultErrorHandlingStrategy;
import org.jsfr.json.ErrorHandlingStrategy;
import org.jsfr.json.JsonParserAdapter;
import org.jsfr.json.JsonPathListener;
import org.jsfr.json.NonBlockingParser;
import org.jsfr.json.ParsingContext;
import org.jsfr.json.ResumableParser;
import org.jsfr.json.SurfingConfiguration;
import org.jsfr.json.SurfingContext;
import org.jsfr.json.compiler.JsonPathCompiler;
import org.jsfr.json.path.JsonPath;
import org.jsfr.json.provider.JsonProvider;

public class JsonSurfer {
    private static final String KEY_HAS_MATCH = "_JSURFER_INTERNAL_HAS_MATCH_";
    private static final String KEY_MATCH = "_JSURFER_INTERNAL_MATCH_";
    private JsonProvider jsonProvider;
    private JsonParserAdapter jsonParserAdapter;
    private ErrorHandlingStrategy errorHandlingStrategy;

    public JsonSurfer(JsonParserAdapter jsonParserAdapter, JsonProvider jsonProvider) {
        this(jsonParserAdapter, jsonProvider, new DefaultErrorHandlingStrategy());
    }

    public JsonSurfer(JsonParserAdapter jsonParserAdapter, JsonProvider jsonProvider, ErrorHandlingStrategy errorHandlingStrategy) {
        this.jsonProvider = jsonProvider;
        this.jsonParserAdapter = jsonParserAdapter;
        this.errorHandlingStrategy = errorHandlingStrategy;
    }

    public SurfingConfiguration.Builder configBuilder() {
        return SurfingConfiguration.builder().withSurfer(this);
    }

    public Iterator<Object> iterator(Reader reader, JsonPath jsonPath) {
        SurfingContext context = this.createIteratorContext(jsonPath);
        ResumableParser resumableParser = this.jsonParserAdapter.createResumableParser(reader, context);
        resumableParser.parse();
        return this.createIterator(context, resumableParser);
    }

    public Iterator<Object> iterator(String json, JsonPath jsonPath) {
        SurfingContext context = this.createIteratorContext(jsonPath);
        ResumableParser resumableParser = this.jsonParserAdapter.createResumableParser(json, context);
        resumableParser.parse();
        return this.createIterator(context, resumableParser);
    }

    private Iterator<Object> createIterator(final SurfingContext context, final ResumableParser resumableParser) {
        return new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return context.load(JsonSurfer.KEY_HAS_MATCH, Boolean.class) != false || resumableParser.resume() && context.load(JsonSurfer.KEY_HAS_MATCH, Boolean.class) != false;
            }

            @Override
            public Object next() {
                if (this.hasNext()) {
                    Object match = context.load(JsonSurfer.KEY_MATCH, Object.class);
                    context.save(JsonSurfer.KEY_HAS_MATCH, false);
                    context.save(JsonSurfer.KEY_MATCH, null);
                    return match;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove unsupported");
            }
        };
    }

    private SurfingContext createIteratorContext(JsonPath jsonPath) {
        SurfingConfiguration config = SurfingConfiguration.builder().bind(jsonPath, new JsonPathListener(){

            @Override
            public void onValue(Object value, ParsingContext context) {
                context.save(JsonSurfer.KEY_MATCH, value);
                context.save(JsonSurfer.KEY_HAS_MATCH, true);
                context.pause();
            }
        }).build();
        this.ensureSetting(config);
        SurfingContext context = new SurfingContext(config);
        context.save(KEY_HAS_MATCH, false);
        context.pause();
        return context;
    }

    public void surf(String json, SurfingConfiguration configuration) {
        this.ensureSetting(configuration);
        this.jsonParserAdapter.parse(json, new SurfingContext(configuration));
    }

    public void surf(Reader json, SurfingConfiguration configuration) {
        this.ensureSetting(configuration);
        this.jsonParserAdapter.parse(json, new SurfingContext(configuration));
    }

    public ResumableParser createResumableParser(String json, SurfingConfiguration configuration) {
        this.ensureSetting(configuration);
        return this.jsonParserAdapter.createResumableParser(json, new SurfingContext(configuration));
    }

    public ResumableParser createResumableParser(Reader json, SurfingConfiguration configuration) {
        this.ensureSetting(configuration);
        return this.jsonParserAdapter.createResumableParser(json, new SurfingContext(configuration));
    }

    public NonBlockingParser createNonBlockingParser(SurfingConfiguration configuration) {
        this.ensureSetting(configuration);
        return this.jsonParserAdapter.createNonBlockingParser(new SurfingContext(configuration));
    }

    public Collection<Object> collectAll(String json, String ... paths) {
        return this.collectAll(json, JsonPathCompiler.compile(paths));
    }

    public Collection<Object> collectAll(String json, JsonPath ... paths) {
        return this.collectAll(json, Object.class, paths);
    }

    public <T> Collection<T> collectAll(String json, Class<T> tClass, JsonPath ... paths) {
        CollectAllListener<T> listener = new CollectAllListener<T>(this.jsonProvider, tClass);
        SurfingConfiguration.Builder builder = this.configBuilder();
        for (JsonPath jsonPath : paths) {
            builder.bind(jsonPath, listener);
        }
        this.surf(json, builder.build());
        return listener.getCollection();
    }

    public Collection<Object> collectAll(Reader reader, String ... paths) {
        return this.collectAll(reader, JsonPathCompiler.compile(paths));
    }

    public Collection<Object> collectAll(Reader reader, JsonPath ... paths) {
        return this.collectAll(reader, Object.class, paths);
    }

    public <T> Collection<T> collectAll(Reader reader, Class<T> tClass, JsonPath ... paths) {
        CollectAllListener<T> listener = new CollectAllListener<T>(this.jsonProvider, tClass);
        SurfingConfiguration.Builder builder = this.configBuilder();
        for (JsonPath jsonPath : paths) {
            builder.bind(jsonPath, listener);
        }
        this.surf(reader, builder.build());
        return listener.getCollection();
    }

    public Object collectOne(String json, String ... paths) {
        return this.collectOne(json, JsonPathCompiler.compile(paths));
    }

    public Object collectOne(String json, JsonPath ... paths) {
        return this.collectOne(json, Object.class, paths);
    }

    public <T> T collectOne(String json, Class<T> tClass, JsonPath ... paths) {
        CollectOneListener listener = new CollectOneListener(true);
        SurfingConfiguration.Builder builder = this.configBuilder().skipOverlappedPath();
        for (JsonPath jsonPath : paths) {
            builder.bind(jsonPath, listener);
        }
        this.surf(json, builder.build());
        Object value = listener.getValue();
        return tClass.cast(this.jsonProvider.cast(value, tClass));
    }

    public Object collectOne(Reader reader, String ... paths) {
        return this.collectOne(reader, JsonPathCompiler.compile(paths));
    }

    public Object collectOne(Reader reader, JsonPath ... paths) {
        return this.collectOne(reader, Object.class, paths);
    }

    public <T> T collectOne(Reader reader, Class<T> tClass, JsonPath ... paths) {
        CollectOneListener listener = new CollectOneListener(true);
        SurfingConfiguration.Builder builder = this.configBuilder().skipOverlappedPath();
        for (JsonPath jsonPath : paths) {
            builder.bind(jsonPath, listener);
        }
        this.surf(reader, builder.build());
        Object value = listener.getValue();
        return tClass.cast(this.jsonProvider.cast(value, tClass));
    }

    private void ensureSetting(SurfingConfiguration configuration) {
        if (configuration.getJsonProvider() == null) {
            configuration.setJsonProvider(this.jsonProvider);
        }
        if (configuration.getErrorHandlingStrategy() == null) {
            configuration.setErrorHandlingStrategy(this.errorHandlingStrategy);
        }
    }
}

