/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json.filter;

import java.util.ArrayDeque;
import java.util.Deque;
import org.jsfr.json.filter.AggregatePredicate;
import org.jsfr.json.filter.AndPredicate;
import org.jsfr.json.filter.JsonPathFilter;
import org.jsfr.json.filter.OrPredicate;

public class FilterBuilder {
    private Deque<AggregatePredicate> stack = new ArrayDeque<AggregatePredicate>();
    private JsonPathFilter resultFilter;

    public FilterBuilder startAndPredicate() {
        AndPredicate newPredicate = new AndPredicate();
        if (!this.stack.isEmpty()) {
            this.append(newPredicate);
        }
        this.stack.push(newPredicate);
        return this;
    }

    public FilterBuilder endAndPredicate() {
        this.resultFilter = this.stack.pop();
        return this;
    }

    public FilterBuilder startOrPredicate() {
        OrPredicate newPredicate = new OrPredicate();
        if (!this.stack.isEmpty()) {
            this.append(newPredicate);
        }
        this.stack.push(newPredicate);
        return this;
    }

    public FilterBuilder endOrPredicate() {
        this.resultFilter = this.stack.pop();
        return this;
    }

    public FilterBuilder append(JsonPathFilter filter) {
        if (this.stack.isEmpty()) {
            this.resultFilter = filter;
        } else {
            this.stack.peek().addFilter(filter);
        }
        return this;
    }

    public JsonPathFilter build() {
        return this.resultFilter;
    }
}

