/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jsfr.json.ErrorHandlingStrategy;
import org.jsfr.json.JsonPathListener;
import org.jsfr.json.JsonSurfer;
import org.jsfr.json.ParsingContext;
import org.jsfr.json.TypedJsonPathListener;
import org.jsfr.json.compiler.JsonPathCompiler;
import org.jsfr.json.path.JsonPath;
import org.jsfr.json.provider.JsonProvider;

public class SurfingConfiguration {
    private static final Comparator<IndefinitePathBinding> INDEFINITE_BINDING_COMPARATOR = new Comparator<IndefinitePathBinding>(){

        @Override
        public int compare(IndefinitePathBinding o1, IndefinitePathBinding o2) {
            return Integer.compare(o1.minimumPathDepth, o2.minimumPathDepth);
        }
    };
    private int minDepth = Integer.MAX_VALUE;
    private int maxDepth = -1;
    private boolean skipOverlappedPath = false;
    private Binding[][] definitePathLookup;
    private IndefinitePathBinding[] indefinitePathLookup = new IndefinitePathBinding[0];
    private JsonProvider jsonProvider;
    private ErrorHandlingStrategy errorHandlingStrategy;

    public static Builder builder() {
        Builder builder = new Builder();
        builder.configuration = new SurfingConfiguration();
        return builder;
    }

    public int getMinDepth() {
        return this.minDepth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public boolean isSkipOverlappedPath() {
        return this.skipOverlappedPath;
    }

    public boolean hasDefinitePath() {
        return this.definitePathLookup != null;
    }

    public IndefinitePathBinding[] getIndefinitePathLookup() {
        return this.indefinitePathLookup;
    }

    public JsonProvider getJsonProvider() {
        return this.jsonProvider;
    }

    public void setJsonProvider(JsonProvider jsonProvider) {
        this.jsonProvider = jsonProvider;
    }

    public ErrorHandlingStrategy getErrorHandlingStrategy() {
        return this.errorHandlingStrategy;
    }

    void setErrorHandlingStrategy(ErrorHandlingStrategy errorHandlingStrategy) {
        this.errorHandlingStrategy = errorHandlingStrategy;
    }

    public boolean withinRange(int currentDepth) {
        return this.minDepth <= currentDepth && currentDepth <= this.maxDepth;
    }

    public Binding[] getDefinitePathBind(int currentDepth) {
        if (this.definitePathLookup != null && this.withinRange(currentDepth)) {
            return this.definitePathLookup[currentDepth - this.minDepth];
        }
        return null;
    }

    static /* synthetic */ IndefinitePathBinding[] access$202(SurfingConfiguration x0, IndefinitePathBinding[] x1) {
        x0.indefinitePathLookup = x1;
        return x1;
    }

    static /* synthetic */ Binding[][] access$302(SurfingConfiguration x0, Binding[][] x1) {
        x0.definitePathLookup = x1;
        return x1;
    }

    public static class Builder {
        private JsonSurfer jsonSurfer;
        private SurfingConfiguration configuration;
        private Map<Integer, ArrayList<Binding>> definiteBindings = new HashMap<Integer, ArrayList<Binding>>();
        private ArrayList<IndefinitePathBinding> indefiniteBindings = new ArrayList();

        public SurfingConfiguration build() {
            if (!this.indefiniteBindings.isEmpty()) {
                Collections.sort(this.indefiniteBindings, INDEFINITE_BINDING_COMPARATOR);
                SurfingConfiguration.access$202(this.configuration, this.indefiniteBindings.toArray(new IndefinitePathBinding[this.indefiniteBindings.size()]));
            }
            if (!this.definiteBindings.isEmpty()) {
                SurfingConfiguration.access$302(this.configuration, new Binding[this.configuration.maxDepth - this.configuration.minDepth + 1][]);
                for (Map.Entry<Integer, ArrayList<Binding>> entry : this.definiteBindings.entrySet()) {
                    ((SurfingConfiguration)this.configuration).definitePathLookup[entry.getKey().intValue() - ((SurfingConfiguration)this.configuration).minDepth] = entry.getValue().toArray(new Binding[entry.getValue().size()]);
                }
            }
            return this.configuration;
        }

        public Builder withSurfer(JsonSurfer jsonSurfer) {
            this.jsonSurfer = jsonSurfer;
            return this;
        }

        public void buildAndSurf(String json) {
            this.jsonSurfer.surf(json, this.build());
        }

        public void buildAndSurf(Reader jsonReader) {
            this.jsonSurfer.surf(jsonReader, this.build());
        }

        public Builder bind(String path, JsonPathListener ... jsonPathListeners) {
            return this.bind(JsonPathCompiler.compile(path), jsonPathListeners);
        }

        public Builder bind(JsonPath.Builder builder, JsonPathListener ... jsonPathListeners) {
            return this.bind(builder.build(), jsonPathListeners);
        }

        public <T> Builder bind(String jsonPath, Class<T> tClass, TypedJsonPathListener<T> ... typedListeners) {
            this.bind(JsonPathCompiler.compile(jsonPath), tClass, typedListeners);
            return this;
        }

        public <T> Builder bind(JsonPath jsonPath, final Class<T> tClass, TypedJsonPathListener<T> ... typedListeners) {
            JsonPathListener[] listeners = new JsonPathListener[typedListeners.length];
            int i = 0;
            for (final TypedJsonPathListener<T> typedListener : typedListeners) {
                listeners[i++] = new JsonPathListener(){

                    @Override
                    public void onValue(Object value, ParsingContext parsingContext) throws Exception {
                        typedListener.onTypedValue(Builder.this.configuration.jsonProvider.cast(value, tClass), parsingContext);
                    }
                };
            }
            this.bind(jsonPath, listeners);
            return this;
        }

        public Builder bind(JsonPath jsonPath, JsonPathListener ... jsonPathListeners) {
            if (!jsonPath.isDefinite()) {
                int minimumDepth = jsonPath.minimumPathDepth();
                this.indefiniteBindings.add(new IndefinitePathBinding(jsonPath, jsonPathListeners, minimumDepth));
            } else {
                ArrayList<Binding> bindings;
                int depth = jsonPath.pathDepth();
                if (depth > this.configuration.maxDepth) {
                    this.configuration.maxDepth = depth;
                }
                if (depth < this.configuration.minDepth) {
                    this.configuration.minDepth = depth;
                }
                if ((bindings = this.definiteBindings.get(depth)) == null) {
                    bindings = new ArrayList();
                    this.definiteBindings.put(depth, bindings);
                }
                bindings.add(new Binding(jsonPath, jsonPathListeners));
            }
            return this;
        }

        public Builder skipOverlappedPath() {
            this.configuration.skipOverlappedPath = true;
            return this;
        }

        public Builder withJsonProvider(JsonProvider provider) {
            this.configuration.jsonProvider = provider;
            return this;
        }

        public Builder withErrorStrategy(ErrorHandlingStrategy errorHandlingStrategy) {
            this.configuration.errorHandlingStrategy = errorHandlingStrategy;
            return this;
        }
    }

    public static class IndefinitePathBinding
    extends Binding {
        int minimumPathDepth;

        public IndefinitePathBinding(JsonPath jsonPath, JsonPathListener[] listeners, int minimumPathDepth) {
            super(jsonPath, listeners);
            this.minimumPathDepth = minimumPathDepth;
        }
    }

    public static class Binding {
        JsonPath jsonPath;
        JsonPathListener[] listeners;

        public Binding(JsonPath jsonPath, JsonPathListener[] listeners) {
            this.jsonPath = jsonPath;
            this.listeners = listeners;
        }
    }
}

