/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import java.io.Reader;
import java.util.Collection;
import org.jsfr.json.CollectAllListener;
import org.jsfr.json.CollectOneListener;
import org.jsfr.json.DefaultErrorHandlingStrategy;
import org.jsfr.json.ErrorHandlingStrategy;
import org.jsfr.json.JsonParserAdapter;
import org.jsfr.json.SurfingConfiguration;
import org.jsfr.json.SurfingContext;
import org.jsfr.json.compiler.JsonPathCompiler;
import org.jsfr.json.path.JsonPath;
import org.jsfr.json.provider.JsonProvider;

public class JsonSurfer {
    private JsonProvider jsonProvider;
    private JsonParserAdapter jsonParserAdapter;
    private ErrorHandlingStrategy errorHandlingStrategy;

    public JsonSurfer(JsonParserAdapter jsonParserAdapter, JsonProvider jsonProvider) {
        this(jsonParserAdapter, jsonProvider, new DefaultErrorHandlingStrategy());
    }

    public JsonSurfer(JsonParserAdapter jsonParserAdapter, JsonProvider jsonProvider, ErrorHandlingStrategy errorHandlingStrategy) {
        this.jsonProvider = jsonProvider;
        this.jsonParserAdapter = jsonParserAdapter;
        this.errorHandlingStrategy = errorHandlingStrategy;
    }

    public SurfingConfiguration.Builder configBuilder() {
        return SurfingConfiguration.builder().withSurfer(this);
    }

    public void surf(String json, SurfingConfiguration configuration) {
        this.ensureSetting(configuration);
        this.jsonParserAdapter.parse(json, new SurfingContext(configuration));
    }

    public void surf(Reader reader, SurfingConfiguration configuration) {
        this.ensureSetting(configuration);
        this.jsonParserAdapter.parse(reader, new SurfingContext(configuration));
    }

    public Collection<Object> collectAll(String json, JsonPath ... paths) {
        return this.collectAll(json, Object.class, paths);
    }

    public Collection<Object> collectAll(Reader reader, JsonPath ... paths) {
        return this.collectAll(reader, Object.class, paths);
    }

    public <T> Collection<T> collectAll(String json, Class<T> tClass, JsonPath ... paths) {
        CollectAllListener<T> listener = new CollectAllListener<T>(this.jsonProvider, tClass);
        SurfingConfiguration.Builder builder = this.configBuilder();
        for (JsonPath jsonPath : paths) {
            builder.bind(jsonPath, listener);
        }
        this.surf(json, builder.build());
        return listener.getCollection();
    }

    public <T> Collection<T> collectAll(Reader reader, Class<T> tClass, JsonPath ... paths) {
        CollectAllListener<T> listener = new CollectAllListener<T>(this.jsonProvider, tClass);
        SurfingConfiguration.Builder builder = this.configBuilder();
        for (JsonPath jsonPath : paths) {
            builder.bind(jsonPath, listener);
        }
        this.surf(reader, builder.build());
        return listener.getCollection();
    }

    public <T> Collection<T> collectAll(String json, Class<T> tClass, String ... paths) {
        return this.collectAll(json, tClass, JsonPathCompiler.compile(paths));
    }

    public <T> Collection<T> collectAll(Reader reader, Class<T> tClass, String ... paths) {
        return this.collectAll(reader, tClass, JsonPathCompiler.compile(paths));
    }

    public Collection<Object> collectAll(String json, String ... paths) {
        return this.collectAll(json, Object.class, paths);
    }

    public Collection<Object> collectAll(Reader reader, String ... paths) {
        return this.collectAll(reader, Object.class, paths);
    }

    public Object collectOne(String json, JsonPath ... paths) {
        return this.collectOne(json, Object.class, paths);
    }

    public Object collectOne(Reader reader, JsonPath ... paths) {
        return this.collectOne(reader, Object.class, paths);
    }

    public <T> T collectOne(String json, Class<T> tClass, JsonPath ... paths) {
        CollectOneListener listener = new CollectOneListener(true);
        SurfingConfiguration.Builder builder = this.configBuilder().skipOverlappedPath();
        for (JsonPath jsonPath : paths) {
            builder.bind(jsonPath, listener);
        }
        this.surf(json, builder.build());
        Object value = listener.getValue();
        return tClass.cast(this.jsonProvider.cast(value, tClass));
    }

    public <T> T collectOne(Reader reader, Class<T> tClass, JsonPath ... paths) {
        CollectOneListener listener = new CollectOneListener(true);
        SurfingConfiguration.Builder builder = this.configBuilder().skipOverlappedPath();
        for (JsonPath jsonPath : paths) {
            builder.bind(jsonPath, listener);
        }
        this.surf(reader, builder.build());
        Object value = listener.getValue();
        return tClass.cast(this.jsonProvider.cast(value, tClass));
    }

    public <T> T collectOne(String json, Class<T> tClass, String ... paths) {
        return this.collectOne(json, tClass, JsonPathCompiler.compile(paths));
    }

    public <T> T collectOne(Reader reader, Class<T> tClass, String ... paths) {
        return this.collectOne(reader, tClass, JsonPathCompiler.compile(paths));
    }

    public Object collectOne(String json, String ... paths) {
        return this.collectOne(json, Object.class, paths);
    }

    public Object collectOne(Reader reader, String ... paths) {
        return this.collectOne(reader, Object.class, paths);
    }

    private void ensureSetting(SurfingConfiguration configuration) {
        if (configuration.getJsonProvider() == null) {
            configuration.setJsonProvider(this.jsonProvider);
        }
        if (configuration.getErrorHandlingStrategy() == null) {
            configuration.setErrorHandlingStrategy(this.errorHandlingStrategy);
        }
    }
}

