/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import java.util.Collections;
import java.util.LinkedList;
import org.jsfr.json.ContentDispatcher;
import org.jsfr.json.JsonCollector;
import org.jsfr.json.JsonPathListener;
import org.jsfr.json.JsonPosition;
import org.jsfr.json.JsonSaxHandler;
import org.jsfr.json.ParsingContext;
import org.jsfr.json.PrimitiveHolder;
import org.jsfr.json.SurfingConfiguration;
import org.jsfr.json.path.ArrayIndex;
import org.jsfr.json.path.PathOperator;

class SurfingContext
implements ParsingContext,
JsonSaxHandler {
    private boolean stopped = false;
    private JsonPosition currentPosition;
    private ContentDispatcher dispatcher = new ContentDispatcher();
    private SurfingConfiguration config;
    private PrimitiveHolder currentValue;
    private String currentKey;

    public SurfingContext(SurfingConfiguration config) {
        this.config = config;
    }

    private void doMatching(PrimitiveHolder primitiveHolder) {
        SurfingConfiguration.Binding[] bindings;
        if (this.config.isSkipOverlappedPath() && !this.dispatcher.isEmpty()) {
            return;
        }
        LinkedList listeners = null;
        int currentDepth = this.currentPosition.pathDepth();
        for (SurfingConfiguration.IndefinitePathBinding binding : this.config.getIndefinitePathLookup()) {
            if (binding.minimumPathDepth > currentDepth) break;
            if (!binding.jsonPath.match(this.currentPosition)) continue;
            if (primitiveHolder != null) {
                this.dispatchPrimitive(binding, primitiveHolder.getValue());
                continue;
            }
            if (listeners == null) {
                listeners = new LinkedList();
            }
            Collections.addAll(listeners, binding.listeners);
        }
        if ((bindings = this.config.getDefinitePathBind(currentDepth)) != null) {
            for (SurfingConfiguration.Binding binding : bindings) {
                if (!binding.jsonPath.match(this.currentPosition)) continue;
                if (primitiveHolder != null) {
                    this.dispatchPrimitive(binding, primitiveHolder.getValue());
                    continue;
                }
                if (listeners == null) {
                    listeners = new LinkedList();
                }
                Collections.addAll(listeners, binding.listeners);
            }
        }
        if (listeners != null) {
            JsonCollector collector = new JsonCollector(listeners, this, this.config.getErrorHandlingStrategy());
            collector.setProvider(this.config.getJsonProvider());
            this.dispatcher.addReceiver(collector);
        }
    }

    private void dispatchPrimitive(SurfingConfiguration.Binding binding, Object primitive) {
        for (JsonPathListener listener : binding.listeners) {
            if (this.isStopped()) break;
            try {
                listener.onValue(primitive, this);
            }
            catch (Exception e) {
                this.config.getErrorHandlingStrategy().handleExceptionFromListener(e, this);
            }
        }
    }

    @Override
    public boolean startJSON() {
        if (this.stopped) {
            return true;
        }
        this.currentPosition = JsonPosition.start();
        this.doMatching(null);
        this.dispatcher.startJSON();
        return true;
    }

    @Override
    public boolean endJSON() {
        if (this.stopped) {
            return true;
        }
        this.dispatcher.endJSON();
        this.currentPosition.clear();
        this.currentPosition = null;
        return true;
    }

    @Override
    public boolean startObject() {
        if (this.stopped) {
            return false;
        }
        PathOperator currentNode = this.currentPosition.peek();
        switch (currentNode.getType()) {
            case OBJECT: {
                this.doMatching(null);
                break;
            }
            case ARRAY: {
                this.accumulateArrayIndex((ArrayIndex)currentNode);
                this.doMatching(null);
                break;
            }
            case ROOT: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.currentPosition.stepIntoObject();
        this.dispatcher.startObject();
        return true;
    }

    @Override
    public boolean endObject() {
        if (this.stopped) {
            return false;
        }
        this.currentKey = null;
        this.currentPosition.stepOutObject();
        this.dispatcher.endObject();
        return true;
    }

    @Override
    public boolean startObjectEntry(String key) {
        if (this.stopped) {
            return false;
        }
        this.currentKey = key;
        this.currentPosition.updateObjectEntry(key);
        this.dispatcher.startObjectEntry(key);
        return true;
    }

    @Override
    public boolean startArray() {
        if (this.stopped) {
            return false;
        }
        PathOperator currentNode = this.currentPosition.peek();
        switch (currentNode.getType()) {
            case OBJECT: {
                this.doMatching(null);
                break;
            }
            case ARRAY: {
                this.accumulateArrayIndex((ArrayIndex)currentNode);
                this.doMatching(null);
                break;
            }
            case ROOT: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.currentPosition.stepIntoArray();
        this.dispatcher.startArray();
        return true;
    }

    private void accumulateArrayIndex(ArrayIndex arrayIndex) {
        arrayIndex.increaseArrayIndex();
    }

    @Override
    public boolean endArray() {
        if (this.stopped) {
            return false;
        }
        this.currentPosition.stepOutArray();
        this.dispatcher.endArray();
        return true;
    }

    @Override
    public boolean primitive(PrimitiveHolder primitiveHolder) {
        if (this.stopped) {
            return false;
        }
        this.currentValue = primitiveHolder;
        PathOperator currentNode = this.currentPosition.peek();
        switch (currentNode.getType()) {
            case OBJECT: {
                this.doMatching(primitiveHolder);
                break;
            }
            case ARRAY: {
                this.accumulateArrayIndex((ArrayIndex)currentNode);
                this.doMatching(primitiveHolder);
                break;
            }
            case ROOT: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.dispatcher.primitive(primitiveHolder);
        return true;
    }

    @Override
    public String getJsonPath() {
        return this.currentPosition.toString();
    }

    @Override
    public String getCurrentFieldName() {
        return this.currentKey;
    }

    @Override
    public PrimitiveHolder getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public int getCurrentArrayIndex() {
        PathOperator top = this.currentPosition.peek();
        if (top.getType() == PathOperator.Type.ARRAY) {
            return ((ArrayIndex)top).getArrayIndex();
        }
        return -1;
    }

    @Override
    public void stopParsing() {
        this.stopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    public SurfingConfiguration getConfig() {
        return this.config;
    }
}

