/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.jsfr.json.provider.JsonProvider;

public class GsonProvider
implements JsonProvider<JsonObject, JsonArray, JsonElement> {
    public static final GsonProvider INSTANCE = new GsonProvider();
    private Gson internalGson;

    public GsonProvider() {
        this(new GsonBuilder().create());
    }

    public GsonProvider(Gson internalGson) {
        this.internalGson = internalGson;
    }

    @Override
    public JsonObject createObject() {
        return new JsonObject();
    }

    @Override
    public JsonArray createArray() {
        return new JsonArray();
    }

    @Override
    public boolean isObject(Object object) {
        return object instanceof JsonObject;
    }

    @Override
    public boolean isArray(Object array) {
        return array instanceof JsonArray;
    }

    @Override
    public void put(JsonObject object, String key, JsonElement value) {
        object.add(key, value);
    }

    @Override
    public void add(JsonArray array, JsonElement value) {
        array.add(value);
    }

    @Override
    public Object resolve(JsonObject object, String key) {
        return object.get(key);
    }

    @Override
    public Object resolve(JsonArray array, int index) {
        return array.get(index);
    }

    @Override
    public JsonElement primitive(boolean value) {
        return new JsonPrimitive(Boolean.valueOf(value));
    }

    @Override
    public JsonElement primitive(int value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    public JsonElement primitive(double value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    public JsonElement primitive(String value) {
        return new JsonPrimitive(value);
    }

    @Override
    public JsonElement primitiveNull() {
        return JsonNull.INSTANCE;
    }

    @Override
    public <T> T cast(JsonElement value, Class<T> tClass) {
        if (this.internalGson.getAdapter(tClass) != null) {
            return (T)this.internalGson.fromJson(value, tClass);
        }
        return tClass.cast(value);
    }
}

