/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import java.util.Collections;
import java.util.LinkedList;
import org.jsfr.json.ContentDispatcher;
import org.jsfr.json.JsonCollector;
import org.jsfr.json.JsonPathListener;
import org.jsfr.json.JsonPosition;
import org.jsfr.json.JsonSaxHandler;
import org.jsfr.json.ParsingContext;
import org.jsfr.json.PrimitiveHolder;
import org.jsfr.json.SurfingConfiguration;
import org.jsfr.json.path.ArrayIndex;
import org.jsfr.json.path.ChildNode;
import org.jsfr.json.path.PathOperator;

class SurfingContext
implements ParsingContext,
JsonSaxHandler {
    private boolean stopped = false;
    private JsonPosition currentPosition;
    private ContentDispatcher dispatcher = new ContentDispatcher();
    private SurfingConfiguration config;
    private PrimitiveHolder currentValue;

    public SurfingContext(SurfingConfiguration config) {
        this.config = config;
    }

    @Override
    public boolean startJSON() {
        if (this.stopped) {
            return true;
        }
        this.currentPosition = JsonPosition.start();
        this.doMatching(this.config, this.currentPosition, this.dispatcher, null);
        this.dispatcher.startJSON();
        return true;
    }

    @Override
    public boolean endJSON() {
        if (this.stopped) {
            return true;
        }
        this.dispatcher.endJSON();
        this.currentPosition.clear();
        this.currentPosition = null;
        return true;
    }

    @Override
    public boolean startObject() {
        if (this.stopped) {
            return false;
        }
        if (this.currentPosition.accumulateArrayIndex()) {
            this.doMatching(this.config, this.currentPosition, this.dispatcher, null);
        }
        this.currentPosition.stepIntoObject();
        this.dispatcher.startObject();
        return true;
    }

    private void doMatching(SurfingConfiguration config, JsonPosition currentPosition, ContentDispatcher dispatcher, PrimitiveHolder primitiveHolder) {
        SurfingConfiguration.Binding[] bindings;
        if (config.isSkipOverlappedPath() && !dispatcher.isEmpty()) {
            return;
        }
        LinkedList listeners = null;
        int currentDepth = currentPosition.pathDepth();
        for (SurfingConfiguration.IndefinitePathBinding binding : config.getIndefinitePathLookup()) {
            if (binding.minimumPathDepth > currentDepth) break;
            if (!binding.jsonPath.match(currentPosition)) continue;
            if (primitiveHolder != null) {
                this.dispatchPrimitive(binding, primitiveHolder.getValue());
                continue;
            }
            if (listeners == null) {
                listeners = new LinkedList();
            }
            Collections.addAll(listeners, binding.listeners);
        }
        if ((bindings = config.getDefinitePathBind(currentDepth)) != null) {
            for (SurfingConfiguration.Binding binding : bindings) {
                if (!binding.jsonPath.match(currentPosition)) continue;
                if (primitiveHolder != null) {
                    this.dispatchPrimitive(binding, primitiveHolder.getValue());
                    continue;
                }
                if (listeners == null) {
                    listeners = new LinkedList();
                }
                Collections.addAll(listeners, binding.listeners);
            }
        }
        if (listeners != null) {
            JsonCollector collector = new JsonCollector(listeners.toArray(new JsonPathListener[listeners.size()]), this, config.getErrorHandlingStrategy());
            collector.setProvider(config.getJsonProvider());
            dispatcher.addReceiver(collector);
        }
    }

    private void dispatchPrimitive(SurfingConfiguration.Binding binding, Object primitive) {
        for (JsonPathListener listener : binding.listeners) {
            if (this.isStopped()) break;
            try {
                listener.onValue(primitive, this);
            }
            catch (Exception e) {
                this.config.getErrorHandlingStrategy().handleExceptionFromListener(e, this);
            }
        }
    }

    @Override
    public boolean endObject() {
        if (this.stopped) {
            return false;
        }
        this.currentPosition.stepOutObject();
        this.dispatcher.endObject();
        return true;
    }

    @Override
    public boolean startObjectEntry(String key) {
        if (this.stopped) {
            return false;
        }
        this.dispatcher.startObjectEntry(key);
        this.currentPosition.updateObjectEntry(key);
        this.doMatching(this.config, this.currentPosition, this.dispatcher, null);
        return true;
    }

    @Override
    public boolean startArray() {
        if (this.stopped) {
            return false;
        }
        if (this.currentPosition.accumulateArrayIndex()) {
            this.doMatching(this.config, this.currentPosition, this.dispatcher, null);
        }
        this.currentPosition.stepIntoArray();
        this.dispatcher.startArray();
        return true;
    }

    @Override
    public boolean endArray() {
        if (this.stopped) {
            return false;
        }
        this.currentPosition.stepOutArray();
        this.dispatcher.endArray();
        return true;
    }

    @Override
    public boolean primitive(PrimitiveHolder primitiveHolder) {
        if (this.stopped) {
            return false;
        }
        this.currentValue = primitiveHolder;
        if (this.currentPosition.accumulateArrayIndex()) {
            this.doMatching(this.config, this.currentPosition, this.dispatcher, primitiveHolder);
        }
        this.dispatcher.primitive(primitiveHolder);
        return true;
    }

    @Override
    public String getJsonPath() {
        return this.currentPosition.toString();
    }

    @Override
    public String getCurrentFieldName() {
        PathOperator top = this.currentPosition.peek();
        if (top.getType() == PathOperator.Type.OBJECT) {
            return ((ChildNode)top).getKey();
        }
        return null;
    }

    @Override
    public PrimitiveHolder getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public int getCurrentArrayIndex() {
        PathOperator top = this.currentPosition.peek();
        if (top.getType() == PathOperator.Type.ARRAY) {
            return ((ArrayIndex)top).getArrayIndex();
        }
        return -1;
    }

    @Override
    public void stopParsing() {
        this.stopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    public SurfingConfiguration getConfig() {
        return this.config;
    }
}

