/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import java.util.Stack;
import org.jsfr.json.JsonSaxHandler;
import org.jsfr.json.PrimitiveHolder;
import org.jsfr.json.provider.JsonProvider;

public class JsonDomBuilder
implements JsonSaxHandler {
    private SCOPE scope = SCOPE.IN_ROOT;
    private JsonProvider provider;
    private Stack<Object> stack = new Stack();
    private Object currentNode;
    private String propertyName;

    public void setProvider(JsonProvider provider) {
        this.provider = provider;
    }

    @Override
    public boolean startJSON() {
        return true;
    }

    @Override
    public boolean endJSON() {
        return true;
    }

    @Override
    public boolean startObject() {
        Object newObject = this.provider.createObject();
        switch (this.scope) {
            case IN_OBJECT: {
                this.provider.put(this.currentNode, this.propertyName, newObject);
                break;
            }
            case IN_ARRAY: {
                this.provider.add(this.currentNode, newObject);
                break;
            }
        }
        this.scope = SCOPE.IN_OBJECT;
        this.stack.push(newObject);
        this.currentNode = newObject;
        this.propertyName = null;
        return true;
    }

    @Override
    public boolean startObjectEntry(String key) {
        switch (this.scope) {
            case IN_OBJECT: {
                this.propertyName = key;
                break;
            }
            case IN_ARRAY: 
            case IN_ROOT: {
                throw new IllegalStateException();
            }
        }
        return true;
    }

    @Override
    public boolean endObject() {
        switch (this.scope) {
            case IN_OBJECT: {
                this.stepOut();
                break;
            }
            case IN_ARRAY: 
            case IN_ROOT: {
                throw new IllegalStateException();
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void stepOut() {
        this.stack.pop();
        if (!this.stack.isEmpty()) {
            this.currentNode = this.stack.peek();
            if (this.provider.isObject(this.currentNode)) {
                this.scope = SCOPE.IN_OBJECT;
                return;
            } else {
                if (!this.provider.isArray(this.currentNode)) throw new IllegalStateException();
                this.scope = SCOPE.IN_ARRAY;
            }
            return;
        } else {
            this.scope = SCOPE.IN_ROOT;
        }
    }

    @Override
    public boolean startArray() {
        Object newArray = this.provider.createArray();
        switch (this.scope) {
            case IN_OBJECT: {
                this.provider.put(this.currentNode, this.propertyName, newArray);
                break;
            }
            case IN_ARRAY: {
                this.provider.add(this.currentNode, newArray);
                break;
            }
        }
        this.scope = SCOPE.IN_ARRAY;
        this.stack.push(newArray);
        this.currentNode = newArray;
        return true;
    }

    @Override
    public boolean endArray() {
        this.stepOut();
        return true;
    }

    private void consumePrimitive(Object value) {
        switch (this.scope) {
            case IN_OBJECT: {
                this.provider.put(this.currentNode, this.propertyName, value);
                break;
            }
            case IN_ARRAY: {
                this.provider.add(this.currentNode, value);
                break;
            }
            case IN_ROOT: {
                this.currentNode = value;
            }
        }
    }

    @Override
    public boolean primitive(PrimitiveHolder primitiveHolder) {
        this.consumePrimitive(primitiveHolder.getValue());
        return true;
    }

    public boolean isInRoot() {
        return this.scope == SCOPE.IN_ROOT;
    }

    public Object getCurrentNode() {
        return this.currentNode;
    }

    public void clear() {
        this.propertyName = null;
        this.provider = null;
        this.stack = null;
        this.currentNode = null;
    }

    private static enum SCOPE {
        IN_OBJECT,
        IN_ARRAY,
        IN_ROOT;

    }
}

