/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.Reader;
import org.jsfr.json.AbstractPrimitiveHolder;
import org.jsfr.json.JsonParserAdapter;
import org.jsfr.json.StaticPrimitiveHolder;
import org.jsfr.json.SurfingContext;
import org.jsfr.json.provider.JsonProvider;

public class JacksonParser
implements JsonParserAdapter {
    public static final JacksonParser INSTANCE = new JacksonParser();

    private JacksonParser() {
    }

    @Override
    public void parse(Reader reader, SurfingContext context) {
        try {
            JsonFactory f = new JsonFactory();
            final JsonParser jp = f.createParser(reader);
            final JsonProvider jsonProvider = context.getConfig().getJsonProvider();
            AbstractPrimitiveHolder stringHolder = new AbstractPrimitiveHolder(context.getConfig()){

                @Override
                public Object doGetValue() throws Exception {
                    return jsonProvider.primitive(jp.getText());
                }

                @Override
                public void doSkipValue() throws Exception {
                }
            };
            AbstractPrimitiveHolder intHolder = new AbstractPrimitiveHolder(context.getConfig()){

                @Override
                public Object doGetValue() throws Exception {
                    return jsonProvider.primitive(jp.getIntValue());
                }

                @Override
                public void doSkipValue() throws Exception {
                }
            };
            AbstractPrimitiveHolder doubleHolder = new AbstractPrimitiveHolder(context.getConfig()){

                @Override
                public Object doGetValue() throws Exception {
                    return jsonProvider.primitive(jp.getDoubleValue());
                }

                @Override
                public void doSkipValue() throws Exception {
                }
            };
            StaticPrimitiveHolder staticPrimitiveHolder = new StaticPrimitiveHolder();
            context.startJSON();
            while (true) {
                JsonToken token;
                if ((token = jp.nextToken()) == null) {
                    context.endJSON();
                    return;
                }
                switch (token) {
                    case NOT_AVAILABLE: {
                        return;
                    }
                    case START_OBJECT: {
                        if (context.startObject()) break;
                        return;
                    }
                    case END_OBJECT: {
                        if (context.endObject()) break;
                        return;
                    }
                    case START_ARRAY: {
                        if (context.startArray()) break;
                        return;
                    }
                    case END_ARRAY: {
                        if (context.endArray()) break;
                        return;
                    }
                    case FIELD_NAME: {
                        if (context.startObjectEntry(jp.getCurrentName())) break;
                        return;
                    }
                    case VALUE_EMBEDDED_OBJECT: {
                        throw new IllegalStateException("Unexpected token");
                    }
                    case VALUE_STRING: {
                        stringHolder.init();
                        if (!context.primitive(stringHolder)) {
                            return;
                        }
                        stringHolder.skipValue();
                        break;
                    }
                    case VALUE_NUMBER_INT: {
                        intHolder.init();
                        if (!context.primitive(intHolder)) {
                            return;
                        }
                        intHolder.skipValue();
                        break;
                    }
                    case VALUE_NUMBER_FLOAT: {
                        doubleHolder.init();
                        if (!context.primitive(doubleHolder)) {
                            return;
                        }
                        doubleHolder.skipValue();
                        break;
                    }
                    case VALUE_TRUE: {
                        if (context.primitive(staticPrimitiveHolder.withValue(jsonProvider.primitive(true)))) break;
                        return;
                    }
                    case VALUE_FALSE: {
                        if (context.primitive(staticPrimitiveHolder.withValue(jsonProvider.primitive(false)))) break;
                        return;
                    }
                    case VALUE_NULL: {
                        if (context.primitive(staticPrimitiveHolder.withValue(jsonProvider.primitiveNull()))) break;
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
            return;
        }
    }
}

