/*
 * Decompiled with CFR 0.152.
 */
package com.vansuita.pickimage.dialog;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v7.widget.CardView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.vansuita.pickimage.R;
import com.vansuita.pickimage.async.AsyncImageResult;
import com.vansuita.pickimage.bean.PickResult;
import com.vansuita.pickimage.bundle.PickSetup;
import com.vansuita.pickimage.enums.EPickType;
import com.vansuita.pickimage.listeners.IPickCancel;
import com.vansuita.pickimage.listeners.IPickClick;
import com.vansuita.pickimage.listeners.IPickResult;
import com.vansuita.pickimage.resolver.IntentResolver;
import com.vansuita.pickimage.util.Util;

public abstract class PickImageBaseDialog
extends DialogFragment
implements IPickClick {
    protected static final String SETUP_TAG = "SETUP_TAG";
    protected static final String RESOLVER_STATE_TAG = "resolverState";
    public static final String DIALOG_FRAGMENT_TAG = PickImageBaseDialog.class.getSimpleName();
    private PickSetup setup;
    private IntentResolver resolver;
    private boolean showCamera = true;
    private boolean showGallery = true;
    private CardView card;
    private LinearLayout llButtons;
    private TextView tvTitle;
    private TextView tvCamera;
    private TextView tvGallery;
    private TextView tvCancel;
    private TextView tvProgress;
    private View vFirstLayer;
    private View vSecondLayer;
    private Boolean validProviders = null;
    private IPickResult onPickResult;
    private IPickClick onClick;
    private IPickCancel onPickCancel;
    private View.OnClickListener listener = new View.OnClickListener(){

        public void onClick(View view) {
            if (view.getId() == R.id.cancel) {
                if (PickImageBaseDialog.this.onPickCancel != null) {
                    PickImageBaseDialog.this.onPickCancel.onCancelClick();
                }
                PickImageBaseDialog.this.dismiss();
            } else if (view.getId() == R.id.camera) {
                PickImageBaseDialog.this.onClick.onCameraClick();
            } else if (view.getId() == R.id.gallery) {
                PickImageBaseDialog.this.onClick.onGalleryClick();
            }
        }
    };

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.dialog, null, false);
        this.onAttaching();
        this.onInitialize(savedInstanceState);
        if (this.isValidProviders()) {
            this.onBindViewsHolders(view);
            if (!this.launchSystemDialog()) {
                this.onBindViews(view);
                this.onBindViewListeners();
                this.onSetup();
            }
        } else {
            return this.delayedDismiss();
        }
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        Bundle resolverState = new Bundle();
        this.resolver.onSaveInstanceState(resolverState);
        outState.putBundle(RESOLVER_STATE_TAG, resolverState);
    }

    private void onAttaching() {
        if (this.onClick == null) {
            this.onClick = this.getActivity() instanceof IPickClick ? (IPickClick)this.getActivity() : this;
        }
        if (this.onPickResult == null && this.getActivity() instanceof IPickResult) {
            this.onPickResult = (IPickResult)this.getActivity();
        }
        if (this.onPickCancel == null && this.getActivity() instanceof IPickCancel) {
            this.onPickCancel = (IPickCancel)this.getActivity();
        }
    }

    protected void onInitialize(Bundle savedInstanceState) {
        if (this.getDialog().getWindow() != null) {
            this.getDialog().getWindow().requestFeature(1);
            this.getDialog().getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
        this.setup = (PickSetup)this.getArguments().getSerializable(SETUP_TAG);
        Bundle resolverState = null;
        if (savedInstanceState != null) {
            resolverState = savedInstanceState.getBundle(RESOLVER_STATE_TAG);
        }
        this.resolver = new IntentResolver((Activity)this.getActivity(), this.setup, resolverState);
    }

    private boolean isValidProviders() {
        if (this.validProviders == null) {
            this.validProviders = true;
            this.showCamera = EPickType.CAMERA.inside(this.setup.getPickTypes()) && (this.onClick == null || this.resolver.isCamerasAvailable() && !this.resolver.wasCameraPermissionDeniedForever());
            this.showGallery = EPickType.GALLERY.inside(this.setup.getPickTypes());
            if (!this.showCamera && !this.showGallery) {
                Error e = new Error(this.getString(R.string.no_providers));
                this.validProviders = false;
                if (this.onPickResult != null) {
                    this.onError(e);
                } else {
                    throw e;
                }
            }
        }
        return this.validProviders;
    }

    private void onBindViewsHolders(View v) {
        this.card = (CardView)v.findViewById(R.id.card);
        this.vFirstLayer = v.findViewById(R.id.first_layer);
        this.vSecondLayer = v.findViewById(R.id.second_layer);
    }

    private void onBindViews(View v) {
        this.llButtons = (LinearLayout)v.findViewById(R.id.buttons_holder);
        this.tvTitle = (TextView)v.findViewById(R.id.title);
        this.tvCamera = (TextView)v.findViewById(R.id.camera);
        this.tvGallery = (TextView)v.findViewById(R.id.gallery);
        this.tvCancel = (TextView)v.findViewById(R.id.cancel);
        this.tvProgress = (TextView)v.findViewById(R.id.loading_text);
    }

    private void onBindViewListeners() {
        this.tvCancel.setOnClickListener(this.listener);
        this.tvCamera.setOnClickListener(this.listener);
        this.tvGallery.setOnClickListener(this.listener);
    }

    private void onSetup() {
        if (this.setup.getBackgroundColor() != 17170443) {
            this.card.setCardBackgroundColor(this.setup.getBackgroundColor());
            if (this.showCamera) {
                Util.background((View)this.tvCamera, Util.getAdaptiveRippleDrawable(this.setup.getBackgroundColor()));
            }
            if (this.showGallery) {
                Util.background((View)this.tvGallery, Util.getAdaptiveRippleDrawable(this.setup.getBackgroundColor()));
            }
        }
        this.tvTitle.setTextColor(this.setup.getTitleColor());
        if (this.setup.getButtonTextColor() != 0) {
            this.tvCamera.setTextColor(this.setup.getButtonTextColor());
            this.tvGallery.setTextColor(this.setup.getButtonTextColor());
        }
        if (this.setup.getProgressTextColor() != 0) {
            this.tvProgress.setTextColor(this.setup.getProgressTextColor());
        }
        if (this.setup.getCancelTextColor() != 0) {
            this.tvCancel.setTextColor(this.setup.getCancelTextColor());
        }
        if (this.setup.getCameraButtonText() != null) {
            this.tvCamera.setText((CharSequence)this.setup.getCameraButtonText());
        }
        if (this.setup.getGalleryButtonText() != null) {
            this.tvGallery.setText((CharSequence)this.setup.getGalleryButtonText());
        }
        this.tvCancel.setText((CharSequence)this.setup.getCancelText());
        this.tvTitle.setText((CharSequence)this.setup.getTitle());
        this.tvProgress.setText((CharSequence)this.setup.getProgressText());
        this.showProgress(false);
        Util.gone((View)this.tvCamera, !this.showCamera);
        Util.gone((View)this.tvGallery, !this.showGallery);
        this.llButtons.setOrientation(this.setup.getButtonOrientation() == 0 ? 0 : 1);
        Util.setIcon(this.tvCamera, this.setup.getCameraIcon(), this.setup.getIconGravity());
        Util.setIcon(this.tvGallery, this.setup.getGalleryIcon(), this.setup.getIconGravity());
        Util.setDimAmount(this.setup.getDimAmount(), this.getDialog());
    }

    protected void showProgress(boolean show) {
        Util.gone((View)this.card, false);
        Util.gone(this.vFirstLayer, show);
        Util.gone(this.vSecondLayer, !show);
    }

    protected void launchCamera() {
        if (this.resolver.requestCameraPermissions((Fragment)this)) {
            this.resolver.launchCamera((Fragment)this);
        }
    }

    protected void launchGallery() {
        if (this.resolver.requestGalleryPermissions((Fragment)this)) {
            this.resolver.launchGallery((Fragment)this);
        }
    }

    protected boolean launchSystemDialog() {
        if (this.setup.isSystemDialog()) {
            this.card.setVisibility(8);
            if (this.showCamera) {
                if (this.resolver.requestCameraPermissions((Fragment)this)) {
                    this.resolver.launchSystemChooser((Fragment)this);
                }
            } else {
                this.resolver.launchSystemChooser((Fragment)this);
            }
            return true;
        }
        return false;
    }

    protected PickImageBaseDialog setOnPickResult(IPickResult onPickResult) {
        this.onPickResult = onPickResult;
        return this;
    }

    protected PickImageBaseDialog setOnClick(IPickClick onClick) {
        this.onClick = onClick;
        return this;
    }

    protected PickImageBaseDialog setOnPickCancel(IPickCancel onPickCancel) {
        this.onPickCancel = onPickCancel;
        return this;
    }

    protected AsyncImageResult getAsyncResult() {
        return new AsyncImageResult(this.resolver, this.setup).setOnFinish(new AsyncImageResult.OnFinish(){

            @Override
            public void onFinish(PickResult pickResult) {
                if (PickImageBaseDialog.this.onPickResult != null) {
                    PickImageBaseDialog.this.onPickResult.onPickResult(pickResult);
                }
                PickImageBaseDialog.this.dismissAllowingStateLoss();
            }
        });
    }

    public Context getContext() {
        Context context = super.getContext();
        if (context == null && this.resolver != null) {
            context = this.resolver.getActivity();
        }
        return context;
    }

    private View delayedDismiss() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                PickImageBaseDialog.this.dismiss();
            }
        }, 20L);
        return new View(this.getContext());
    }

    protected void onError(Error e) {
        if (this.onPickResult != null) {
            this.onPickResult.onPickResult(new PickResult().setError(e));
            this.dismissAllowingStateLoss();
        }
    }
}

