/*
 * Decompiled with CFR 0.152.
 */
package com.vansuita.pickimage;

import android.annotation.TargetApi;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.res.ColorStateList;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.support.v4.app.DialogFragment;
import android.support.v4.content.FileProvider;
import android.util.StateSet;
import android.view.View;
import android.view.WindowManager;
import android.widget.TextView;
import com.vansuita.pickimage.bean.PickResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

public class Util {
    @TargetApi(value=16)
    public static void background(View v, Drawable d) {
        int sdk = Build.VERSION.SDK_INT;
        if (sdk < 16) {
            v.setBackgroundDrawable(d);
        } else {
            v.setBackground(d);
        }
    }

    @TargetApi(value=16)
    public static void background(View v, Bitmap b) {
        Util.background(v, (Drawable)new BitmapDrawable(v.getResources(), b));
    }

    public static void launchGalery(DialogFragment frag, int code) {
        Intent intent = new Intent("android.intent.action.PICK");
        intent.setType("image/*");
        frag.startActivityForResult(intent, code);
    }

    public static void launchCamera(DialogFragment frag, String authority, int code) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (intent.resolveActivity(frag.getActivity().getPackageManager()) != null) {
            Uri uri = FileProvider.getUriForFile((Context)frag.getContext(), (String)authority, (File)Util.tempFile());
            List resInfoList = frag.getActivity().getPackageManager().queryIntentActivities(intent, 65536);
            for (ResolveInfo resolveInfo : resInfoList) {
                String packageName = resolveInfo.activityInfo.packageName;
                frag.getActivity().grantUriPermission(packageName, uri, 3);
            }
            intent.putExtra("output", (Parcelable)uri);
            frag.startActivityForResult(intent, code);
        }
    }

    public static File tempFile() {
        File dir = new File(Environment.getExternalStorageDirectory(), PickResult.class.getSimpleName());
        dir.mkdirs();
        return new File(dir, "temp.jpg");
    }

    public static Uri tempUri() {
        return Uri.fromFile((File)Util.tempFile());
    }

    public static Bitmap flip(Bitmap bitmap) {
        Matrix m = new Matrix();
        m.preScale(-1.0f, 1.0f);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)false);
    }

    public static Bitmap decodeUri(Uri selectedImage, Context context, int requiredSize) throws FileNotFoundException {
        BitmapFactory.Options o = new BitmapFactory.Options();
        o.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)context.getContentResolver().openInputStream(selectedImage), null, (BitmapFactory.Options)o);
        int width_tmp = o.outWidth;
        int height_tmp = o.outHeight;
        int scale = 1;
        while (width_tmp / 2 >= requiredSize && height_tmp / 2 >= requiredSize) {
            width_tmp /= 2;
            height_tmp /= 2;
            scale *= 2;
        }
        BitmapFactory.Options o2 = new BitmapFactory.Options();
        o2.inSampleSize = scale;
        return BitmapFactory.decodeStream((InputStream)context.getContentResolver().openInputStream(selectedImage), null, (BitmapFactory.Options)o2);
    }

    public static void setDimAmount(float dim, Dialog dialog) {
        if (Build.VERSION.SDK_INT >= 14) {
            dialog.getWindow().setDimAmount(dim);
        } else {
            WindowManager.LayoutParams lp = dialog.getWindow().getAttributes();
            lp.dimAmount = dim;
            dialog.getWindow().setAttributes(lp);
        }
    }

    public static void gone(View v, boolean gone) {
        if (gone) {
            v.setVisibility(8);
        } else {
            v.setVisibility(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRealPathFromURI(Context context, Uri contentUri) {
        try (Cursor cursor = null;){
            String[] proj = new String[]{"_data"};
            cursor = context.getContentResolver().query(contentUri, proj, null, null, null);
            int column_index = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            String string = cursor.getString(column_index);
            return string;
        }
    }

    public static void setIcon(TextView tv, int icon, int gravity) {
        int left;
        int right = 0;
        int bottom = 0;
        int top = 0;
        if (gravity > 0) {
            left = gravity == 3 ? icon : 0;
            right = gravity == 5 ? icon : 0;
            bottom = gravity == 80 ? icon : 0;
            top = gravity == 48 ? icon : 0;
        } else {
            left = icon;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            tv.setCompoundDrawablesRelativeWithIntrinsicBounds(left, top, right, bottom);
        } else {
            tv.setCompoundDrawablesWithIntrinsicBounds(left, top, right, bottom);
        }
        if (bottom + top != 0) {
            tv.setGravity(17);
        }
    }

    public static Drawable getAdaptiveRippleDrawable(int normalColor) {
        if (Build.VERSION.SDK_INT >= 21) {
            return new RippleDrawable(ColorStateList.valueOf((int)Util.darker(normalColor)), Util.getRippleMask(normalColor), null);
        }
        return Util.getStateListDrawable(normalColor, Util.darker(normalColor));
    }

    private static Drawable getRippleMask(int color) {
        float[] outerRadii = new float[8];
        Arrays.fill(outerRadii, 3.0f);
        RoundRectShape r = new RoundRectShape(outerRadii, null, null);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)r);
        shapeDrawable.getPaint().setColor(color);
        return shapeDrawable;
    }

    private static StateListDrawable getStateListDrawable(int normalColor, int pressedColor) {
        StateListDrawable states = new StateListDrawable();
        states.addState(new int[]{16842919}, (Drawable)new ColorDrawable(pressedColor));
        states.addState(new int[]{16842908}, (Drawable)new ColorDrawable(pressedColor));
        states.addState(new int[]{16843518}, (Drawable)new ColorDrawable(pressedColor));
        states.addState(new int[0], (Drawable)new ColorDrawable(normalColor));
        states.addState(StateSet.WILD_CARD, (Drawable)new ColorDrawable(normalColor));
        return states;
    }

    public static int darker(int color) {
        int r = Color.red((int)color);
        int b = Color.blue((int)color);
        int g = Color.green((int)color);
        return Color.rgb((int)((int)((double)r * 0.9)), (int)((int)((double)g * 0.9)), (int)((int)((double)b * 0.9)));
    }
}

