/*
 * Decompiled with CFR 0.152.
 */
package com.vansuita.pickimage;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v7.widget.CardView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.vansuita.pickimage.EPickTypes;
import com.vansuita.pickimage.PickSetup;
import com.vansuita.pickimage.R;
import com.vansuita.pickimage.Util;
import com.vansuita.pickimage.bean.PickResult;
import com.vansuita.pickimage.listeners.IPickClick;
import com.vansuita.pickimage.listeners.IPickResult;
import java.io.Serializable;

public class PickImageDialog
extends DialogFragment {
    private static final String SETUP_TAG = "SETUP_TAG";
    private static final int FROM_CAMERA = 1;
    private static final int FROM_GALLERY = 2;
    private CardView cvRoot;
    private TextView tvTitle;
    private TextView tvCamera;
    private TextView tvGallery;
    private TextView tvCancel;
    private TextView tvProgress;
    private View vFirstLayer;
    private View vSecondLayer;
    private IPickResult onPickResult;
    private IPickClick onClick;
    private PickSetup setup;
    private View.OnClickListener listener = new View.OnClickListener(){

        public void onClick(View view) {
            if (view.getId() == R.id.cancel) {
                PickImageDialog.this.dismiss();
            } else if (view.getId() == R.id.camera) {
                if (PickImageDialog.this.onClick != null) {
                    PickImageDialog.this.onClick.onCameraClick();
                } else {
                    Util.launchCamera(PickImageDialog.this, 1);
                }
            } else if (view.getId() == R.id.gallery) {
                if (PickImageDialog.this.onClick != null) {
                    PickImageDialog.this.onClick.onGalleryClick();
                } else {
                    Util.launchGalery(PickImageDialog.this, 2);
                }
            }
        }
    };

    public static PickImageDialog newInstance(PickSetup setup) {
        PickImageDialog frag = new PickImageDialog();
        Bundle args = new Bundle();
        args.putSerializable(SETUP_TAG, (Serializable)setup);
        frag.setArguments(args);
        return frag;
    }

    public static PickImageDialog on(FragmentManager fm, PickSetup setup, IPickResult pickResult) {
        PickImageDialog d = PickImageDialog.newInstance(setup == null ? new PickSetup() : setup);
        d.setOnPickResult(pickResult);
        d.show(fm, "dialog");
        return d;
    }

    public static PickImageDialog on(FragmentManager fm, IPickResult pickResult) {
        return PickImageDialog.on(fm, null, pickResult);
    }

    public static PickImageDialog on(FragmentManager fm, PickSetup setup) {
        return PickImageDialog.on(fm, setup, null);
    }

    public static PickImageDialog on(FragmentActivity activity, PickSetup setup) {
        return PickImageDialog.on(activity.getSupportFragmentManager(), setup);
    }

    public static PickImageDialog on(FragmentActivity activity) {
        return PickImageDialog.on(activity, null);
    }

    public static PickImageDialog on(FragmentManager fm) {
        return PickImageDialog.on(fm, new PickSetup());
    }

    public PickImageDialog setOnPickResult(IPickResult onPickResult) {
        this.onPickResult = onPickResult;
        return this;
    }

    public PickImageDialog setOnClick(IPickClick onClick) {
        this.onClick = onClick;
        return this;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.cvRoot = (CardView)inflater.inflate(R.layout.dialog, null, false);
        this.bindView();
        this.setUp();
        this.bindListeners();
        this.requestPermissions();
        return this.cvRoot;
    }

    private void setUp() {
        this.getDialog().getWindow().requestFeature(1);
        this.getDialog().getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.setup = (PickSetup)this.getArguments().getSerializable(SETUP_TAG);
        this.cvRoot.setCardBackgroundColor(this.setup.getBackgroundColor());
        this.tvTitle.setTextColor(this.setup.getTitleColor());
        if (this.setup.getOptionsColor() > 0) {
            this.tvCamera.setTextColor(this.setup.getOptionsColor());
            this.tvGallery.setTextColor(this.setup.getOptionsColor());
        }
        if (this.setup.getProgressTextColor() > 0) {
            this.tvProgress.setTextColor(this.setup.getProgressTextColor());
        }
        this.tvCancel.setText((CharSequence)this.setup.getCancelText());
        this.tvTitle.setText((CharSequence)this.setup.getTitle());
        this.tvProgress.setText((CharSequence)this.setup.getProgressText());
        this.visibleProgress(false);
        Util.gone((View)this.tvCamera, !EPickTypes.CAMERA.inside(this.setup.getPickTypes()));
        Util.gone((View)this.tvGallery, !EPickTypes.GALERY.inside(this.setup.getPickTypes()));
        Util.setDimAmount(this.setup.getDimAmount(), this.getDialog());
        this.onAttaching((Context)this.getActivity());
    }

    public void onAttaching(Context context) {
        if (this.onClick == null && context instanceof IPickClick) {
            this.onClick = (IPickClick)context;
        }
        if (this.onPickResult == null && context instanceof IPickResult) {
            this.onPickResult = (IPickResult)context;
        }
    }

    private void bindView() {
        this.tvTitle = (TextView)this.cvRoot.findViewById(R.id.title);
        this.tvCamera = (TextView)this.cvRoot.findViewById(R.id.camera);
        this.tvGallery = (TextView)this.cvRoot.findViewById(R.id.gallery);
        this.tvCancel = (TextView)this.cvRoot.findViewById(R.id.cancel);
        this.tvProgress = (TextView)this.cvRoot.findViewById(R.id.loading_text);
        this.vFirstLayer = this.cvRoot.findViewById(R.id.first_layer);
        this.vSecondLayer = this.cvRoot.findViewById(R.id.second_layer);
    }

    private void bindListeners() {
        this.tvCancel.setOnClickListener(this.listener);
        this.tvCamera.setOnClickListener(this.listener);
        this.tvGallery.setOnClickListener(this.listener);
    }

    private void visibleProgress(boolean show) {
        Util.gone(this.vFirstLayer, show);
        Util.gone(this.vSecondLayer, !show);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            this.visibleProgress(true);
            new AsyncResult(requestCode).execute(new Intent[]{data});
        } else {
            this.dismiss();
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] == 0) continue;
            this.dismissAllowingStateLoss();
            break;
        }
    }

    public boolean requestPermissions() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.getActivity().checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0 && this.getActivity().checkSelfPermission("android.permission.CAMERA") == 0) {
                return true;
            }
            this.requestPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA"}, 1);
            return false;
        }
        return true;
    }

    private class AsyncResult
    extends AsyncTask<Intent, Void, PickResult> {
        private int requestCode;

        public AsyncResult(int requestCode) {
            this.requestCode = requestCode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected PickResult doInBackground(Intent ... intents) {
            PickResult result = new PickResult();
            try {
                Intent data = intents[0];
                Bitmap bitmap = null;
                if (this.requestCode == 1) {
                    bitmap = Util.decodeUri(Util.tempUri(), PickImageDialog.this.getContext(), PickImageDialog.this.setup.getImageSize());
                    if (PickImageDialog.this.setup.isFlipped()) {
                        bitmap = Util.flip(bitmap);
                    }
                } else if (this.requestCode == 2) {
                    bitmap = Util.decodeUri(data.getData(), PickImageDialog.this.getContext(), PickImageDialog.this.setup.getImageSize());
                }
                result.setBitmap(bitmap);
                Uri uri = null;
                if (this.requestCode == 1) {
                    uri = Util.tempUri();
                } else if (this.requestCode == 2) {
                    uri = data.getData();
                }
                result.setUri(uri);
            }
            catch (Exception e) {
                result.setError(e);
            }
            finally {
                return result;
            }
        }

        protected void onPostExecute(PickResult r) {
            if (PickImageDialog.this.onPickResult != null) {
                PickImageDialog.this.onPickResult.onPickResult(r);
            }
            PickImageDialog.this.dismiss();
        }
    }
}

