/*
 * Decompiled with CFR 0.152.
 */
package com.rilixtech;

import android.content.Context;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.rilixtech.Country;
import com.rilixtech.CountryCodePicker;
import com.rilixtech.CountryUtils;
import com.rilixtech.R;
import java.util.List;

public class CountryCodeArrayAdapter
extends ArrayAdapter<Country> {
    private final CountryCodePicker mCountryCodePicker;

    CountryCodeArrayAdapter(Context ctx, List<Country> countries, CountryCodePicker picker) {
        super(ctx, 0, countries);
        this.mCountryCodePicker = picker;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        Country country = (Country)this.getItem(position);
        if (convertView == null) {
            viewHolder = new ViewHolder();
            LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
            convertView = inflater.inflate(R.layout.item_country, parent, false);
            viewHolder.rlyMain = (RelativeLayout)convertView.findViewById(R.id.item_country_rly);
            viewHolder.tvName = (TextView)convertView.findViewById(R.id.country_name_tv);
            viewHolder.tvCode = (TextView)convertView.findViewById(R.id.code_tv);
            viewHolder.imvFlag = (ImageView)convertView.findViewById(R.id.flag_imv);
            viewHolder.llyFlagHolder = (LinearLayout)convertView.findViewById(R.id.flag_holder_lly);
            viewHolder.viewDivider = convertView.findViewById(R.id.preference_divider_view);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        this.setData(country, viewHolder);
        return convertView;
    }

    private void setData(Country country, ViewHolder viewHolder) {
        if (country == null) {
            viewHolder.viewDivider.setVisibility(0);
            viewHolder.tvName.setVisibility(8);
            viewHolder.tvCode.setVisibility(8);
            viewHolder.llyFlagHolder.setVisibility(8);
        } else {
            viewHolder.viewDivider.setVisibility(8);
            viewHolder.tvName.setVisibility(0);
            viewHolder.tvCode.setVisibility(0);
            viewHolder.llyFlagHolder.setVisibility(0);
            Context ctx = viewHolder.tvName.getContext();
            String name = country.getName();
            String iso = country.getIso().toUpperCase();
            String countryNameAndCode = ctx.getString(R.string.country_name_and_code, new Object[]{name, iso});
            viewHolder.tvName.setText((CharSequence)countryNameAndCode);
            if (this.mCountryCodePicker.isHidePhoneCode()) {
                viewHolder.tvCode.setVisibility(8);
            } else {
                viewHolder.tvCode.setText((CharSequence)ctx.getString(R.string.phone_code, new Object[]{country.getPhoneCode()}));
            }
            Typeface typeface = this.mCountryCodePicker.getTypeFace();
            if (typeface != null) {
                viewHolder.tvCode.setTypeface(typeface);
                viewHolder.tvName.setTypeface(typeface);
            }
            viewHolder.imvFlag.setImageResource(CountryUtils.getFlagDrawableResId(country));
            int color2 = this.mCountryCodePicker.getDialogTextColor();
            if (color2 != this.mCountryCodePicker.getDefaultContentColor()) {
                viewHolder.tvCode.setTextColor(color2);
                viewHolder.tvName.setTextColor(color2);
            }
        }
    }

    private static class ViewHolder {
        RelativeLayout rlyMain;
        TextView tvName;
        TextView tvCode;
        ImageView imvFlag;
        LinearLayout llyFlagHolder;
        View viewDivider;

        private ViewHolder() {
        }
    }
}

