/*
 * Decompiled with CFR 0.152.
 */
package com.rilixtech;

import android.app.Dialog;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.v7.widget.AppCompatEditText;
import android.support.v7.widget.AppCompatTextView;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.rilixtech.Country;
import com.rilixtech.CountryCodeAdapter;
import com.rilixtech.CountryCodePicker;
import com.rilixtech.R;
import java.util.List;

class CountryCodeDialog
extends Dialog {
    private AppCompatEditText mEdtSearch;
    private AppCompatTextView mTvNoResult;
    private AppCompatTextView mTvTitle;
    private RecyclerView mRvCountryDialog;
    private CountryCodePicker mCountryCodePicker;
    private RelativeLayout mRlyDialog;

    public CountryCodeDialog(CountryCodePicker countryCodePicker) {
        super(countryCodePicker.getContext());
        this.mCountryCodePicker = countryCodePicker;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.layout_picker_dialog);
        this.setupUI();
        this.setupData();
    }

    private void setupUI() {
        this.mRlyDialog = (RelativeLayout)this.findViewById(R.id.dialog_rly);
        this.mRvCountryDialog = (RecyclerView)this.findViewById(R.id.country_dialog_rv);
        this.mTvTitle = (AppCompatTextView)this.findViewById(R.id.title_tv);
        this.mEdtSearch = (AppCompatEditText)this.findViewById(R.id.search_edt);
        this.mTvNoResult = (AppCompatTextView)this.findViewById(R.id.no_result_tv);
    }

    private void setupData() {
        if (this.mCountryCodePicker.getTypeFace() != null) {
            Typeface typeface = this.mCountryCodePicker.getTypeFace();
            this.mTvTitle.setTypeface(typeface);
            this.mEdtSearch.setTypeface(typeface);
            this.mTvNoResult.setTypeface(typeface);
        }
        if (this.mCountryCodePicker.getBackgroundColor() != this.mCountryCodePicker.getDefaultBackgroundColor()) {
            this.mRlyDialog.setBackgroundColor(this.mCountryCodePicker.getBackgroundColor());
        }
        if (this.mCountryCodePicker.getTextColor() != this.mCountryCodePicker.getDefaultContentColor()) {
            int color2 = this.mCountryCodePicker.getTextColor();
            this.mTvTitle.setTextColor(color2);
            this.mTvNoResult.setTextColor(color2);
            this.mEdtSearch.setTextColor(color2);
            this.mEdtSearch.setHintTextColor(this.adjustAlpha(color2, 0.7f));
        }
        this.mCountryCodePicker.refreshCustomMasterList();
        this.mCountryCodePicker.refreshPreferredCountries();
        List<Country> masterCountries = this.mCountryCodePicker.getCustomCountries(this.mCountryCodePicker);
        CountryCodeAdapter cca = new CountryCodeAdapter(masterCountries, this.mCountryCodePicker, this.mEdtSearch, this.mTvNoResult, this);
        if (!this.mCountryCodePicker.isSelectionDialogShowSearch()) {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mRvCountryDialog.getLayoutParams();
            params.height = -2;
            this.mRvCountryDialog.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.mRvCountryDialog.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mRvCountryDialog.setAdapter((RecyclerView.Adapter)cca);
    }

    void reShow() {
        this.setupData();
        this.show();
    }

    private int adjustAlpha(int color2, float factor) {
        int alpha = Math.round((float)Color.alpha((int)color2) * factor);
        int red = Color.red((int)color2);
        int green = Color.green((int)color2);
        int blue = Color.blue((int)color2);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }
}

