/*
 * Decompiled with CFR 0.152.
 */
package com.rilixtech;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.v7.widget.AppCompatEditText;
import android.support.v7.widget.AppCompatTextView;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.rilixtech.Country;
import com.rilixtech.CountryCodeAdapter;
import com.rilixtech.CountryCodePicker;
import com.rilixtech.R;
import java.util.List;

public class CountryCodeDialog
extends Dialog {
    private AppCompatEditText mEdtSearch;
    private AppCompatTextView mTvNoResult;
    private AppCompatTextView mTvTitle;
    private RecyclerView mRvCountryDialog;
    private CountryCodePicker mCountryCodePicker;

    public CountryCodeDialog(CountryCodePicker countryCodePicker) {
        super(countryCodePicker.getContext());
        this.mCountryCodePicker = countryCodePicker;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.layout_picker_dialog);
        this.setupUI();
        this.setupData();
    }

    private void setupUI() {
        this.mRvCountryDialog = (RecyclerView)this.findViewById(R.id.country_dialog_rv);
        this.mTvTitle = (AppCompatTextView)this.findViewById(R.id.title_tv);
        this.mTvTitle.setText(R.string.select_country);
        this.mEdtSearch = (AppCompatEditText)this.findViewById(R.id.search_edt);
        this.mEdtSearch.setHint(R.string.search_hint);
        this.mTvNoResult = (AppCompatTextView)this.findViewById(R.id.no_result_tv);
        this.mTvNoResult.setText(R.string.no_result_found);
    }

    private void setupData() {
        this.mCountryCodePicker.refreshCustomMasterList();
        this.mCountryCodePicker.refreshPreferredCountries();
        List<Country> masterCountries = Country.getCustomMasterCountryList(this.mCountryCodePicker);
        CountryCodeAdapter cca = new CountryCodeAdapter(masterCountries, this.mCountryCodePicker, this.mEdtSearch, this.mTvNoResult, this);
        if (!this.mCountryCodePicker.isSelectionDialogShowSearch()) {
            Toast.makeText((Context)this.getContext(), (CharSequence)"Found not to show search", (int)0).show();
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mRvCountryDialog.getLayoutParams();
            params.height = -2;
            this.mRvCountryDialog.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.mRvCountryDialog.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mRvCountryDialog.setAdapter((RecyclerView.Adapter)cca);
    }

    public void reShow() {
        this.setupData();
        this.show();
    }
}

