/*
 * Decompiled with CFR 0.152.
 */
package com.github.joelittlejohn.embedmongo;

import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class ImportDataConfig {
    private String database;
    private String collection;
    private String file;
    private Boolean dropOnImport = true;
    private Boolean upsertOnImport = true;
    private long timeout = 200000L;

    public ImportDataConfig() {
    }

    public ImportDataConfig(String database, String collection, String file, Boolean dropOnImport, Boolean upsertOnImport, long timeout) {
        this.database = database;
        this.collection = collection;
        this.file = file;
        this.dropOnImport = dropOnImport;
        this.upsertOnImport = upsertOnImport;
        this.timeout = timeout;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollection() {
        if (StringUtils.isBlank((CharSequence)this.collection)) {
            return StringUtils.substringBeforeLast((String)StringUtils.substringAfterLast((String)this.file, (String)File.separator), (String)".");
        }
        return this.collection;
    }

    public String getFile() {
        return this.file;
    }

    public Boolean getDropOnImport() {
        return this.dropOnImport;
    }

    public Boolean getUpsertOnImport() {
        return this.upsertOnImport;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String toString() {
        return "ImportDataConfig{database='" + this.database + '\'' + ", collection='" + this.collection + '\'' + ", file='" + this.file + '\'' + ", dropOnImport=" + this.dropOnImport + ", upsertOnImport=" + this.upsertOnImport + ", timeout=" + this.timeout + '}';
    }
}

