/*
 * Decompiled with CFR 0.152.
 */
package com.whiteelephant.monthpicker;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.example.prem.firstpitch.R;
import com.whiteelephant.monthpicker.MonthPickerDialog;
import com.whiteelephant.monthpicker.MonthViewAdapter;
import com.whiteelephant.monthpicker.YearPickerView;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;

class MonthPickerView
extends FrameLayout {
    YearPickerView _yearView;
    ListView _monthList;
    static int _minYear = 1900;
    static int _maxYear = Calendar.getInstance().get(1);
    MonthViewAdapter _monthViewAdapter;
    TextView _month;
    TextView _year;
    TextView _title;
    Context _context;
    int _headerFontColorSelected;
    int _headerFontColorNormal;
    boolean _showMonthOnly;
    int _selectedMonth;
    int _selectedYear;
    MonthPickerDialog.OnYearChangedListener _onYearChanged;
    MonthPickerDialog.OnMonthChangedListener _onMonthChanged;
    OnDateSet _onDateSet;
    OnCancel _onCancel;
    private String[] _monthNames;
    MonthPickerDialog.OnConfigChangeListener configChangeListener;

    public MonthPickerView(Context context) {
        this(context, null);
        this._context = context;
    }

    public MonthPickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this._context = context;
    }

    public MonthPickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedValue outValue;
        this._context = context;
        LayoutInflater mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        mInflater.inflate(R.layout.month_picker_view, (ViewGroup)this);
        this._monthNames = new DateFormatSymbols(Locale.getDefault()).getShortMonths();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.monthPickerDialog, defStyleAttr, 0);
        int headerBgColor = a.getColor(R.styleable.monthPickerDialog_headerBgColor, 0);
        this._headerFontColorNormal = a.getColor(R.styleable.monthPickerDialog_headerFontColorNormal, 0);
        this._headerFontColorSelected = a.getColor(R.styleable.monthPickerDialog_headerFontColorSelected, 0);
        int monthBgColor = a.getColor(R.styleable.monthPickerDialog_monthBgColor, 0);
        int monthBgSelectedColor = a.getColor(R.styleable.monthPickerDialog_monthBgSelectedColor, 0);
        int monthFontColorNormal = a.getColor(R.styleable.monthPickerDialog_monthFontColorNormal, 0);
        int monthFontColorSelected = a.getColor(R.styleable.monthPickerDialog_monthFontColorSelected, 0);
        int monthFontColorDisabled = a.getColor(R.styleable.monthPickerDialog_monthFontColorDisabled, 0);
        int headerTitleColor = a.getColor(R.styleable.monthPickerDialog_headerTitleColor, 0);
        int actionButtonColor = a.getColor(R.styleable.monthPickerDialog_dialogActionButtonColor, 0);
        if (monthFontColorNormal == 0) {
            monthFontColorNormal = this.getResources().getColor(R.color.fontBlackEnable);
        }
        if (monthFontColorSelected == 0) {
            monthFontColorSelected = this.getResources().getColor(R.color.fontWhiteEnable);
        }
        if (monthFontColorDisabled == 0) {
            monthFontColorDisabled = this.getResources().getColor(R.color.fontBlackDisable);
        }
        if (this._headerFontColorNormal == 0) {
            this._headerFontColorNormal = this.getResources().getColor(R.color.fontWhiteDisable);
        }
        if (this._headerFontColorSelected == 0) {
            this._headerFontColorSelected = this.getResources().getColor(R.color.fontWhiteEnable);
        }
        if (headerTitleColor == 0) {
            headerTitleColor = this.getResources().getColor(R.color.fontWhiteEnable);
        }
        if (monthBgColor == 0) {
            monthBgColor = this.getResources().getColor(R.color.fontWhiteEnable);
        }
        if (headerBgColor == 0) {
            headerBgColor = Build.VERSION.SDK_INT >= 21 ? 16843829 : context.getResources().getIdentifier("colorAccent", "attr", context.getPackageName());
            outValue = new TypedValue();
            context.getTheme().resolveAttribute(headerBgColor, outValue, true);
            headerBgColor = outValue.data;
        }
        if (monthBgSelectedColor == 0) {
            monthBgSelectedColor = Build.VERSION.SDK_INT >= 21 ? 16843829 : context.getResources().getIdentifier("colorAccent", "attr", context.getPackageName());
            outValue = new TypedValue();
            context.getTheme().resolveAttribute(monthBgSelectedColor, outValue, true);
            monthBgSelectedColor = outValue.data;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (monthBgColor != 0) {
            map.put("monthBgColor", monthBgColor);
        }
        if (monthBgSelectedColor != 0) {
            map.put("monthBgSelectedColor", monthBgSelectedColor);
        }
        if (monthFontColorNormal != 0) {
            map.put("monthFontColorNormal", monthFontColorNormal);
        }
        if (monthFontColorSelected != 0) {
            map.put("monthFontColorSelected", monthFontColorSelected);
        }
        if (monthFontColorDisabled != 0) {
            map.put("monthFontColorDisabled", monthFontColorDisabled);
        }
        a.recycle();
        this._monthList = (ListView)this.findViewById(R.id.listview);
        this._yearView = (YearPickerView)this.findViewById(R.id.yearView);
        this._month = (TextView)this.findViewById(R.id.month);
        this._year = (TextView)this.findViewById(R.id.year);
        this._title = (TextView)this.findViewById(R.id.title);
        RelativeLayout _pickerBg = (RelativeLayout)this.findViewById(R.id.picker_view);
        LinearLayout _header = (LinearLayout)this.findViewById(R.id.header);
        RelativeLayout _actionBtnLay = (RelativeLayout)this.findViewById(R.id.action_btn_lay);
        TextView ok = (TextView)this.findViewById(R.id.ok_action);
        TextView cancel = (TextView)this.findViewById(R.id.cancel_action);
        if (actionButtonColor != 0) {
            ok.setTextColor(actionButtonColor);
            cancel.setTextColor(actionButtonColor);
        } else {
            ok.setTextColor(headerBgColor);
            cancel.setTextColor(headerBgColor);
        }
        if (this._headerFontColorSelected != 0) {
            this._month.setTextColor(this._headerFontColorSelected);
        }
        if (this._headerFontColorNormal != 0) {
            this._year.setTextColor(this._headerFontColorNormal);
        }
        if (headerTitleColor != 0) {
            this._title.setTextColor(headerTitleColor);
        }
        if (headerBgColor != 0) {
            _header.setBackgroundColor(headerBgColor);
        }
        if (monthBgColor != 0) {
            _pickerBg.setBackgroundColor(monthBgColor);
        }
        if (monthBgColor != 0) {
            _actionBtnLay.setBackgroundColor(monthBgColor);
        }
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MonthPickerView.this._onDateSet.onDateSet();
            }
        });
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MonthPickerView.this._onCancel.onCancel();
            }
        });
        this._monthViewAdapter = new MonthViewAdapter(context);
        this._monthViewAdapter.setColors(map);
        this._monthViewAdapter.setOnDaySelectedListener(new MonthViewAdapter.OnDaySelectedListener(){

            @Override
            public void onDaySelected(MonthViewAdapter view, int selectedMonth) {
                Log.d((String)"----------------", (String)("MonthPickerDialogStyle selected month = " + selectedMonth));
                MonthPickerView.this._selectedMonth = selectedMonth;
                MonthPickerView.this._month.setText((CharSequence)MonthPickerView.this._monthNames[selectedMonth]);
                if (!MonthPickerView.this._showMonthOnly) {
                    MonthPickerView.this._monthList.setVisibility(8);
                    MonthPickerView.this._yearView.setVisibility(0);
                    MonthPickerView.this._month.setTextColor(MonthPickerView.this._headerFontColorNormal);
                    MonthPickerView.this._year.setTextColor(MonthPickerView.this._headerFontColorSelected);
                }
                if (MonthPickerView.this._onMonthChanged != null) {
                    MonthPickerView.this._onMonthChanged.onMonthChanged(selectedMonth);
                }
            }
        });
        this._monthList.setAdapter((ListAdapter)this._monthViewAdapter);
        this._yearView.setRange(_minYear, _maxYear);
        this._yearView.setColors(map);
        this._yearView.setYear(Calendar.getInstance().get(1));
        this._yearView.setOnYearSelectedListener(new YearPickerView.OnYearSelectedListener(){

            @Override
            public void onYearChanged(YearPickerView view, int selectedYear) {
                Log.d((String)"----------------", (String)("selected year = " + selectedYear));
                MonthPickerView.this._selectedYear = selectedYear;
                MonthPickerView.this._year.setText((CharSequence)("" + selectedYear));
                MonthPickerView.this._year.setTextColor(MonthPickerView.this._headerFontColorSelected);
                MonthPickerView.this._month.setTextColor(MonthPickerView.this._headerFontColorNormal);
                if (MonthPickerView.this._onYearChanged != null) {
                    MonthPickerView.this._onYearChanged.onYearChanged(selectedYear);
                }
            }
        });
        this._month.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (MonthPickerView.this._monthList.getVisibility() == 8) {
                    MonthPickerView.this._yearView.setVisibility(8);
                    MonthPickerView.this._monthList.setVisibility(0);
                    MonthPickerView.this._year.setTextColor(MonthPickerView.this._headerFontColorNormal);
                    MonthPickerView.this._month.setTextColor(MonthPickerView.this._headerFontColorSelected);
                }
            }
        });
        this._year.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (MonthPickerView.this._yearView.getVisibility() == 8) {
                    MonthPickerView.this._monthList.setVisibility(8);
                    MonthPickerView.this._yearView.setVisibility(0);
                    MonthPickerView.this._year.setTextColor(MonthPickerView.this._headerFontColorSelected);
                    MonthPickerView.this._month.setTextColor(MonthPickerView.this._headerFontColorNormal);
                }
            }
        });
    }

    protected void init(int year, int month) {
        this._selectedYear = year;
        this._selectedMonth = month;
    }

    protected void setMaxMonth(int maxMonth) {
        if (maxMonth > 11 || maxMonth < 0) {
            throw new IllegalArgumentException("Month out of range please send months between Calendar.JANUARY, Calendar.DECEMBER");
        }
        this._monthViewAdapter.setMaxMonth(maxMonth);
    }

    protected void setMinMonth(int minMonth) {
        if (minMonth < 0 || minMonth > 11) {
            throw new IllegalArgumentException("Month out of range please send months between Calendar.JANUARY, Calendar.DECEMBER");
        }
        this._monthViewAdapter.setMinMonth(minMonth);
    }

    protected void setMinYear(int minYear) {
        this._yearView.setMinYear(minYear);
    }

    protected void setMaxYear(int maxYear) {
        this._yearView.setMaxYear(maxYear);
    }

    protected void showMonthOnly() {
        this._showMonthOnly = true;
        this._year.setVisibility(8);
    }

    protected void showYearOnly() {
        this._monthList.setVisibility(8);
        this._yearView.setVisibility(0);
        this._month.setVisibility(8);
        this._year.setTextColor(this._headerFontColorSelected);
    }

    protected void setActivatedMonth(int activatedMonth) {
        if (activatedMonth < 0 || activatedMonth > 11) {
            throw new IllegalArgumentException("Month out of range please send months between Calendar.JANUARY, Calendar.DECEMBER");
        }
        this._monthViewAdapter.setActivatedMonth(activatedMonth);
        this._month.setText((CharSequence)this._monthNames[activatedMonth]);
    }

    protected void setActivatedYear(int activatedYear) {
        this._yearView.setActivatedYear(activatedYear);
        this._year.setText((CharSequence)Integer.toString(activatedYear));
    }

    protected void setMonthRange(int minMonth, int maxMonth) {
        if (minMonth >= maxMonth) {
            throw new IllegalArgumentException("maximum month is less then minimum month");
        }
        this.setMinMonth(minMonth);
        this.setMaxYear(maxMonth);
    }

    protected void setYearRange(int minYear, int maxYear) {
        if (minYear >= maxYear) {
            throw new IllegalArgumentException("maximum year is less then minimum year");
        }
        this.setMinYear(minYear);
        this.setMaxYear(maxYear);
    }

    protected void setMonthYearRange(int minMonth, int maxMonth, int minYear, int maxYear) {
        this.setMonthRange(minMonth, maxMonth);
        this.setYearRange(minYear, maxYear);
    }

    protected void setTitle(String dialogTitle) {
        if (dialogTitle != null && dialogTitle.trim().length() > 0) {
            this._title.setText((CharSequence)dialogTitle);
            this._title.setVisibility(0);
        } else {
            this._title.setVisibility(8);
        }
    }

    protected int getMonth() {
        return this._selectedMonth;
    }

    protected int getYear() {
        return this._selectedYear;
    }

    protected void setOnMonthChangedListener(MonthPickerDialog.OnMonthChangedListener onMonthChangedListener) {
        if (onMonthChangedListener != null) {
            this._onMonthChanged = onMonthChangedListener;
        }
    }

    protected void setOnYearChangedListener(MonthPickerDialog.OnYearChangedListener onYearChangedListener) {
        if (onYearChangedListener != null) {
            this._onYearChanged = onYearChangedListener;
        }
    }

    public void setOnDateListener(OnDateSet onDateSet) {
        this._onDateSet = onDateSet;
    }

    public void setOnCancelListener(OnCancel onCancel) {
        this._onCancel = onCancel;
    }

    protected void setOnConfigurationChanged(MonthPickerDialog.OnConfigChangeListener configChangeListener) {
        this.configChangeListener = configChangeListener;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        this.configChangeListener.onConfigChange();
        super.onConfigurationChanged(newConfig);
    }

    public static interface OnCancel {
        public void onCancel();
    }

    public static interface OnDateSet {
        public void onDateSet();
    }
}

