/*
 * Decompiled with CFR 0.152.
 */
package com.whiteelephant.monthpicker;

import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.IntRange;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.DatePicker;
import com.example.prem.firstpitch.R;
import com.whiteelephant.monthpicker.MonthPickerView;

public class MonthPickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
DatePicker.OnDateChangedListener {
    private final MonthPickerView _monthPicker;
    private final OnDateSetListener _callBack;
    private View view;

    private MonthPickerDialog(Context context, OnDateSetListener callBack, int year, int monthOfYear) {
        this(context, 0, callBack, year, monthOfYear);
    }

    public void show() {
        if (this.view != null) {
            if (this.getContext().getResources().getConfiguration().orientation == 2) {
                WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
                if (this.getWindow() != null) {
                    lp.copyFrom(this.getWindow().getAttributes());
                    lp.width = (int)((double)this.getContext().getResources().getDisplayMetrics().widthPixels * 0.94);
                    lp.height = (int)((double)this.getContext().getResources().getDisplayMetrics().heightPixels * 0.94);
                    super.show();
                    this.getWindow().setLayout(lp.width, lp.height);
                }
                return;
            }
            this.dismiss();
        }
        super.show();
    }

    private MonthPickerDialog(Context context, int theme, OnDateSetListener callBack, int year, int monthOfYear) {
        super(context, theme);
        this._callBack = callBack;
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.view = inflater.inflate(R.layout.month_picker_dialog, null);
        this.setView(this.view);
        this._monthPicker = (MonthPickerView)this.view.findViewById(R.id.monthPicker);
        this._monthPicker.setOnDateListener(new MonthPickerView.OnDateSet(){

            @Override
            public void onDateSet() {
                MonthPickerDialog.this.tryNotifyDateSet();
                MonthPickerDialog.this.dismiss();
            }
        });
        this._monthPicker.setOnCancelListener(new MonthPickerView.OnCancel(){

            @Override
            public void onCancel() {
                MonthPickerDialog.this.dismiss();
            }
        });
        this._monthPicker.setOnConfigurationChanged(new OnConfigChangeListener(){

            @Override
            public void onConfigChange() {
                MonthPickerDialog.this.dismiss();
            }
        });
        this._monthPicker.init(year, monthOfYear);
    }

    public void onClick(DialogInterface dialog, int which) {
        this.tryNotifyDateSet();
    }

    public void onDateChanged(DatePicker view, int year, int month, int day) {
        this._monthPicker.init(year, month);
    }

    public MonthPickerView getDatePicker() {
        return this._monthPicker;
    }

    void tryNotifyDateSet() {
        if (this._callBack != null) {
            this._monthPicker.clearFocus();
            this._callBack.onDateSet(this._monthPicker.getMonth(), this._monthPicker.getYear());
        }
    }

    protected void onStop() {
        super.onStop();
    }

    private void setMinMonth(int minMonth) {
        this._monthPicker.setMinMonth(minMonth);
    }

    private void setMaxMonth(int maxMonth) {
        this._monthPicker.setMaxMonth(maxMonth);
    }

    private void setMinYear(int minYear) {
        this._monthPicker.setMinYear(minYear);
    }

    private void setMaxYear(int maxYear) {
        this._monthPicker.setMaxYear(maxYear);
    }

    private void setActivatedMonth(int activatedMonth) {
        this._monthPicker.setActivatedMonth(activatedMonth);
    }

    private void setActivatedYear(int activatedMonth) {
        this._monthPicker.setActivatedYear(activatedMonth);
    }

    private void setMonthPickerTitle(String title) {
        this._monthPicker.setTitle(title);
    }

    private void showMonthOnly() {
        this._monthPicker.showMonthOnly();
    }

    private void showYearOnly() {
        this._monthPicker.showYearOnly();
    }

    private void setOnMonthChangedListener(OnMonthChangedListener onMonthChangedListener) {
        if (onMonthChangedListener != null) {
            this._monthPicker.setOnMonthChangedListener(onMonthChangedListener);
        }
    }

    private void setOnYearChangedListener(OnYearChangedListener onYearChangedListener) {
        if (onYearChangedListener != null) {
            this._monthPicker.setOnYearChangedListener(onYearChangedListener);
        }
    }

    public static interface OnConfigChangeListener {
        public void onConfigChange();
    }

    public static interface OnYearChangedListener {
        public void onYearChanged(int var1);
    }

    public static interface OnMonthChangedListener {
        public void onMonthChanged(int var1);
    }

    public static interface OnDateSetListener {
        public void onDateSet(int var1, int var2);
    }

    public static class Builder {
        private static final String TAG = Builder.class.getName();
        private Context _context;
        private OnDateSetListener _callBack;
        private int _activatedMonth;
        private int _activatedYear;
        private int _minMonth = 0;
        private int _maxMonth = 11;
        private int _minYear;
        private int _maxYear;
        private boolean monthOnly;
        private boolean yearOnly;
        private String title = null;
        private MonthPickerDialog monthPickerDialog;
        private OnYearChangedListener _onYearChanged;
        private OnMonthChangedListener _onMonthChanged;

        public Builder(Context context, OnDateSetListener callBack, int year, @IntRange(from=0L, to=11L) int month) {
            if (month < 0 || month > 11) {
                throw new IllegalArgumentException("Month range should be between 0 (Calender.JANUARY) to 11 (Calendar.DECEMBER)");
            }
            this._activatedMonth = month;
            if (year < 1) {
                throw new IllegalArgumentException("Selected year should be > 1");
            }
            this._activatedYear = year;
            this._context = context;
            this._callBack = callBack;
            if (year > MonthPickerView._minYear) {
                this._minYear = MonthPickerView._minYear;
            } else {
                this._minYear = year;
                MonthPickerView._minYear = year;
            }
            if (year > MonthPickerView._maxYear) {
                this._maxYear = year;
                MonthPickerView._maxYear = year;
            } else {
                this._maxYear = MonthPickerView._maxYear;
            }
        }

        public Builder setMinMonth(@IntRange(from=0L, to=11L) int minMonth) {
            if (minMonth >= 0 && minMonth <= 11) {
                this._minMonth = minMonth;
                return this;
            }
            throw new IllegalArgumentException("Month range should be between 0 (Calender.JANUARY) to 11 (Calendar.DECEMBER)");
        }

        public Builder setMaxMonth(@IntRange(from=0L, to=11L) int maxMonth) {
            this._maxMonth = maxMonth;
            return this;
        }

        public Builder setMinYear(int minYear) {
            this._minYear = minYear;
            return this;
        }

        public Builder setMaxYear(int maxYear) {
            this._maxYear = maxYear;
            return this;
        }

        public Builder setActivatedMonth(@IntRange(from=0L, to=11L) int activatedMonth) {
            this._activatedMonth = activatedMonth;
            return this;
        }

        public Builder setActivatedYear(int activatedYear) {
            this._activatedYear = activatedYear;
            return this;
        }

        public Builder setMonthRange(@IntRange(from=0L, to=11L) int minMonth, @IntRange(from=0L, to=11L) int maxMonth) {
            if (minMonth >= 0 && minMonth <= 11 && maxMonth >= 0 && maxMonth <= 11) {
                this._minMonth = minMonth;
                this._maxMonth = maxMonth;
                return this;
            }
            throw new IllegalArgumentException("Month range should be between 0 (Calender.JANUARY) to 11 (Calendar.DECEMBER)");
        }

        public Builder setYearRange(int minYear, int maxYear) {
            if (minYear <= maxYear) {
                this._minYear = minYear;
                this._maxYear = maxYear;
                return this;
            }
            throw new IllegalArgumentException("Minimum year should be less then Maximum year");
        }

        public Builder setMonthAndYearRange(@IntRange(from=0L, to=11L) int minMonth, @IntRange(from=0L, to=11L) int maxMonth, int minYear, int maxYear) {
            if (minMonth < 0 || minMonth > 11 || maxMonth < 0 || maxMonth > 11) {
                throw new IllegalArgumentException("Month range should be between 0 (Calender.JANUARY) to 11 (Calendar.DECEMBER)");
            }
            this._minMonth = minMonth;
            this._maxMonth = maxMonth;
            if (minYear > maxYear) {
                throw new IllegalArgumentException("Minimum year should be less then Maximum year");
            }
            this._minYear = minYear;
            this._maxYear = maxYear;
            return this;
        }

        public Builder showMonthOnly() {
            if (this.yearOnly) {
                Log.e((String)TAG, (String)"yearOnly also set to true before. Now setting yearOnly to false monthOnly to true");
            }
            this.yearOnly = false;
            this.monthOnly = true;
            return this;
        }

        public Builder showYearOnly() {
            if (this.monthOnly) {
                Log.e((String)TAG, (String)"monthOnly also set to true before. Now setting monthOnly to false and yearOnly to true");
            }
            this.monthOnly = false;
            this.yearOnly = true;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setOnMonthChangedListener(OnMonthChangedListener onMonthChangedListener) {
            this._onMonthChanged = onMonthChangedListener;
            return this;
        }

        public Builder setOnYearChangedListener(OnYearChangedListener onYearChangedListener) {
            this._onYearChanged = onYearChangedListener;
            return this;
        }

        public MonthPickerDialog build() {
            if (this._minMonth > this._maxMonth) {
                throw new IllegalArgumentException("Minimum month should always smaller then maximum month.");
            }
            if (this._minYear > this._maxYear) {
                throw new IllegalArgumentException("Minimum year should always smaller then maximum year.");
            }
            if (this._activatedMonth < this._minMonth || this._activatedMonth > this._maxMonth) {
                throw new IllegalArgumentException("Activated month should always in between Minimum and maximum month.");
            }
            if (this._activatedYear < this._minYear || this._activatedYear > this._maxYear) {
                throw new IllegalArgumentException("Activated year should always in between Minimum year and maximum year.");
            }
            this.monthPickerDialog = new MonthPickerDialog(this._context, this._callBack, this._activatedYear, this._activatedMonth);
            if (this.monthOnly) {
                this.monthPickerDialog.showMonthOnly();
                this._minYear = 0;
                this._maxYear = 0;
                this._activatedYear = 0;
            } else if (this.yearOnly) {
                this.monthPickerDialog.showYearOnly();
                this._minMonth = 0;
                this._maxMonth = 0;
                this._activatedMonth = 0;
            }
            this.monthPickerDialog.setMinMonth(this._minMonth);
            this.monthPickerDialog.setMaxMonth(this._maxMonth);
            this.monthPickerDialog.setMinYear(this._minYear);
            this.monthPickerDialog.setMaxYear(this._maxYear);
            this.monthPickerDialog.setActivatedMonth(this._activatedMonth);
            this.monthPickerDialog.setActivatedYear(this._activatedYear);
            if (this._onMonthChanged != null) {
                this.monthPickerDialog.setOnMonthChangedListener(this._onMonthChanged);
            }
            if (this._onYearChanged != null) {
                this.monthPickerDialog.setOnYearChangedListener(this._onYearChanged);
            }
            if (this.title != null) {
                this.monthPickerDialog.setMonthPickerTitle(this.title.trim());
            }
            return this.monthPickerDialog;
        }
    }
}

