/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import java.io.FileDescriptor;
import jnr.constants.platform.Errno;
import jnr.ffi.Pointer;
import jnr.ffi.mapper.FromNativeContext;
import jnr.posix.BaseHeapFileStat;
import jnr.posix.BaseNativePOSIX;
import jnr.posix.FileStat;
import jnr.posix.LibCProvider;
import jnr.posix.POSIXHandler;
import jnr.posix.Solaris64FileStat;
import jnr.posix.SolarisHeapFileStat;
import jnr.posix.SolarisPasswd;
import jnr.posix.util.Platform;

final class SolarisPOSIX
extends BaseNativePOSIX {
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new SolarisPasswd((Pointer)arg) : null;
        }
    };

    SolarisPOSIX(String libraryName, LibCProvider libc, POSIXHandler handler) {
        super(libraryName, libc, handler);
    }

    public BaseHeapFileStat allocateStat() {
        return Platform.IS_32_BIT ? new SolarisHeapFileStat(this) : new Solaris64FileStat(this);
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        BaseHeapFileStat stat = this.allocateStat();
        int fd = this.helper.getfd(fileDescriptor);
        if ((Platform.IS_64_BIT ? this.libc().fstat(fd, stat) : this.libc().fstat64(fd, stat)) < 0) {
            this.handler.error(Errno.ENOENT, "" + fd);
        }
        return stat;
    }

    public int lchmod(String filename, int mode) {
        this.handler.unimplementedError("lchmod");
        return -1;
    }

    public FileStat lstat(String path) {
        BaseHeapFileStat stat = this.allocateStat();
        if ((Platform.IS_64_BIT ? this.libc().lstat(path, stat) : this.libc().lstat64(path, stat)) < 0) {
            this.handler.error(Errno.ENOENT, path);
        }
        return stat;
    }

    public FileStat stat(String path) {
        BaseHeapFileStat stat = this.allocateStat();
        if ((Platform.IS_64_BIT ? this.libc().stat(path, stat) : this.libc().stat64(path, stat)) < 0) {
            this.handler.error(Errno.ENOENT, path);
        }
        return stat;
    }
}

