/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import jnr.constants.platform.Errno;
import jnr.ffi.LastError;
import jnr.ffi.Memory;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.ffi.byref.IntByReference;
import jnr.ffi.mapper.FromNativeContext;
import jnr.ffi.mapper.FromNativeConverter;
import jnr.ffi.mapper.ToNativeContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.posix.BaseHeapFileStat;
import jnr.posix.DefaultNativeGroup;
import jnr.posix.DefaultNativeTimeval;
import jnr.posix.FileStat;
import jnr.posix.Group;
import jnr.posix.JavaLibCHelper;
import jnr.posix.LibC;
import jnr.posix.LibCProvider;
import jnr.posix.NativePOSIX;
import jnr.posix.POSIX;
import jnr.posix.POSIXHandler;
import jnr.posix.Passwd;
import jnr.posix.Timeval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseNativePOSIX
extends NativePOSIX
implements POSIX {
    private final LibC libc;
    protected final String libraryName;
    protected final POSIXHandler handler;
    protected final JavaLibCHelper helper;
    public static final PointerConverter GROUP = new PointerConverter(){

        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new DefaultNativeGroup((Pointer)arg) : null;
        }
    };
    public static final ToNativeConverter<FileStat, Struct> FileStatConverter = new ToNativeConverter<FileStat, Struct>(){

        public Struct toNative(FileStat value, ToNativeContext context) {
            if (!(value instanceof Struct)) {
                throw new IllegalArgumentException("FileStat instance is not a struct");
            }
            return (Struct)value;
        }

        public Class<Struct> nativeType() {
            return Struct.class;
        }
    };

    BaseNativePOSIX(String libraryName, LibCProvider libcProvider, POSIXHandler handler) {
        this.handler = handler;
        this.libraryName = libraryName;
        this.libc = libcProvider.getLibC();
        this.helper = new JavaLibCHelper(handler);
    }

    @Override
    public final LibC libc() {
        return this.libc;
    }

    @Override
    public int chmod(String filename, int mode) {
        return this.libc().chmod(filename, mode);
    }

    @Override
    public int chown(String filename, int user, int group) {
        return this.libc().chown(filename, user, group);
    }

    @Override
    public int exec(String path, String ... args) {
        this.handler.unimplementedError("exec unimplemented");
        return -1;
    }

    @Override
    public int exec(String path, String[] args, String[] envp) {
        this.handler.unimplementedError("exec unimplemented");
        return -1;
    }

    @Override
    public int execv(String path, String[] args) {
        return this.libc().execv(path, args);
    }

    @Override
    public int execve(String path, String[] args, String[] env) {
        return this.libc().execve(path, args, env);
    }

    @Override
    public FileStat fstat(FileDescriptor fileDescriptor) {
        BaseHeapFileStat stat = this.allocateStat();
        int fd = this.helper.getfd(fileDescriptor);
        if (this.libc().fstat(fd, stat) < 0) {
            this.handler.error(Errno.ENOENT, "" + fd);
        }
        return stat;
    }

    @Override
    public String getenv(String envName) {
        return this.libc().getenv(envName);
    }

    @Override
    public int getegid() {
        return this.libc().getegid();
    }

    @Override
    public int geteuid() {
        return this.libc().geteuid();
    }

    @Override
    public int getgid() {
        return this.libc().getgid();
    }

    @Override
    public String getlogin() {
        return this.libc().getlogin();
    }

    @Override
    public int getpgid() {
        return this.libc().getpgid();
    }

    @Override
    public int getpgrp() {
        return this.libc().getpgrp();
    }

    @Override
    public int getpid() {
        return this.libc().getpid();
    }

    @Override
    public int getppid() {
        return this.libc().getppid();
    }

    @Override
    public Passwd getpwent() {
        return this.libc().getpwent();
    }

    @Override
    public Passwd getpwuid(int which) {
        return this.libc().getpwuid(which);
    }

    @Override
    public Passwd getpwnam(String which) {
        return this.libc().getpwnam(which);
    }

    @Override
    public Group getgrent() {
        return this.libc().getgrent();
    }

    @Override
    public Group getgrgid(int which) {
        return this.libc().getgrgid(which);
    }

    @Override
    public Group getgrnam(String which) {
        return this.libc().getgrnam(which);
    }

    @Override
    public int setpwent() {
        return this.libc().setpwent();
    }

    @Override
    public int endpwent() {
        return this.libc().endpwent();
    }

    @Override
    public int setgrent() {
        return this.libc().setgrent();
    }

    @Override
    public int endgrent() {
        return this.libc().endgrent();
    }

    @Override
    public int getuid() {
        return this.libc().getuid();
    }

    @Override
    public int setegid(int egid) {
        return this.libc().setegid(egid);
    }

    @Override
    public int seteuid(int euid) {
        return this.libc().seteuid(euid);
    }

    @Override
    public int setgid(int gid) {
        return this.libc().setgid(gid);
    }

    public int getfd(FileDescriptor descriptor) {
        return this.helper.getfd(descriptor);
    }

    @Override
    public int getpgid(int pid) {
        return this.libc().getpgid(pid);
    }

    @Override
    public int setpgid(int pid, int pgid) {
        return this.libc().setpgid(pid, pgid);
    }

    @Override
    public int setpgrp(int pid, int pgrp) {
        return this.libc().setpgrp(pid, pgrp);
    }

    @Override
    public int setsid() {
        return this.libc().setsid();
    }

    @Override
    public int setuid(int uid) {
        return this.libc().setuid(uid);
    }

    @Override
    public int kill(int pid, int signal) {
        return this.libc().kill(pid, signal);
    }

    @Override
    public int lchmod(String filename, int mode) {
        return this.libc().lchmod(filename, mode);
    }

    @Override
    public int lchown(String filename, int user, int group) {
        return this.libc().lchown(filename, user, group);
    }

    @Override
    public int link(String oldpath, String newpath) {
        return this.libc().link(oldpath, newpath);
    }

    @Override
    public FileStat lstat(String path) {
        BaseHeapFileStat stat = this.allocateStat();
        if (this.libc().lstat(path, stat) < 0) {
            this.handler.error(Errno.ENOENT, path);
        }
        return stat;
    }

    @Override
    public int mkdir(String path, int mode) {
        int res = this.libc().mkdir(path, mode);
        if (res < 0) {
            int errno = this.errno();
            this.handler.error(Errno.valueOf((long)errno), path);
        }
        return res;
    }

    @Override
    public int setenv(String envName, String envValue, int overwrite) {
        return this.libc().setenv(envName, envValue, overwrite);
    }

    @Override
    public FileStat stat(String path) {
        BaseHeapFileStat stat = this.allocateStat();
        if (this.libc().stat(path, stat) < 0) {
            this.handler.error(Errno.ENOENT, path);
        }
        return stat;
    }

    @Override
    public int symlink(String oldpath, String newpath) {
        return this.libc().symlink(oldpath, newpath);
    }

    @Override
    public String readlink(String oldpath) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        int result = this.libc().readlink(oldpath, buffer, buffer.capacity());
        if (result == -1) {
            return null;
        }
        buffer.position(0);
        buffer.limit(result);
        return Charset.forName("ASCII").decode(buffer).toString();
    }

    @Override
    public int unsetenv(String envName) {
        return this.libc().unsetenv(envName);
    }

    @Override
    public int umask(int mask) {
        return this.libc().umask(mask);
    }

    @Override
    public int utimes(String path, long[] atimeval, long[] mtimeval) {
        Timeval[] times = null;
        if (atimeval != null && mtimeval != null) {
            times = (Timeval[])Struct.arrayOf((Runtime)this.getRuntime(), DefaultNativeTimeval.class, (int)2);
            times[0].setTime(atimeval);
            times[1].setTime(mtimeval);
        }
        return this.libc().utimes(path, times);
    }

    @Override
    public int fork() {
        return this.libc().fork();
    }

    @Override
    public int waitpid(int pid, int[] status, int flags) {
        return this.libc().waitpid(pid, status, flags);
    }

    @Override
    public int wait(int[] status) {
        return this.libc().wait(status);
    }

    @Override
    public int getpriority(int which, int who) {
        return this.libc().getpriority(which, who);
    }

    @Override
    public int setpriority(int which, int who, int prio) {
        return this.libc().setpriority(which, who, prio);
    }

    @Override
    public boolean isatty(FileDescriptor fd) {
        return this.libc().isatty(this.helper.getfd(fd)) != 0;
    }

    @Override
    public int errno() {
        return LastError.getLastError((Runtime)this.getRuntime());
    }

    @Override
    public void errno(int value) {
        LastError.setLastError((Runtime)this.getRuntime(), (int)value);
    }

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public int posix_spawnp(String path, List<? extends POSIX.SpawnFileAction> fileActions, List<? extends CharSequence> argv, List<? extends CharSequence> envp) {
        CharSequence[] nativeArgv = new CharSequence[argv.size()];
        argv.toArray(nativeArgv);
        CharSequence[] nativeEnv = new CharSequence[envp.size()];
        envp.toArray(nativeEnv);
        return this.posix_spawnp(path, fileActions, argv, envp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int posix_spawnp(String path, List<? extends POSIX.SpawnFileAction> fileActions, CharSequence[] argv, CharSequence[] envp) {
        IntByReference pid = new IntByReference(-1);
        Pointer nativeFileActions = this.nativeFileActions(fileActions);
        try {
            if (this.libc().posix_spawnp(pid, path, nativeFileActions, null, argv, envp) < 0) {
                Errno e = Errno.valueOf((long)this.errno());
                this.handler.error(e, e.description());
            }
        }
        finally {
            this.libc.posix_spawn_file_actions_destroy(nativeFileActions);
        }
        return (Integer)pid.getValue();
    }

    private final Pointer nativeFileActions(List<? extends POSIX.SpawnFileAction> fileActions) {
        Pointer nativeFileActions = Memory.allocateDirect((Runtime)this.getRuntime(), (int)128);
        this.libc().posix_spawn_file_actions_init(nativeFileActions);
        for (POSIX.SpawnFileAction spawnFileAction : fileActions) {
            spawnFileAction.act(this, nativeFileActions);
        }
        return nativeFileActions;
    }

    @Override
    public abstract BaseHeapFileStat allocateStat();

    public static abstract class PointerConverter
    implements FromNativeConverter {
        public Class nativeType() {
            return Pointer.class;
        }
    }
}

