/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import com.kenai.jaffl.Library;
import com.kenai.jaffl.LibraryOption;
import java.util.HashMap;
import java.util.Map;
import org.jruby.ext.posix.FreeBSDPOSIX;
import org.jruby.ext.posix.JavaPOSIX;
import org.jruby.ext.posix.LibC;
import org.jruby.ext.posix.LibCProvider;
import org.jruby.ext.posix.LinuxLibC;
import org.jruby.ext.posix.LinuxPOSIX;
import org.jruby.ext.posix.MacOSPOSIX;
import org.jruby.ext.posix.OpenBSDPOSIX;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.POSIXTypeMapper;
import org.jruby.ext.posix.SolarisPOSIX;
import org.jruby.ext.posix.WindowsLibC;
import org.jruby.ext.posix.WindowsLibCFunctionMapper;
import org.jruby.ext.posix.WindowsPOSIX;
import org.jruby.ext.posix.util.Platform;

public class POSIXFactory {
    static final String LIBC = Platform.IS_LINUX ? "libc.so.6" : (Platform.IS_WINDOWS ? "msvcrt" : "c");
    static final Map<LibraryOption, Object> defaultOptions = new HashMap<LibraryOption, Object>(){
        {
            this.put(LibraryOption.TypeMapper, POSIXTypeMapper.INSTANCE);
        }
    };

    public static POSIX getPOSIX(POSIXHandler handler, boolean useNativePOSIX) {
        POSIX posix;
        block18: {
            posix = null;
            if (useNativePOSIX) {
                try {
                    if (Platform.IS_MAC) {
                        posix = POSIXFactory.loadMacOSPOSIX(handler);
                    } else if (Platform.IS_LINUX) {
                        posix = POSIXFactory.loadLinuxPOSIX(handler);
                    } else if (Platform.IS_FREEBSD) {
                        posix = POSIXFactory.loadFreeBSDPOSIX(handler);
                    } else if (Platform.IS_OPENBSD) {
                        posix = POSIXFactory.loadOpenBSDPOSIX(handler);
                    } else if (Platform.IS_SOLARIS) {
                        posix = POSIXFactory.loadSolarisPOSIX(handler);
                    } else if (Platform.IS_32_BIT && Platform.IS_WINDOWS) {
                        posix = POSIXFactory.loadWindowsPOSIX(handler);
                    }
                    if (handler.isVerbose()) {
                        if (posix != null) {
                            System.err.println("Successfully loaded native POSIX impl.");
                        } else {
                            System.err.println("Failed to load native POSIX impl; falling back on Java impl. Unsupported OS.");
                        }
                    }
                }
                catch (Throwable t) {
                    if (!handler.isVerbose()) break block18;
                    System.err.println("Failed to load native POSIX impl; falling back on Java impl. Stacktrace follows.");
                    t.printStackTrace();
                }
            }
        }
        if (posix == null) {
            posix = POSIXFactory.getJavaPOSIX(handler);
        }
        return posix;
    }

    public static POSIX getJavaPOSIX(POSIXHandler handler) {
        return new JavaPOSIX(handler);
    }

    public static POSIX loadLinuxPOSIX(POSIXHandler handler) {
        return new LinuxPOSIX(LIBC, new LinuxLibCProvider(), handler);
    }

    public static POSIX loadMacOSPOSIX(POSIXHandler handler) {
        return new MacOSPOSIX(LIBC, new DefaultLibCProvider(), handler);
    }

    public static POSIX loadSolarisPOSIX(POSIXHandler handler) {
        return new SolarisPOSIX(LIBC, new SolarisLibCProvider(), handler);
    }

    public static POSIX loadFreeBSDPOSIX(POSIXHandler handler) {
        return new FreeBSDPOSIX(LIBC, new DefaultLibCProvider(), handler);
    }

    public static POSIX loadOpenBSDPOSIX(POSIXHandler handler) {
        return new OpenBSDPOSIX(LIBC, new DefaultLibCProvider(), handler);
    }

    public static POSIX loadWindowsPOSIX(POSIXHandler handler) {
        return new WindowsPOSIX(LIBC, new WindowsLibCProvider(), handler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WindowsLibCProvider
    implements LibCProvider {
        private WindowsLibCProvider() {
        }

        @Override
        public final LibC getLibC() {
            return SingletonHolder.libc;
        }

        static final Map<LibraryOption, Object> getOptions() {
            HashMap<LibraryOption, Object> options = new HashMap<LibraryOption, Object>(defaultOptions);
            options.put(LibraryOption.FunctionMapper, new WindowsLibCFunctionMapper());
            return options;
        }

        static final class SingletonHolder {
            public static LibC libc = (LibC)Library.loadLibrary(WindowsLibC.class, WindowsLibCProvider.getOptions(), (String[])new String[]{"msvcrt"});

            SingletonHolder() {
            }
        }
    }

    private static final class SolarisLibCProvider
    implements LibCProvider {
        private SolarisLibCProvider() {
        }

        public final LibC getLibC() {
            return SingletonHolder.libc;
        }

        private static final class SingletonHolder {
            public static LibC libc = (LibC)Library.loadLibrary(LibC.class, defaultOptions, (String[])new String[]{"socket", "nsl", "c"});

            private SingletonHolder() {
            }
        }
    }

    private static final class LinuxLibCProvider
    implements LibCProvider {
        private LinuxLibCProvider() {
        }

        public final LibC getLibC() {
            return SingletonHolder.libc;
        }

        private static final class SingletonHolder {
            public static LibC libc = (LibC)Library.loadLibrary(LinuxLibC.class, defaultOptions, (String[])new String[]{"libc.so.6"});

            private SingletonHolder() {
            }
        }
    }

    private static final class DefaultLibCProvider
    implements LibCProvider {
        private DefaultLibCProvider() {
        }

        public final LibC getLibC() {
            return SingletonHolder.libc;
        }

        private static final class SingletonHolder {
            public static LibC libc = (LibC)Library.loadLibrary(LibC.class, defaultOptions, (String[])new String[]{"c"});

            private SingletonHolder() {
            }
        }
    }
}

