/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import jnr.ffi.Address;
import jnr.ffi.LibraryOption;
import jnr.ffi.NativeLong;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.annotations.StdCall;
import jnr.ffi.byref.ByReference;
import jnr.ffi.mapper.FromNativeConverter;
import jnr.ffi.mapper.FunctionMapper;
import jnr.ffi.mapper.MethodParameterContext;
import jnr.ffi.mapper.MethodResultContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.mapper.TypeMapper;
import jnr.ffi.provider.IdentityFunctionMapper;
import jnr.ffi.provider.NullTypeMapper;
import jnr.ffi.provider.ParameterFlags;
import jnr.ffi.provider.jffi.AbstractAsmLibraryInterface;
import jnr.ffi.provider.jffi.AsmBuilder;
import jnr.ffi.provider.jffi.AsmClassLoader;
import jnr.ffi.provider.jffi.AsmRuntime;
import jnr.ffi.provider.jffi.AsmUtil;
import jnr.ffi.provider.jffi.BufferMethodGenerator;
import jnr.ffi.provider.jffi.ByReferenceParameterConverter;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.FastIntMethodGenerator;
import jnr.ffi.provider.jffi.FastLongMethodGenerator;
import jnr.ffi.provider.jffi.FastNumericMethodGenerator;
import jnr.ffi.provider.jffi.InvokerUtil;
import jnr.ffi.provider.jffi.LibraryLoader;
import jnr.ffi.provider.jffi.MethodGenerator;
import jnr.ffi.provider.jffi.NativeClosureManager;
import jnr.ffi.provider.jffi.NativeLibrary;
import jnr.ffi.provider.jffi.NativeRuntime;
import jnr.ffi.provider.jffi.NoTrace;
import jnr.ffi.provider.jffi.NoX86;
import jnr.ffi.provider.jffi.NotImplMethodGenerator;
import jnr.ffi.provider.jffi.ParameterConverter;
import jnr.ffi.provider.jffi.ParameterType;
import jnr.ffi.provider.jffi.ResultConverter;
import jnr.ffi.provider.jffi.ResultType;
import jnr.ffi.provider.jffi.SkinnyMethodAdapter;
import jnr.ffi.provider.jffi.StubCompiler;
import jnr.ffi.provider.jffi.SymbolNotFoundError;
import jnr.ffi.provider.jffi.X86MethodGenerator;
import jnr.ffi.util.EnumMapper;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmLibraryLoader
extends LibraryLoader {
    public static final boolean DEBUG = Boolean.getBoolean("jnr.ffi.compile.dump");
    private static final AtomicLong nextClassID = new AtomicLong(0L);
    private final NativeRuntime runtime = NativeRuntime.getInstance();

    @Override
    boolean isInterfaceSupported(Class interfaceClass, Map<LibraryOption, ?> options) {
        TypeMapper typeMapper = options.containsKey((Object)LibraryOption.TypeMapper) ? (TypeMapper)options.get((Object)LibraryOption.TypeMapper) : NullTypeMapper.INSTANCE;
        for (Method m : interfaceClass.getDeclaredMethods()) {
            if (!AsmLibraryLoader.isReturnTypeSupported(m.getReturnType()) && this.getResultConverter(m, typeMapper) == null) {
                System.err.println("Unsupported return type: " + m.getReturnType());
                return false;
            }
            for (Class<?> c : m.getParameterTypes()) {
                if (AsmLibraryLoader.isParameterTypeSupported(c) || typeMapper.getToNativeConverter(c) != null) continue;
                System.err.println("Unsupported parameter type: " + c);
                return false;
            }
        }
        return true;
    }

    @Override
    <T> T loadLibrary(NativeLibrary library, Class<T> interfaceClass, Map<LibraryOption, ?> libraryOptions) {
        return this.generateInterfaceImpl(library, interfaceClass, libraryOptions);
    }

    private final <T> T generateInterfaceImpl(NativeLibrary library, Class<T> interfaceClass, Map<LibraryOption, ?> libraryOptions) {
        boolean debug = DEBUG && interfaceClass.getAnnotation(NoTrace.class) == null;
        ClassWriter cw = new ClassWriter(2);
        ClassWriter cv = debug ? AsmUtil.newCheckClassAdapter((ClassVisitor)cw) : cw;
        String className = CodegenUtils.p(interfaceClass) + "$jaffl$" + nextClassID.getAndIncrement();
        AsmBuilder builder = new AsmBuilder(className, (ClassVisitor)cv);
        cv.visit(49, 17, className, null, CodegenUtils.p(AbstractAsmLibraryInterface.class), new String[]{CodegenUtils.p(interfaceClass)});
        SkinnyMethodAdapter init = new SkinnyMethodAdapter(cv.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, NativeLibrary.class, Object[].class), null, null));
        init.start();
        init.aload(0);
        init.aload(1);
        init.invokespecial(CodegenUtils.p(AbstractAsmLibraryInterface.class), "<init>", CodegenUtils.sig(Void.TYPE, NativeLibrary.class));
        Method[] methods = interfaceClass.getMethods();
        FromNativeConverter[] resultConverters = new FromNativeConverter[methods.length];
        ToNativeConverter[][] parameterConverters = new ToNativeConverter[methods.length][0];
        FunctionMapper functionMapper = libraryOptions.containsKey((Object)LibraryOption.FunctionMapper) ? (FunctionMapper)libraryOptions.get((Object)LibraryOption.FunctionMapper) : IdentityFunctionMapper.getInstance();
        TypeMapper typeMapper = libraryOptions.containsKey((Object)LibraryOption.TypeMapper) ? (TypeMapper)libraryOptions.get((Object)LibraryOption.TypeMapper) : NullTypeMapper.INSTANCE;
        NativeClosureManager closureManager = new NativeClosureManager(this.runtime, typeMapper);
        CallingConvention libraryCallingConvention = AsmLibraryLoader.getCallingConvention(interfaceClass, libraryOptions);
        BufferMethodGenerator bufgen = new BufferMethodGenerator();
        StubCompiler compiler = StubCompiler.newCompiler();
        MethodGenerator[] generators = new MethodGenerator[]{interfaceClass.getAnnotation(NoX86.class) == null ? new X86MethodGenerator(compiler, bufgen) : new NotImplMethodGenerator(), new FastIntMethodGenerator(bufgen), new FastLongMethodGenerator(bufgen), new FastNumericMethodGenerator(bufgen), bufgen};
        block4: for (int i = 0; i < methods.length; ++i) {
            Function function;
            Method m = methods[i];
            Class<?> javaReturnType = m.getReturnType();
            Class[] javaParameterTypes = m.getParameterTypes();
            Annotation[] resultAnnotations = m.getAnnotations();
            Annotation[][] parameterAnnotations = m.getParameterAnnotations();
            resultConverters[i] = this.getResultConverter(m, typeMapper);
            ResultType resultType = InvokerUtil.getResultType(this.runtime, m.getReturnType(), resultAnnotations, resultConverters[i]);
            parameterConverters[i] = new ToNativeConverter[javaParameterTypes.length];
            ParameterType[] parameterTypes = new ParameterType[javaParameterTypes.length];
            for (int pidx = 0; pidx < javaParameterTypes.length; ++pidx) {
                parameterConverters[i][pidx] = this.getParameterConverter(m, pidx, typeMapper, closureManager);
                parameterTypes[pidx] = InvokerUtil.getParameterType(this.runtime, javaParameterTypes[pidx], parameterAnnotations[pidx], parameterConverters[i][pidx]);
            }
            String functionName = functionMapper.mapFunctionName(m.getName(), null);
            cv.visitField(26, "name_" + i, CodegenUtils.ci(String.class), null, (Object)functionName);
            CallingConvention callingConvention = m.getAnnotation(StdCall.class) != null ? CallingConvention.STDCALL : libraryCallingConvention;
            boolean saveErrno = InvokerUtil.requiresErrno(m);
            try {
                function = AsmLibraryLoader.getFunction(library.findSymbolAddress(functionName), resultType, parameterTypes, saveErrno, callingConvention);
            }
            catch (SymbolNotFoundError ex) {
                cv.visitField(26, "error_" + i, CodegenUtils.ci(String.class), null, (Object)ex.getMessage());
                this.generateFunctionNotFound((ClassVisitor)cv, className, i, functionName, javaReturnType, javaParameterTypes);
                continue;
            }
            for (MethodGenerator g : generators) {
                if (!g.isSupported(resultType, parameterTypes, callingConvention)) continue;
                g.generate(builder, m.getName(), function, resultType, parameterTypes, !saveErrno);
                continue block4;
            }
        }
        AsmBuilder.ObjectField[] fields = builder.getObjectFieldArray();
        Object[] fieldObjects = new Object[fields.length];
        for (int i = 0; i < fieldObjects.length; ++i) {
            fieldObjects[i] = fields[i].value;
            String fieldName = fields[i].name;
            cv.visitField(18, fieldName, CodegenUtils.ci(fields[i].klass), null, null);
            init.aload(0);
            init.aload(2);
            init.pushInt(i);
            init.aaload();
            if (fields[i].klass.isPrimitive()) {
                Class boxedType = AsmUtil.boxedType(fields[i].klass);
                init.checkcast(boxedType);
                AsmUtil.unboxNumber(init, boxedType, fields[i].klass);
            } else {
                init.checkcast(fields[i].klass);
            }
            init.putfield(className, fieldName, CodegenUtils.ci(fields[i].klass));
        }
        init.voidreturn();
        init.visitMaxs(10, 10);
        init.visitEnd();
        cv.visitEnd();
        try {
            byte[] bytes = cw.toByteArray();
            if (debug) {
                ClassVisitor trace = AsmUtil.newTraceClassVisitor(new PrintWriter(System.err));
                new ClassReader(bytes).accept(trace, 0);
            }
            Class implClass = new AsmClassLoader(interfaceClass.getClassLoader()).defineClass(className.replace("/", "."), bytes);
            Constructor cons = implClass.getDeclaredConstructor(NativeLibrary.class, Object[].class);
            Object result = cons.newInstance(library, fieldObjects);
            System.err.flush();
            System.out.flush();
            compiler.attach(implClass);
            return result;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private final ToNativeConverter getParameterConverter(Method m, int parameterIndex, TypeMapper typeMapper, NativeClosureManager closureManager) {
        Class<?> parameterType = m.getParameterTypes()[parameterIndex];
        ToNativeConverter conv = typeMapper.getToNativeConverter(parameterType);
        if (conv != null) {
            return new ParameterConverter(conv, new MethodParameterContext(m, parameterIndex));
        }
        if (Enum.class.isAssignableFrom(parameterType)) {
            return EnumMapper.getInstance(parameterType.asSubclass(Enum.class));
        }
        if (AsmUtil.isDelegate(parameterType)) {
            return closureManager.newClosureSite(parameterType);
        }
        if (ByReference.class.isAssignableFrom(parameterType)) {
            return new ByReferenceParameterConverter(ParameterFlags.parse(m.getParameterAnnotations()[parameterIndex]));
        }
        return null;
    }

    private final FromNativeConverter getResultConverter(Method m, TypeMapper typeMapper) {
        Class<?> returnType = m.getReturnType();
        FromNativeConverter conv = typeMapper.getFromNativeConverter(returnType);
        if (conv != null) {
            return new ResultConverter(conv, new MethodResultContext(m));
        }
        if (Enum.class.isAssignableFrom(returnType)) {
            return EnumMapper.getInstance(returnType.asSubclass(Enum.class));
        }
        return null;
    }

    private static final CallingConvention getCallingConvention(Class interfaceClass, Map<LibraryOption, ?> options) {
        if (interfaceClass.getAnnotation(StdCall.class) != null) {
            return CallingConvention.STDCALL;
        }
        return InvokerUtil.getCallingConvention(options);
    }

    private final void generateFunctionNotFound(ClassVisitor cv, String className, int idx, String functionName, Class returnType, Class[] parameterTypes) {
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cv.visitMethod(17, functionName, CodegenUtils.sig(returnType, parameterTypes), null, null));
        mv.start();
        mv.getstatic(className, "error_" + idx, CodegenUtils.ci(String.class));
        mv.invokestatic(AsmRuntime.class, "newUnsatisifiedLinkError", UnsatisfiedLinkError.class, String.class);
        mv.athrow();
        mv.visitMaxs(10, 10);
        mv.visitEnd();
    }

    private static Function getFunction(long address, ResultType resultType, ParameterType[] parameterTypes, boolean requiresErrno, CallingConvention convention) {
        return new Function(address, InvokerUtil.getCallContext(resultType, parameterTypes, convention, requiresErrno));
    }

    private static boolean isReturnTypeSupported(Class type) {
        return type.isPrimitive() || Byte.class == type || Short.class == type || Integer.class == type || Long.class == type || Float.class == type || Double.class == type || NativeLong.class == type || Enum.class.isAssignableFrom(type) || Pointer.class == type || Address.class == type || String.class == type || Struct.class.isAssignableFrom(type);
    }

    private static boolean isParameterTypeSupported(Class type) {
        return type.isPrimitive() || Byte.class == type || Short.class == type || Integer.class == type || Long.class == type || Float.class == type || Double.class == type || NativeLong.class == type || Pointer.class.isAssignableFrom(type) || Address.class.isAssignableFrom(type) || Enum.class.isAssignableFrom(type) || Buffer.class.isAssignableFrom(type) || type.isArray() && type.getComponentType().isPrimitive() || Struct.class.isAssignableFrom(type) || type.isArray() && Struct.class.isAssignableFrom(type.getComponentType()) || type.isArray() && Pointer.class.isAssignableFrom(type.getComponentType()) || type.isArray() && CharSequence.class.isAssignableFrom(type.getComponentType()) || CharSequence.class.isAssignableFrom(type) || ByReference.class.isAssignableFrom(type) || StringBuilder.class.isAssignableFrom(type) || StringBuffer.class.isAssignableFrom(type) || AsmUtil.isDelegate(type);
    }
}

