/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi;

import java.lang.reflect.Constructor;
import jnr.ffi.NativeType;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.ffi.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructLayout
implements Type {
    private final Runtime runtime;
    private final boolean isUnion = false;
    private boolean resetIndex = false;
    StructLayout enclosing = null;
    int offset = 0;
    int size = 0;
    int alignment = 1;
    int paddedSize = 0;

    protected StructLayout(Runtime runtime) {
        this.runtime = runtime;
    }

    public final Runtime getRuntime() {
        return this.runtime;
    }

    @Override
    public final int size() {
        return this.paddedSize;
    }

    @Override
    public final int alignment() {
        return this.alignment;
    }

    @Override
    public NativeType getNativeType() {
        return NativeType.STRUCT;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        java.lang.reflect.Field[] fields = this.getClass().getDeclaredFields();
        sb.append(this.getClass().getSimpleName()).append(" { \n");
        String fieldPrefix = "    ";
        for (java.lang.reflect.Field field : fields) {
            try {
                sb.append("    ").append('\n');
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    private static int align(int offset, int alignment) {
        return offset + alignment - 1 & ~(alignment - 1);
    }

    protected final int addField(int fieldSize, int fieldAlign, int offset) {
        this.size = Math.max(this.size, offset + fieldSize);
        this.alignment = Math.max(this.alignment, fieldAlign);
        this.paddedSize = StructLayout.align(this.size, this.alignment);
        return offset;
    }

    protected final int addField(int fieldSize, int fieldAlign, Struct.Offset offset) {
        return this.addField(fieldSize, fieldAlign, offset.intValue());
    }

    protected final int addField(int fieldSize, int fieldAlign) {
        return this.addField(fieldSize, fieldAlign, this.resetIndex ? 0 : StructLayout.align(this.size, fieldAlign));
    }

    protected final int addField(Type t) {
        return this.addField(t.size(), t.alignment());
    }

    protected final int addField(Type t, int offset) {
        return this.addField(t.size(), t.alignment(), offset);
    }

    protected final int addField(Type t, Struct.Offset offset) {
        return this.addField(t, offset.intValue());
    }

    protected final void arrayBegin() {
        this.resetIndex = false;
    }

    protected final void arrayEnd() {
        this.resetIndex = false;
    }

    protected <T extends Field> T[] array(T[] array) {
        this.arrayBegin();
        try {
            Class<?> arrayClass = array.getClass().getComponentType();
            Constructor<?> ctor = arrayClass.getDeclaredConstructor(arrayClass.getEnclosingClass());
            Object[] parameters = new Object[]{this};
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Field)ctor.newInstance(parameters);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.arrayEnd();
        return array;
    }

    protected final <T extends StructLayout> T inner(T structLayout) {
        structLayout.offset = StructLayout.align(this.size, structLayout.alignment);
        structLayout.enclosing = this;
        this.size = structLayout.offset + structLayout.size;
        this.paddedSize = StructLayout.align(this.size, structLayout.alignment());
        return structLayout;
    }

    protected final class Padding
    extends AbstractField {
        public Padding(Type type, int length) {
            super(type.size() * length, type.alignment());
        }

        public Padding(NativeType type, int length) {
            this(structLayout.getRuntime().findType(type), length);
        }
    }

    public class Pointer
    extends NumberField {
        public Pointer() {
            super(NativeType.ADDRESS);
        }

        public Pointer(Struct.Offset offset) {
            super(NativeType.ADDRESS, offset);
        }

        public final jnr.ffi.Pointer get(jnr.ffi.Pointer ptr) {
            return ptr.getPointer(this.offset());
        }

        public final int size() {
            return StructLayout.this.getRuntime().findType(NativeType.ADDRESS).size() * 8;
        }

        public final void set(jnr.ffi.Pointer ptr, jnr.ffi.Pointer value) {
            ptr.putPointer(this.offset(), value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putAddress(this.offset(), value.longValue());
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return (int)ptr.getAddress(this.offset());
        }

        public final long longValue(jnr.ffi.Pointer ptr) {
            return ptr.getAddress(this.offset());
        }

        public final String toString(jnr.ffi.Pointer ptr) {
            return this.get(ptr).toString();
        }
    }

    public final class Double
    extends NumberField {
        public Double() {
            super(NativeType.DOUBLE);
        }

        public Double(Struct.Offset offset) {
            super(NativeType.DOUBLE, offset);
        }

        public final double get(jnr.ffi.Pointer ptr) {
            return ptr.getDouble(this.offset());
        }

        public final void set(jnr.ffi.Pointer ptr, double value) {
            ptr.putDouble(this.offset(), value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putDouble(this.offset(), value.doubleValue());
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return (int)this.get(ptr);
        }

        public final long longValue(jnr.ffi.Pointer ptr) {
            return (long)this.get(ptr);
        }

        public final float floatValue(jnr.ffi.Pointer ptr) {
            return (float)this.get(ptr);
        }

        public final double doubleValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final String toString(jnr.ffi.Pointer ptr) {
            return String.valueOf(this.get(ptr));
        }
    }

    public class Float
    extends NumberField {
        public Float() {
            super(NativeType.FLOAT);
        }

        public Float(Struct.Offset offset) {
            super(NativeType.FLOAT, offset);
        }

        public final float get(jnr.ffi.Pointer ptr) {
            return ptr.getFloat(this.offset());
        }

        public final void set(jnr.ffi.Pointer ptr, float value) {
            ptr.putFloat(this.offset(), value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putFloat(this.offset(), value.floatValue());
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return (int)this.get(ptr);
        }

        public final double doubleValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final float floatValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final long longValue(jnr.ffi.Pointer ptr) {
            return (long)this.get(ptr);
        }

        public final String toString(jnr.ffi.Pointer ptr) {
            return String.valueOf(this.get(ptr));
        }
    }

    public class UnsignedLong
    extends NumberField {
        public UnsignedLong() {
            super(NativeType.ULONG);
        }

        public UnsignedLong(Struct.Offset offset) {
            super(NativeType.ULONG, offset);
        }

        public final long get(jnr.ffi.Pointer ptr) {
            long value = ptr.getNativeLong(this.offset());
            long mask = StructLayout.this.getRuntime().findType(NativeType.SLONG).size() == 32 ? 0xFFFFFFFFL : -1L;
            return value < 0L ? (value & mask) + mask + 1L : value;
        }

        public final void set(jnr.ffi.Pointer ptr, long value) {
            ptr.putNativeLong(this.offset(), value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putNativeLong(this.offset(), value.longValue());
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return (int)this.get(ptr);
        }

        public final long longValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final String toString(jnr.ffi.Pointer ptr) {
            return Long.toString(this.get(ptr));
        }
    }

    public class SignedLong
    extends NumberField {
        public SignedLong() {
            super(NativeType.SLONG);
        }

        public SignedLong(Struct.Offset offset) {
            super(NativeType.SLONG, offset);
        }

        public final long get(jnr.ffi.Pointer ptr) {
            return ptr.getNativeLong(this.offset());
        }

        public final void set(jnr.ffi.Pointer ptr, long value) {
            ptr.putNativeLong(this.offset(), value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putNativeLong(this.offset(), value.longValue());
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return (int)this.get(ptr);
        }

        public final long longValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final String toString(jnr.ffi.Pointer ptr) {
            return Long.toString(this.get(ptr));
        }
    }

    public class Unsigned64
    extends NumberField {
        public Unsigned64() {
            super(NativeType.ULONGLONG);
        }

        public Unsigned64(Struct.Offset offset) {
            super(NativeType.ULONGLONG, offset);
        }

        public final long get(jnr.ffi.Pointer ptr) {
            return ptr.getLongLong(this.offset());
        }

        public final void set(jnr.ffi.Pointer ptr, long value) {
            ptr.putLongLong(this.offset(), value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putLongLong(this.offset(), value.longValue());
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return (int)this.get(ptr);
        }

        public final long longValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final String toString(jnr.ffi.Pointer ptr) {
            return Long.toString(this.get(ptr));
        }
    }

    public class Signed64
    extends NumberField {
        public Signed64() {
            super(NativeType.SLONGLONG);
        }

        public Signed64(Struct.Offset offset) {
            super(NativeType.SLONGLONG, offset);
        }

        public final long get(jnr.ffi.Pointer ptr) {
            return ptr.getLongLong(this.offset());
        }

        public final void set(jnr.ffi.Pointer ptr, long value) {
            ptr.putLongLong(this.offset(), value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putLongLong(this.offset(), value.longValue());
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return (int)this.get(ptr);
        }

        public final long longValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final String toString(jnr.ffi.Pointer ptr) {
            return Long.toString(this.get(ptr));
        }
    }

    public class Unsigned32
    extends NumberField {
        public Unsigned32() {
            super(NativeType.UINT);
        }

        public Unsigned32(Struct.Offset offset) {
            super(NativeType.SINT, offset);
        }

        public final long get(jnr.ffi.Pointer ptr) {
            long value = ptr.getInt(this.offset());
            return value < 0L ? (value & Integer.MAX_VALUE) + 0x80000000L : value;
        }

        public final void set(jnr.ffi.Pointer ptr, long value) {
            ptr.putInt(this.offset(), (int)value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putInt(this.offset(), value.intValue());
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return (int)this.get(ptr);
        }

        public final long longValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }
    }

    public class Signed32
    extends NumberField {
        public Signed32() {
            super(NativeType.SINT);
        }

        public Signed32(Struct.Offset offset) {
            super(NativeType.SINT, offset);
        }

        public final int get(jnr.ffi.Pointer ptr) {
            return ptr.getInt(this.offset());
        }

        public final void set(jnr.ffi.Pointer ptr, int value) {
            ptr.putInt(this.offset(), value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putInt(this.offset(), value.intValue());
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }
    }

    public class Unsigned16
    extends NumberField {
        public Unsigned16() {
            super(NativeType.USHORT);
        }

        public Unsigned16(Struct.Offset offset) {
            super(NativeType.USHORT, offset);
        }

        public final int get(jnr.ffi.Pointer ptr) {
            int value = ptr.getShort(this.offset());
            return value < 0 ? (value & Short.MAX_VALUE) + 32768 : value;
        }

        public final void set(jnr.ffi.Pointer ptr, int value) {
            ptr.putShort(this.offset(), (short)value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putShort(this.offset(), value.shortValue());
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }
    }

    public class Signed16
    extends NumberField {
        public Signed16() {
            super(NativeType.SSHORT);
        }

        public Signed16(Struct.Offset offset) {
            super(NativeType.SSHORT, offset);
        }

        public final short get(jnr.ffi.Pointer ptr) {
            return ptr.getShort(this.offset());
        }

        public final void set(jnr.ffi.Pointer ptr, short value) {
            ptr.putShort(this.offset(), value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putShort(this.offset(), value.shortValue());
        }

        public final short shortValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }
    }

    public class Unsigned8
    extends NumberField {
        public Unsigned8() {
            super(NativeType.UCHAR);
        }

        public Unsigned8(Struct.Offset offset) {
            super(NativeType.UCHAR, offset);
        }

        public final short get(jnr.ffi.Pointer ptr) {
            short value = ptr.getByte(this.offset());
            return value < 0 ? (short)((value & 0x7F) + 128) : value;
        }

        public final void set(jnr.ffi.Pointer ptr, short value) {
            ptr.putByte(this.offset(), (byte)value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putByte(this.offset(), value.byteValue());
        }

        public final short shortValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }
    }

    public class Signed8
    extends NumberField {
        public Signed8() {
            super(NativeType.SCHAR);
        }

        public Signed8(Struct.Offset offset) {
            super(NativeType.SCHAR, offset);
        }

        public final byte get(jnr.ffi.Pointer ptr) {
            return ptr.getByte(this.offset());
        }

        public final void set(jnr.ffi.Pointer ptr, byte value) {
            ptr.putByte(this.offset(), value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putByte(this.offset(), value.byteValue());
        }

        public final byte byteValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final short shortValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }
    }

    protected abstract class NumberField
    extends AbstractField {
        protected NumberField(NativeType type) {
            super(type);
        }

        protected NumberField(NativeType type, Struct.Offset offset) {
            super(type, offset);
        }

        public abstract void set(jnr.ffi.Pointer var1, Number var2);

        public double doubleValue(jnr.ffi.Pointer ptr) {
            return this.longValue(ptr);
        }

        public float floatValue(jnr.ffi.Pointer ptr) {
            return this.intValue(ptr);
        }

        public byte byteValue(jnr.ffi.Pointer ptr) {
            return (byte)this.intValue(ptr);
        }

        public short shortValue(jnr.ffi.Pointer ptr) {
            return (short)this.intValue(ptr);
        }

        public abstract int intValue(jnr.ffi.Pointer var1);

        public long longValue(jnr.ffi.Pointer ptr) {
            return this.intValue(ptr);
        }

        public String toString(jnr.ffi.Pointer ptr) {
            return Integer.toString(this.intValue(ptr), 10);
        }
    }

    protected final class WBOOL
    extends AbstractBoolean {
        protected WBOOL() {
            super(NativeType.SINT);
        }

        public final boolean get(jnr.ffi.Pointer ptr) {
            return (ptr.getInt(this.offset()) & 1) != 0;
        }

        public final void set(jnr.ffi.Pointer ptr, boolean value) {
            ptr.putInt(this.offset(), value ? 1 : 0);
        }
    }

    protected final class Boolean
    extends AbstractBoolean {
        protected Boolean() {
            super(NativeType.SCHAR);
        }

        public final boolean get(jnr.ffi.Pointer ptr) {
            return (ptr.getByte(this.offset()) & 1) != 0;
        }

        public final void set(jnr.ffi.Pointer ptr, boolean value) {
            ptr.putByte(this.offset(), (byte)(value ? 1 : 0));
        }
    }

    protected abstract class AbstractBoolean
    extends AbstractField {
        protected AbstractBoolean(NativeType type) {
            super(type);
        }

        public abstract boolean get(jnr.ffi.Pointer var1);

        public abstract void set(jnr.ffi.Pointer var1, boolean var2);

        public String toString(jnr.ffi.Pointer ptr) {
            return java.lang.Boolean.toString(this.get(ptr));
        }
    }

    protected abstract class AbstractField
    implements Field {
        private final int offset;

        protected AbstractField(int size, int align, Struct.Offset offset) {
            this.offset = StructLayout.this.addField(size, align, offset.intValue());
        }

        protected AbstractField(int size, int align) {
            this.offset = StructLayout.this.addField(size, align);
        }

        protected AbstractField(NativeType type) {
            this.offset = StructLayout.this.addField(StructLayout.this.getRuntime().findType(type));
        }

        protected AbstractField(NativeType type, Struct.Offset offset) {
            this.offset = StructLayout.this.addField(StructLayout.this.getRuntime().findType(type), offset);
        }

        public final StructLayout enclosing() {
            return StructLayout.this;
        }

        public final long offset() {
            return this.offset + StructLayout.this.offset;
        }
    }

    protected static interface Field {
        public StructLayout enclosing();

        public long offset();
    }
}

