/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.LastError;
import java.nio.ByteOrder;
import java.util.EnumMap;
import java.util.EnumSet;
import jnr.ffi.NativeType;
import jnr.ffi.ObjectReferenceManager;
import jnr.ffi.Type;
import jnr.ffi.provider.AbstractRuntime;
import jnr.ffi.provider.BadType;
import jnr.ffi.provider.DefaultObjectReferenceManager;
import jnr.ffi.provider.jffi.NativeClosureManager;
import jnr.ffi.provider.jffi.NativeMemoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeRuntime
extends AbstractRuntime {
    private final NativeMemoryManager mm = new NativeMemoryManager(this);
    private final NativeClosureManager closureManager = new NativeClosureManager(this);

    public static final NativeRuntime getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private NativeRuntime() {
        super(ByteOrder.nativeOrder(), NativeRuntime.buildTypeMap());
    }

    private static EnumMap<NativeType, Type> buildTypeMap() {
        EnumMap<NativeType, Type> typeMap = new EnumMap<NativeType, Type>(NativeType.class);
        EnumSet<NativeType> nativeTypes = EnumSet.allOf(NativeType.class);
        for (NativeType t : nativeTypes) {
            typeMap.put(t, NativeRuntime.jafflType(t));
        }
        return typeMap;
    }

    @Override
    public final NativeMemoryManager getMemoryManager() {
        return this.mm;
    }

    public NativeClosureManager getClosureManager() {
        return this.closureManager;
    }

    @Override
    public ObjectReferenceManager newObjectReferenceManager() {
        return new DefaultObjectReferenceManager(this);
    }

    @Override
    public int getLastError() {
        return LastError.getInstance().get();
    }

    @Override
    public void setLastError(int error) {
        LastError.getInstance().set(error);
    }

    private static final Type jafflType(NativeType type) {
        switch (type) {
            case VOID: {
                return new TypeDelegate(com.kenai.jffi.Type.VOID);
            }
            case SCHAR: {
                return new TypeDelegate(com.kenai.jffi.Type.SCHAR);
            }
            case UCHAR: {
                return new TypeDelegate(com.kenai.jffi.Type.UCHAR);
            }
            case SSHORT: {
                return new TypeDelegate(com.kenai.jffi.Type.SSHORT);
            }
            case USHORT: {
                return new TypeDelegate(com.kenai.jffi.Type.USHORT);
            }
            case SINT: {
                return new TypeDelegate(com.kenai.jffi.Type.SINT);
            }
            case UINT: {
                return new TypeDelegate(com.kenai.jffi.Type.UINT);
            }
            case SLONG: {
                return new TypeDelegate(com.kenai.jffi.Type.SLONG);
            }
            case ULONG: {
                return new TypeDelegate(com.kenai.jffi.Type.ULONG);
            }
            case SLONGLONG: {
                return new TypeDelegate(com.kenai.jffi.Type.SINT64);
            }
            case ULONGLONG: {
                return new TypeDelegate(com.kenai.jffi.Type.UINT64);
            }
            case FLOAT: {
                return new TypeDelegate(com.kenai.jffi.Type.FLOAT);
            }
            case DOUBLE: {
                return new TypeDelegate(com.kenai.jffi.Type.DOUBLE);
            }
            case ADDRESS: {
                return new TypeDelegate(com.kenai.jffi.Type.POINTER);
            }
        }
        return new BadType(type);
    }

    private static final class TypeDelegate
    implements Type {
        private final com.kenai.jffi.Type type;

        public TypeDelegate(com.kenai.jffi.Type type) {
            this.type = type;
        }

        public int alignment() {
            return this.type.alignment();
        }

        public int size() {
            return this.type.size();
        }

        public String toString() {
            return this.type.toString();
        }
    }

    private static final class SingletonHolder {
        public static final NativeRuntime INSTANCE = new NativeRuntime();

        private SingletonHolder() {
        }
    }
}

