/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import java.util.HashMap;
import java.util.Map;
import jnr.ffi.provider.ClosureManager;
import jnr.ffi.provider.jffi.NativeClosureFactory;
import jnr.ffi.provider.jffi.NativeRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NativeClosureManager
implements ClosureManager {
    private volatile Map<Class<? extends Object>, NativeClosureFactory> factories = new HashMap<Class<? extends Object>, NativeClosureFactory>();
    private final NativeRuntime runtime;

    NativeClosureManager(NativeRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public <T> T newClosure(Class<? extends T> closureClass, T instance) {
        NativeClosureFactory factory = this.factories.get(closureClass);
        if (factory != null) {
            // empty if block
        }
        return null;
    }

    synchronized <T> NativeClosureFactory<T> getClosureFactory(Class<T> closureClass) {
        NativeClosureFactory factory = this.factories.get(closureClass);
        if (factory != null) {
            return factory;
        }
        factory = NativeClosureFactory.newClosureFactory(this.runtime, closureClass);
        this.factories.put(closureClass, factory);
        return factory;
    }
}

