/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.Platform;
import java.lang.annotation.Annotation;
import java.nio.Buffer;
import jnr.ffi.NativeLong;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.provider.jffi.AbstractFastNumericMethodGenerator;
import jnr.ffi.provider.jffi.AsmUtil;
import jnr.ffi.provider.jffi.BufferMethodGenerator;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.Signature;

class FastNumericMethodGenerator
extends AbstractFastNumericMethodGenerator {
    private static final int MAX_PARAMETERS = FastNumericMethodGenerator.getMaximumParameters();
    private static final String[] signatures;
    private static final String[] methodNames;

    FastNumericMethodGenerator(BufferMethodGenerator bufgen) {
        super(bufgen);
    }

    public boolean isSupported(Signature signature) {
        int parameterCount = signature.parameterTypes.length;
        if (signature.callingConvention != CallingConvention.DEFAULT || parameterCount > MAX_PARAMETERS) {
            return false;
        }
        Platform platform = Platform.getPlatform();
        if (platform.getCPU() != Platform.CPU.I386 && platform.getCPU() != Platform.CPU.X86_64) {
            return false;
        }
        if (platform.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return false;
        }
        for (int i = 0; i < parameterCount; ++i) {
            if (FastNumericMethodGenerator.isFastNumericParameter(platform, signature.parameterTypes[i], signature.parameterAnnotations[i])) continue;
            return false;
        }
        return FastNumericMethodGenerator.isFastNumericResult(platform, signature.resultType, signature.resultAnnotations);
    }

    String getInvokerMethodName(Class returnType, Annotation[] resultAnnotations, Class[] parameterTypes, Annotation[][] parameterAnnotations, boolean ignoreErrno) {
        int parameterCount = parameterTypes.length;
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= methodNames.length) {
            return methodNames[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-numeric parameter count: " + parameterCount);
    }

    String getInvokerSignature(int parameterCount, Class nativeIntType) {
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= signatures.length) {
            return signatures[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-numeric parameter count: " + parameterCount);
    }

    Class getInvokerType() {
        return Long.TYPE;
    }

    private static boolean isNumericType(Platform platform, Class type, Annotation[] annotations) {
        return Boolean.class.isAssignableFrom(type) || Boolean.TYPE == type || Byte.class.isAssignableFrom(type) || Byte.TYPE == type || Short.class.isAssignableFrom(type) || Short.TYPE == type || Integer.class.isAssignableFrom(type) || Integer.TYPE == type || Long.class == type || Long.TYPE == type || NativeLong.class == type || Pointer.class.isAssignableFrom(type) || Struct.class.isAssignableFrom(type) || Float.TYPE == type || Float.class == type || Double.TYPE == type || Double.class == type;
    }

    static final boolean isFastNumericResult(Platform platform, Class type, Annotation[] annotations) {
        return FastNumericMethodGenerator.isNumericType(platform, type, annotations) || String.class == type;
    }

    static final boolean isFastNumericParameter(Platform platform, Class type, Annotation[] annotations) {
        return FastNumericMethodGenerator.isNumericType(platform, type, annotations) || Buffer.class.isAssignableFrom(type) || AsmUtil.isDelegate(type);
    }

    static final int getMaximumParameters() {
        try {
            Invoker.class.getDeclaredMethod("invokeNNNNNNrN", Function.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
            return 6;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    static {
        methodNames = new String[]{"invokeVrN", "invokeNrN", "invokeNNrN", "invokeNNNrN", "invokeNNNNrN", "invokeNNNNNrN", "invokeNNNNNNrN"};
        signatures = new String[MAX_PARAMETERS + 1];
        for (int i = 0; i <= MAX_PARAMETERS; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append('(').append(CodegenUtils.ci(Function.class));
            for (int n = 0; n < i; ++n) {
                sb.append('J');
            }
            FastNumericMethodGenerator.signatures[i] = sb.append(")J").toString();
        }
    }
}

